/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.ConstraintVisitingInfo;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public abstract class CustomTypeParameterSubstitutor
extends TypeParameterSubstitutor<ConstraintVisitingInfo> {
    protected CustomTypeParameterSubstitutor(Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> typeParameterMapping, ITypeReferenceOwner owner) {
        super(typeParameterMapping, owner);
    }

    @Override
    public LightweightTypeReference doVisitParameterizedTypeReference(ParameterizedTypeReference reference, ConstraintVisitingInfo visiting) {
        if (reference.isResolved() && reference.isOwnedBy(this.getOwner())) {
            return reference;
        }
        JvmType type = reference.getType();
        if (type instanceof JvmTypeParameter) {
            JvmTypeParameter typeParameter = (JvmTypeParameter)type;
            if (!visiting.tryVisit(typeParameter)) {
                if (!this.isDeclaredTypeParameter(typeParameter)) {
                    if (visiting.getCurrentDeclarator() != null) {
                        LightweightTypeReference mappedReference = this.getDeclaredUpperBound(visiting.getCurrentDeclarator(), visiting.getCurrentIndex(), visiting);
                        this.getTypeParameterMapping().put((JvmTypeParameter)type, new LightweightMergedBoundTypeArgument(mappedReference, VarianceInfo.INVARIANT));
                        return mappedReference;
                    }
                    LightweightMergedBoundTypeArgument candidate = this.getTypeParameterMapping().get(typeParameter);
                    if (candidate != null && candidate.getTypeReference() != null) {
                        return candidate.getTypeReference();
                    }
                    LightweightTypeReference mappedReference = this.getDeclaredUpperBound(typeParameter, visiting);
                    if (mappedReference == null) {
                        mappedReference = this.getObjectReference((EObject)typeParameter);
                    }
                    this.getTypeParameterMapping().put((JvmTypeParameter)type, new LightweightMergedBoundTypeArgument(mappedReference, VarianceInfo.INVARIANT));
                    return mappedReference;
                }
            } else {
                try {
                    LightweightMergedBoundTypeArgument boundTypeArgument = this.getBoundTypeArgument(typeParameter, visiting);
                    if (boundTypeArgument != null && boundTypeArgument.getTypeReference() != reference) {
                        LightweightTypeReference result = boundTypeArgument.getTypeReference().accept(this, visiting);
                        if (boundTypeArgument.getVariance() == VarianceInfo.OUT) {
                            WildcardTypeReference wildcard = new WildcardTypeReference(this.getOwner());
                            wildcard.addUpperBound(result);
                            result = wildcard;
                        } else if (boundTypeArgument.getVariance() == VarianceInfo.IN) {
                            WildcardTypeReference wildcard = new WildcardTypeReference(this.getOwner());
                            JvmType objectType = this.getOwner().getServices().getTypeReferences().findDeclaredType(Object.class, (Notifier)type);
                            wildcard.addUpperBound(new ParameterizedTypeReference(this.getOwner(), objectType));
                            wildcard.setLowerBound(result);
                            result = wildcard;
                        }
                        LightweightTypeReference lightweightTypeReference = result;
                        return lightweightTypeReference;
                    }
                    LightweightTypeReference mappedReference = this.getUnmappedSubstitute(reference, (JvmTypeParameter)type, visiting);
                    if (mappedReference != null) {
                        this.getTypeParameterMapping().put((JvmTypeParameter)type, new LightweightMergedBoundTypeArgument(mappedReference, VarianceInfo.INVARIANT));
                        LightweightTypeReference lightweightTypeReference = mappedReference;
                        return lightweightTypeReference;
                    }
                }
                finally {
                    visiting.didVisit(typeParameter);
                }
            }
        }
        return this.doVisitParameterizedTypeReference(reference, type, visiting);
    }

    @Override
    protected LightweightTypeReference doVisitParameterizedTypeReference(ParameterizedTypeReference reference, JvmType type, ConstraintVisitingInfo visiting) {
        ParameterizedTypeReference result = new ParameterizedTypeReference(this.getOwner(), type);
        int i = 0;
        while (i < reference.getTypeArguments().size()) {
            LightweightTypeReference argument = reference.getTypeArguments().get(i);
            visiting.pushInfo(type instanceof JvmTypeParameterDeclarator ? (JvmTypeParameterDeclarator)type : null, i);
            LightweightTypeReference visitedArgument = argument.accept(this, visiting);
            result.addTypeArgument(visitedArgument);
            ++i;
        }
        return result;
    }

    protected boolean isDeclaredTypeParameter(JvmTypeParameter typeParameter) {
        return this.getOwner().getDeclaredTypeParameters().contains(typeParameter);
    }

    @Nullable
    protected LightweightMergedBoundTypeArgument getBoundTypeArgument(JvmTypeParameter type, ConstraintVisitingInfo info) {
        return this.getTypeParameterMapping().get(type);
    }

    @Nullable
    protected abstract LightweightTypeReference getUnmappedSubstitute(ParameterizedTypeReference var1, JvmTypeParameter var2, ConstraintVisitingInfo var3);

    protected LightweightTypeReference getDeclaredUpperBound(JvmTypeParameterDeclarator type, int parameterIndex, ConstraintVisitingInfo visiting) {
        JvmTypeParameter typeParameter;
        LightweightTypeReference result;
        if (type.getTypeParameters().size() > parameterIndex && (result = this.getDeclaredUpperBound(typeParameter = (JvmTypeParameter)type.getTypeParameters().get(parameterIndex), visiting)) != null) {
            return result;
        }
        return this.getObjectReference((EObject)type);
    }

    protected LightweightTypeReference getObjectReference(EObject context) {
        JvmType objectType = this.getOwner().getServices().getTypeReferences().findDeclaredType(Object.class, (Notifier)context);
        return new ParameterizedTypeReference(this.getOwner(), objectType);
    }

    @Nullable
    protected LightweightTypeReference getDeclaredUpperBound(JvmTypeParameter typeParameter, ConstraintVisitingInfo visiting) {
        JvmTypeConstraint constraint;
        if (!typeParameter.getConstraints().isEmpty() && (constraint = (JvmTypeConstraint)typeParameter.getConstraints().get(0)) instanceof JvmUpperBound) {
            LightweightTypeReference reference = new OwnedConverter(this.getOwner()).toLightweightReference(constraint.getTypeReference());
            if (visiting.getCurrentDeclarator() != reference.getType()) {
                return reference.accept(this, visiting);
            }
            WildcardTypeReference result = new WildcardTypeReference(this.getOwner());
            result.addUpperBound(this.getObjectReference((EObject)typeParameter));
            return result;
        }
        return null;
    }

    @Override
    public LightweightTypeReference substitute(LightweightTypeReference original) {
        LightweightTypeReference componentType;
        if (original instanceof ArrayTypeReference && (componentType = original.getComponentType()) instanceof UnboundTypeReference) {
            LightweightTypeReference substitutedComponentType = this.substitute(componentType);
            return new ArrayTypeReference(this.getOwner(), substitutedComponentType);
        }
        if (original instanceof UnboundTypeReference) {
            ConstraintVisitingInfo visitingInfo = this.createVisiting();
            JvmTypeParameter typeParameter = ((UnboundTypeReference)original).getTypeParameter();
            JvmTypeParameterDeclarator declarator = typeParameter.getDeclarator();
            visitingInfo.pushInfo(declarator, declarator.getTypeParameters().indexOf((Object)typeParameter));
            LightweightTypeReference result = original.accept(this, visitingInfo);
            return result;
        }
        LightweightTypeReference result = original.accept(this, this.createVisiting());
        return result;
    }

    @Override
    protected ConstraintVisitingInfo createVisiting() {
        return new ConstraintVisitingInfo();
    }

    protected ConstraintVisitingInfo createVisiting(JvmTypeParameter initialValue) {
        ConstraintVisitingInfo result = this.createVisiting();
        result.tryVisit(initialValue);
        return result;
    }
}

