/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.ToStringHelper;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Inline;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.InlineParser;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.InlineWithNestedContents;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.LinkAttributes;

public class Link
extends InlineWithNestedContents {
    private final String href;
    private final String title;

    public Link(Line line, int offset, int length, String href, String title, List<Inline> contents) {
        super(line, offset, length, contents);
        this.href = (String)Preconditions.checkNotNull((Object)href);
        this.title = title;
    }

    public String getHref() {
        return this.href;
    }

    @Override
    public void emit(DocumentBuilder builder) {
        LinkAttributes attributes = new LinkAttributes();
        attributes.setTitle(this.title);
        attributes.setHref(this.href);
        builder.beginSpan(DocumentBuilder.SpanType.LINK, (Attributes)attributes);
        InlineParser.emit(builder, this.getContents());
        builder.endSpan();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getOffset(), this.getLength(), this.getContents(), this.href, this.title);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Link other = (Link)obj;
        return this.href.equals(other.href) && this.getContents().equals(other.getContents()) && Objects.equals(this.title, other.title);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(Link.class).add("offset", this.getOffset()).add("length", this.getLength()).add("href", (Object)ToStringHelper.toStringValue(this.href)).add("title", (Object)this.title).add("contents", this.getContents()).toString();
    }
}

