/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.TextSegment;

public class Cursor {
    private final TextSegment segment;
    private final String text;
    private int textOffset;

    public Cursor(TextSegment segment) {
        this.segment = (TextSegment)Preconditions.checkNotNull((Object)segment);
        this.text = segment.getText();
        this.textOffset = 0;
    }

    public int getOffset() {
        return this.getOffset(this.textOffset);
    }

    public int getOffset(int cursorOffset) {
        return this.segment.offsetOf(cursorOffset);
    }

    public int toCursorOffset(int documentOffset) {
        return this.segment.toTextOffset(documentOffset);
    }

    public char getChar() {
        return this.text.charAt(this.textOffset);
    }

    public char getChar(int offset) {
        return this.text.charAt(offset);
    }

    public boolean hasChar() {
        return this.textOffset < this.text.length();
    }

    public String getText(int offset, int endIndex) {
        return this.text.substring(offset, endIndex);
    }

    public char getPrevious() {
        return this.getPrevious(1);
    }

    public boolean hasPrevious() {
        return this.hasPrevious(1);
    }

    public boolean hasPrevious(int offset) {
        return this.textOffset - offset >= 0;
    }

    public char getPrevious(int offset) {
        int charOffset = this.textOffset - offset;
        Preconditions.checkArgument((charOffset >= 0 ? 1 : 0) != 0);
        return this.text.charAt(charOffset);
    }

    public char getNext() {
        return this.getNext(1);
    }

    public char getNext(int offset) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0);
        return this.text.charAt(this.textOffset + offset);
    }

    public String getTextAtOffset() {
        return this.text.substring(this.textOffset, this.text.length());
    }

    public String getTextAtOffset(int length) {
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0);
        return this.text.substring(this.textOffset, this.textOffset + length);
    }

    public boolean hasNext() {
        return this.hasNext(1);
    }

    public boolean hasNext(int offset) {
        Preconditions.checkArgument((offset > 0 ? 1 : 0) != 0);
        return this.textOffset + offset < this.text.length();
    }

    public Matcher matcher(Pattern pattern) {
        return this.matcher(0, pattern);
    }

    public Matcher matcher(int offset, Pattern pattern) {
        Preconditions.checkArgument((offset >= 0 && offset + this.textOffset < this.text.length() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)pattern);
        Matcher matcher = pattern.matcher(this.text);
        matcher.region(this.textOffset + offset, this.text.length());
        return matcher;
    }

    public void advance() {
        if (this.textOffset < this.text.length()) {
            ++this.textOffset;
        }
    }

    public void advance(int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0);
        for (int x = 0; x < count; ++x) {
            this.advance();
        }
    }

    public void rewind(int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0);
        for (int x = 0; x < count; ++x) {
            this.rewind();
        }
    }

    public void rewind() {
        if (this.textOffset > 0) {
            --this.textOffset;
        }
    }

    public Line getLineAtOffset() {
        return this.segment.getLineAtOffset(this.textOffset);
    }
}

