/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.epub.internal;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.mylyn.docs.epub.internal.AbstractXHTMLScanner;
import org.eclipse.mylyn.docs.epub.opf.Item;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ReferenceScanner
extends AbstractXHTMLScanner {
    Item currentItem;
    ArrayList<File> files = new ArrayList();

    public static List<File> parse(Item item) throws ParserConfigurationException, SAXException, IOException {
        FileReader fr = new FileReader(item.getFile());
        InputSource file = new InputSource(fr);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/validation", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        SAXParser parser = factory.newSAXParser();
        String href = item.getHref();
        ReferenceScanner scanner = new ReferenceScanner(item);
        try {
            parser.parse(file, (DefaultHandler)scanner);
            return scanner.files;
        }
        catch (SAXException e) {
            System.err.println("Could not parse " + href);
            e.printStackTrace();
            return null;
        }
    }

    public ReferenceScanner(Item item) {
        this.currentItem = item;
    }

    private String getAttribute(Attributes attributes, String name) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String aname = attributes.getQName(i);
            if (!aname.equalsIgnoreCase(name)) continue;
            return attributes.getValue(i);
        }
        return null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String ref;
        if (qName.equalsIgnoreCase("img") && (ref = this.getAttribute(attributes, "src")) != null) {
            String t = ref.toLowerCase();
            if (t.startsWith("http://") || t.startsWith("https://")) {
                return;
            }
            String source = this.currentItem.getSourcePath();
            if (source == null) {
                source = this.currentItem.getFile();
            }
            File sourceFile = new File(source);
            File file = new File(ref);
            if (!file.isAbsolute()) {
                file = new File(sourceFile.getParentFile().getAbsolutePath() + File.separator + ref);
            }
            this.files.add(file);
        }
        if (qName.equalsIgnoreCase("a") && (ref = this.getAttribute(attributes, "href")) != null) {
            this.includeRef(ref);
        }
        if (qName.equalsIgnoreCase("link")) {
            ref = this.getAttribute(attributes, "href");
            String rel = this.getAttribute(attributes, "rel");
            if (ref != null && rel != null && rel.equals("stylesheet")) {
                this.includeRef(ref);
            }
        }
    }

    private void includeRef(String ref) {
        File sourceFile;
        File file;
        String source;
        String t = ref.toLowerCase();
        if (t.startsWith("#") || t.startsWith("http://") || t.startsWith("https://")) {
            return;
        }
        if (ref.indexOf(35) > -1) {
            ref = ref.substring(0, ref.indexOf(35));
        }
        if ((source = this.currentItem.getSourcePath()) == null) {
            source = this.currentItem.getFile();
        }
        if (!(file = new File((sourceFile = new File(source)).getParentFile().getAbsolutePath() + File.separator + ref)).isDirectory()) {
            this.files.add(file);
        }
    }
}

