/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContext;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContextBuilder;
import org.eclipse.mylyn.wikitext.commonmark.internal.SimpleLocator;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Cursor;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.InlinesSubstitution;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.Locator;

public abstract class Inline {
    private final Line line;
    private final int offset;
    private final int length;

    public Inline(Line line, int offset, int length) {
        this.line = Objects.requireNonNull(line);
        this.offset = offset;
        this.length = length;
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0);
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public Line getLine() {
        return this.line;
    }

    public Locator getLocator() {
        int lineCharacterOffset = this.getOffset() - this.line.getOffset();
        return new SimpleLocator(this.line, lineCharacterOffset, lineCharacterOffset + this.length);
    }

    public abstract void emit(DocumentBuilder var1);

    public void apply(ProcessingContext context, List<Inline> inlines, Cursor cursor) {
        cursor.advance(this.getLength());
        inlines.add(this);
    }

    Optional<InlinesSubstitution> secondPass(List<Inline> inlines) {
        return Optional.empty();
    }

    public void createContext(ProcessingContextBuilder contextBuilder) {
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Inline other = (Inline)obj;
        return other.offset == this.offset && other.length == this.length;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("offset", this.getOffset()).add("length", this.getLength()).toString();
    }
}

