/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.epub.internal;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.mylyn.docs.epub.internal.AbstractXHTMLScanner;
import org.eclipse.mylyn.docs.epub.ncx.Content;
import org.eclipse.mylyn.docs.epub.ncx.NCXFactory;
import org.eclipse.mylyn.docs.epub.ncx.NavLabel;
import org.eclipse.mylyn.docs.epub.ncx.NavPoint;
import org.eclipse.mylyn.docs.epub.ncx.Ncx;
import org.eclipse.mylyn.docs.epub.ncx.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TOCGenerator
extends AbstractXHTMLScanner {
    private String currentId = null;
    private NavPoint[] headers = null;
    private final Ncx ncx;
    private int playOrder;

    public int getPlayOrder() {
        return this.playOrder;
    }

    public TOCGenerator(String href, Ncx ncx, int playOrder) {
        this.buffer = new StringBuilder();
        this.currentHref = href;
        this.headers = new NavPoint[6];
        this.ncx = ncx;
        this.playOrder = playOrder;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        int currentLevel = this.isHeader(qName);
        int parentLevel = currentLevel - 1;
        if (currentLevel > 0 && currentLevel < 7) {
            this.recording = false;
            NavPoint navPoint = this.createNavPoint(this.buffer.toString());
            if (currentLevel > 1) {
                NavPoint parent = this.headers[parentLevel - 1];
                while (parent == null && parentLevel > 1) {
                    parent = this.headers[--parentLevel - 1];
                }
                if (parent == null) {
                    this.ncx.getNavMap().getNavPoints().add((Object)navPoint);
                    this.headers[0] = navPoint;
                } else {
                    parent.getNavPoints().add((Object)navPoint);
                    this.headers[parentLevel] = navPoint;
                }
            } else {
                this.ncx.getNavMap().getNavPoints().add((Object)navPoint);
                this.headers[0] = navPoint;
            }
            this.buffer.setLength(0);
        }
    }

    private NavPoint createNavPoint(String title) {
        NavPoint np = NCXFactory.eINSTANCE.createNavPoint();
        NavLabel nl = NCXFactory.eINSTANCE.createNavLabel();
        Content c = NCXFactory.eINSTANCE.createContent();
        c.setSrc((String)(this.currentId == null ? this.currentHref : this.currentHref + "#" + this.currentId));
        Text text = NCXFactory.eINSTANCE.createText();
        FeatureMapUtil.addText((FeatureMap)text.getMixed(), (String)title);
        nl.setText(text);
        np.getNavLabels().add((Object)nl);
        np.setPlayOrder(++this.playOrder);
        np.setId("navpoint" + this.playOrder);
        np.setContent(c);
        return np;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.isHeader(qName) > 0) {
            this.recording = true;
            this.currentId = attributes.getValue("id") != null ? attributes.getValue("id") : null;
        }
    }

    public static int parse(InputSource file, String href, Ncx ncx, int playOrder) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/validation", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        SAXParser parser = factory.newSAXParser();
        TOCGenerator tocGenerator = new TOCGenerator(href, ncx, playOrder);
        try {
            parser.parse(file, (DefaultHandler)tocGenerator);
        }
        catch (SAXException e) {
            System.err.println("Could not parse " + href);
            e.printStackTrace();
        }
        return tocGenerator.getPlayOrder();
    }
}

