/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.mediawiki.internal.phrase;

import java.util.List;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElementProcessor;

public class SimpleWrappedPhraseModifier
extends PatternBasedElement {
    protected static final int CONTENT_GROUP = 1;
    private final String startDelimiter;
    private final String endDelimiter;
    private final DocumentBuilder.SpanType[] spanType;
    private final boolean nesting;

    public SimpleWrappedPhraseModifier(String startDelimiter, String endDelimiter, DocumentBuilder.SpanType[] spanType) {
        this(startDelimiter, endDelimiter, spanType, false);
    }

    public SimpleWrappedPhraseModifier(String startDelimiter, String endDelimiter, DocumentBuilder.SpanType[] spanType, boolean nesting) {
        this.startDelimiter = startDelimiter;
        this.endDelimiter = endDelimiter;
        this.spanType = spanType;
        this.nesting = nesting;
    }

    protected String getPattern(int groupOffset) {
        String quotedStartDelimiter = this.quoteLite(this.startDelimiter);
        String quotedEndDelimiter = this.quoteLite(this.endDelimiter);
        return quotedStartDelimiter + "((?:(?!" + quotedEndDelimiter + ").)+)" + quotedEndDelimiter;
    }

    private String quoteLite(String literal) {
        StringBuilder buf = new StringBuilder(literal.length() * 2);
        for (int x = 0; x < literal.length(); ++x) {
            char c = literal.charAt(x);
            switch (c) {
                case '*': 
                case '+': 
                case '-': 
                case '?': 
                case '^': {
                    buf.append('\\');
                }
            }
            buf.append(c);
        }
        return buf.toString();
    }

    protected int getPatternGroupCount() {
        return 1;
    }

    protected static String getContent(PatternBasedElementProcessor processor) {
        return processor.group(1);
    }

    protected static int getStart(PatternBasedElementProcessor processor) {
        return processor.start(1);
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new SimplePhraseModifierProcessor(this.spanType, this.nesting);
    }

    private static class SimplePhraseModifierProcessor
    extends PatternBasedElementProcessor {
        private final List<DocumentBuilder.SpanType> spanType;
        private final boolean nesting;

        public SimplePhraseModifierProcessor(DocumentBuilder.SpanType[] spanType, boolean nesting) {
            this.spanType = List.of(spanType);
            this.nesting = nesting;
        }

        public void emit() {
            for (DocumentBuilder.SpanType type2 : this.spanType) {
                this.getBuilder().beginSpan(type2, new Attributes());
            }
            if (this.nesting) {
                this.getMarkupLanguage().emitMarkupLine(this.parser, this.state, SimpleWrappedPhraseModifier.getStart(this), SimpleWrappedPhraseModifier.getContent(this), 0);
            } else {
                this.getMarkupLanguage().emitMarkupText(this.parser, this.state, SimpleWrappedPhraseModifier.getContent(this));
            }
            this.spanType.forEach(type -> this.getBuilder().endSpan());
        }
    }
}

