/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.painter;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ImagePainter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Image;

public class ColumnGroupExpandCollapseImagePainter
extends ImagePainter {
    private Image collapsedImage;
    private Image expandedImage;

    public ColumnGroupExpandCollapseImagePainter() {
        this(true);
    }

    public ColumnGroupExpandCollapseImagePainter(boolean paintBg) {
        this(paintBg, false);
    }

    public ColumnGroupExpandCollapseImagePainter(boolean paintBg, boolean invertIcons) {
        super(null, paintBg);
        String postFix = "";
        if (invertIcons) {
            postFix = "_inv";
        }
        this.collapsedImage = GUIHelper.getImage("right" + postFix);
        this.expandedImage = GUIHelper.getImage("left" + postFix);
    }

    @Override
    protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
        Image icon = null;
        if (this.isCollapsed(cell)) {
            icon = this.collapsedImage;
        } else if (this.isExpanded(cell)) {
            icon = this.expandedImage;
        }
        return icon;
    }

    private boolean isCollapsed(ILayerCell cell) {
        return cell.getConfigLabels().hasLabel("GROUP_COLLAPSED");
    }

    private boolean isExpanded(ILayerCell cell) {
        return cell.getConfigLabels().hasLabel("GROUP_EXPANDED");
    }

    public void setExpandCollapseImages(Image expandedImage, Image collapsedImage) {
        this.collapsedImage = collapsedImage;
        this.expandedImage = expandedImage;
    }
}

