/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swt;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.gui.WritableTableFormat;
import ca.odell.glazedlists.swt.KTableFormat;
import ca.odell.glazedlists.swt.TableFormatKTableFormat;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellEditor;
import de.kupzog.ktable.KTableCellRenderer;
import de.kupzog.ktable.KTableModel;
import org.eclipse.swt.graphics.Point;

public class DefaultEventKTableModel
implements KTableModel,
ListEventListener {
    private KTable table;
    private boolean disposeSource;
    protected EventList source;
    private KTableFormat kTableFormat;

    public DefaultEventKTableModel(KTable table, EventList source, TableFormat tableFormat) {
        this(table, source, tableFormat, false);
    }

    protected DefaultEventKTableModel(KTable table, EventList source, TableFormat tableFormat, boolean disposeSource) {
        this.disposeSource = disposeSource;
        this.table = table;
        this.source = source;
        this.kTableFormat = tableFormat instanceof KTableFormat ? (KTableFormat)tableFormat : new TableFormatKTableFormat(tableFormat);
        this.source.addListEventListener(this);
    }

    public void listChanged(ListEvent listChanges) {
        this.table.redraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getContentAt(int column, int row) {
        if (row < this.getFixedHeaderRowCount()) {
            return this.kTableFormat.getColumnHeaderValue(row, column);
        }
        this.source.getReadWriteLock().readLock().lock();
        try {
            Object object = this.kTableFormat.getColumnValue(this.source.get(row - this.getFixedHeaderRowCount()), column);
            return object;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTooltipAt(int column, int row) {
        if (row < this.getFixedHeaderRowCount()) {
            return null;
        }
        this.source.getReadWriteLock().readLock().lock();
        try {
            String string = this.kTableFormat.getColumnTooltip(this.source.get(row - this.getFixedHeaderRowCount()), column);
            return string;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KTableCellEditor getCellEditor(int column, int row) {
        if (row < this.getFixedHeaderRowCount()) {
            return null;
        }
        if (this.kTableFormat instanceof WritableTableFormat) {
            this.source.getReadWriteLock().readLock().lock();
            try {
                Object baseObject = this.source.get(row);
                KTableCellEditor kTableCellEditor = this.kTableFormat.getColumnEditor(baseObject, column);
                return kTableCellEditor;
            }
            finally {
                this.source.getReadWriteLock().readLock().unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setContentAt(int column, int row, Object value) {
        if (row < this.getFixedHeaderRowCount()) {
            throw new UnsupportedOperationException("Unexpected set() on column header");
        }
        if (!(this.kTableFormat instanceof WritableTableFormat)) throw new UnsupportedOperationException("Unexpected set() on read-only table");
        this.source.getReadWriteLock().readLock().lock();
        try {
            WritableTableFormat writableTableFormat = (WritableTableFormat)((Object)this.kTableFormat);
            Object baseObject = this.source.get(row - this.getFixedHeaderRowCount());
            Object updatedObject = writableTableFormat.setColumnValue(baseObject, value, column);
            if (updatedObject == null) return;
            this.source.set(row - this.getFixedHeaderRowCount(), updatedObject);
            return;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KTableCellRenderer getCellRenderer(int column, int row) {
        if (row < this.getFixedHeaderRowCount()) {
            return KTableCellRenderer.defaultRenderer;
        }
        this.source.getReadWriteLock().readLock().lock();
        try {
            KTableCellRenderer kTableCellRenderer = this.kTableFormat.getColumnRenderer(this.source.get(row - this.getFixedHeaderRowCount()), column);
            return kTableCellRenderer;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    public Point belongsToCell(int column, int row) {
        return new Point(column, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            int n = this.source.size() + this.getFixedHeaderRowCount();
            return n;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    public int getFixedHeaderRowCount() {
        return this.kTableFormat.getFixedHeaderRowCount();
    }

    public int getFixedSelectableRowCount() {
        return this.kTableFormat.getFixedSelectableColumnCount();
    }

    public int getColumnCount() {
        return this.kTableFormat.getColumnCount();
    }

    public int getFixedHeaderColumnCount() {
        return this.kTableFormat.getFixedHeaderColumnCount();
    }

    public int getFixedSelectableColumnCount() {
        return this.kTableFormat.getFixedSelectableColumnCount();
    }

    public int getColumnWidth(int col) {
        return this.kTableFormat.getColumnWidth(col);
    }

    public boolean isColumnResizable(int col) {
        return this.kTableFormat.isColumnResizable(col);
    }

    public void setColumnWidth(int col, int width) {
        this.kTableFormat.setColumnWidth(col, width);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowHeight(int row) {
        if (row < this.getFixedHeaderRowCount()) {
            return 20;
        }
        if (row < this.getRowCount()) {
            this.source.getReadWriteLock().readLock().lock();
            try {
                int n = this.kTableFormat.getRowHeight(this.source.get(row - this.getFixedHeaderRowCount()));
                return n;
            }
            finally {
                this.source.getReadWriteLock().readLock().unlock();
            }
        }
        return 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRowResizable(int row) {
        if (row < this.getFixedHeaderRowCount()) {
            return false;
        }
        this.source.getReadWriteLock().readLock().lock();
        try {
            boolean bl = this.kTableFormat.isRowResizable(this.source.get(row - this.getFixedHeaderRowCount()));
            return bl;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    public int getRowHeightMinimum() {
        return this.kTableFormat.getRowHeightMinimum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRowHeight(int row, int value) {
        if (row < this.getFixedHeaderRowCount()) {
            return;
        }
        this.source.getReadWriteLock().readLock().lock();
        try {
            this.kTableFormat.setRowHeight(this.source.get(row - this.getFixedHeaderRowCount()), value);
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    public void dispose() {
        this.source.removeListEventListener(this);
        if (this.disposeSource) {
            this.source.dispose();
        }
    }
}

