/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.command;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.ColumnPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public class ColumnGroupReorderCommand
implements ILayerCommand {
    private int level;
    private ColumnPositionCoordinate fromColumnPositionCoordinate;
    private ColumnPositionCoordinate toColumnPositionCoordinate;
    private boolean reorderToLeftEdge;
    private boolean performConversion;

    public ColumnGroupReorderCommand(ILayer layer, int level, int fromColumnPosition, int toColumnPosition) {
        this(layer, level, fromColumnPosition, toColumnPosition, true);
    }

    public ColumnGroupReorderCommand(ILayer layer, int level, int fromColumnPosition, int toColumnPosition, boolean performConversion) {
        this.fromColumnPositionCoordinate = new ColumnPositionCoordinate(layer, fromColumnPosition);
        this.level = level;
        if (toColumnPosition < layer.getColumnCount()) {
            this.reorderToLeftEdge = true;
        } else {
            this.reorderToLeftEdge = false;
            --toColumnPosition;
        }
        this.toColumnPositionCoordinate = new ColumnPositionCoordinate(layer, toColumnPosition);
        this.performConversion = performConversion;
    }

    protected ColumnGroupReorderCommand(ColumnGroupReorderCommand command) {
        this.level = command.level;
        this.fromColumnPositionCoordinate = command.fromColumnPositionCoordinate;
        this.toColumnPositionCoordinate = command.toColumnPositionCoordinate;
        this.reorderToLeftEdge = command.reorderToLeftEdge;
        this.performConversion = command.performConversion;
    }

    public int getLevel() {
        return this.level;
    }

    public int getFromColumnPosition() {
        return this.fromColumnPositionCoordinate.getColumnPosition();
    }

    public int getToColumnPosition() {
        return this.toColumnPositionCoordinate.getColumnPosition();
    }

    public boolean isReorderToLeftEdge() {
        return this.reorderToLeftEdge;
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        if (this.performConversion) {
            ColumnPositionCoordinate targetFromColumnPositionCoordinate = LayerCommandUtil.convertColumnPositionToTargetContext(this.fromColumnPositionCoordinate, targetLayer);
            ColumnPositionCoordinate targetToColumnPositionCoordinate = LayerCommandUtil.convertColumnPositionToTargetContext(this.toColumnPositionCoordinate, targetLayer);
            if (targetFromColumnPositionCoordinate != null && targetToColumnPositionCoordinate != null) {
                this.fromColumnPositionCoordinate = targetFromColumnPositionCoordinate;
                this.toColumnPositionCoordinate = targetToColumnPositionCoordinate;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public ColumnGroupReorderCommand cloneCommand() {
        return new ColumnGroupReorderCommand(this);
    }
}

