/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.cell;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.CellPainterWrapper;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class GradientBackgroundPainter
extends CellPainterWrapper {
    private boolean vertical;

    public GradientBackgroundPainter() {
        this(false);
    }

    public GradientBackgroundPainter(boolean vertical) {
        this.vertical = vertical;
    }

    public GradientBackgroundPainter(ICellPainter painter) {
        this(painter, false);
    }

    public GradientBackgroundPainter(ICellPainter painter, boolean vertical) {
        super(painter);
        this.vertical = vertical;
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        Color foregroundColor = this.getForeGroundColour(cell, configRegistry);
        Color backgroundColor = this.getBackgroundColour(cell, configRegistry);
        if (backgroundColor != null && foregroundColor != null) {
            Color originalForeground = gc.getForeground();
            Color originalBackground = gc.getBackground();
            gc.setForeground(foregroundColor);
            gc.setBackground(backgroundColor);
            gc.fillGradientRectangle(bounds.x, bounds.y, bounds.width, bounds.height, this.vertical);
            gc.setForeground(originalForeground);
            gc.setBackground(originalBackground);
        }
        super.paintCell(cell, gc, bounds, configRegistry);
    }

    protected Color getForeGroundColour(ILayerCell cell, IConfigRegistry configRegistry) {
        Color fgColor = CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(CellStyleAttributes.GRADIENT_FOREGROUND_COLOR);
        return fgColor != null ? fgColor : CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR);
    }

    protected Color getBackgroundColour(ILayerCell cell, IConfigRegistry configRegistry) {
        Color bgColor = CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(CellStyleAttributes.GRADIENT_BACKGROUND_COLOR);
        return bgColor != null ? bgColor : CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }
}

