/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.selection.ITraversalStrategy;
import org.eclipse.nebula.widgets.nattable.selection.MoveCellSelectionCommandHandler;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class MoveRowSelectionCommandHandler
extends MoveCellSelectionCommandHandler {
    public MoveRowSelectionCommandHandler(SelectionLayer selectionLayer) {
        super(selectionLayer);
    }

    public MoveRowSelectionCommandHandler(SelectionLayer selectionLayer, ITraversalStrategy traversalStrategy) {
        super(selectionLayer, traversalStrategy);
    }

    public MoveRowSelectionCommandHandler(SelectionLayer selectionLayer, ITraversalStrategy horizontalTraversalStrategy, ITraversalStrategy verticalTraversalStrategy) {
        super(selectionLayer, horizontalTraversalStrategy, verticalTraversalStrategy);
    }

    @Override
    protected void moveLastSelectedLeft(ITraversalStrategy traversalStrategy, boolean withShiftMask, boolean withControlMask) {
        super.moveLastSelectedLeft(traversalStrategy, withShiftMask, withControlMask);
        if (this.lastSelectedCellPosition != null) {
            this.selectionLayer.selectRow(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition, withShiftMask, withControlMask);
        }
    }

    @Override
    protected void moveLastSelectedRight(ITraversalStrategy traversalStrategy, boolean withShiftMask, boolean withControlMask) {
        super.moveLastSelectedRight(traversalStrategy, withShiftMask, withControlMask);
        if (this.lastSelectedCellPosition != null) {
            this.selectionLayer.selectRow(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition, withShiftMask, withControlMask);
        }
    }

    @Override
    protected void moveLastSelectedUp(ITraversalStrategy traversalStrategy, boolean withShiftMask, boolean withControlMask) {
        if (this.selectionLayer.hasRowSelection()) {
            boolean deselect;
            PositionCoordinate anchor = new PositionCoordinate(this.selectionLayer.getSelectionAnchor());
            PositionCoordinate from = this.selectionLayer.getCellPositionToMoveFrom(withShiftMask, withControlMask);
            boolean bl = deselect = this.selectionLayer.isRowPositionSelected(from.rowPosition) && this.selectionLayer.isRowPositionSelected(from.rowPosition - 1) && withShiftMask;
            if (deselect) {
                this.selectionLayer.selectRow(this.lastSelectedCellPosition.columnPosition, from.rowPosition, false, true);
            }
            super.moveLastSelectedUp(traversalStrategy, withShiftMask, withControlMask);
            if (deselect) {
                this.selectionLayer.setSelectionAnchor(anchor.columnPosition, anchor.rowPosition);
            }
            if (!deselect && this.lastSelectedCellPosition != null) {
                this.selectionLayer.selectRow(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition, withShiftMask, withControlMask);
            }
        }
    }

    @Override
    protected void moveLastSelectedDown(ITraversalStrategy traversalStrategy, boolean withShiftMask, boolean withControlMask) {
        if (this.selectionLayer.hasRowSelection()) {
            boolean deselect;
            PositionCoordinate anchor = new PositionCoordinate(this.selectionLayer.getSelectionAnchor());
            PositionCoordinate from = this.selectionLayer.getCellPositionToMoveFrom(withShiftMask, withControlMask);
            boolean bl = deselect = this.selectionLayer.isRowPositionSelected(from.rowPosition) && this.selectionLayer.isRowPositionSelected(from.rowPosition + 1) && withShiftMask;
            if (deselect) {
                this.selectionLayer.selectRow(this.lastSelectedCellPosition.columnPosition, from.rowPosition, false, true);
            }
            super.moveLastSelectedDown(traversalStrategy, withShiftMask, withControlMask);
            if (deselect) {
                this.selectionLayer.setSelectionAnchor(anchor.columnPosition, anchor.rowPosition);
            }
            if (!deselect && this.lastSelectedCellPosition != null) {
                this.selectionLayer.selectRow(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition, withShiftMask, withControlMask);
            }
        }
    }

    @Override
    void selectCell(int columnPosition, int rowPosition, boolean withShiftMask, boolean withControlMask, boolean fireEvent) {
        PositionCoordinate selectionAnchor = this.selectionLayer.getSelectionAnchor();
        int col = columnPosition;
        boolean fire = fireEvent;
        if (selectionAnchor.columnPosition == columnPosition || withShiftMask) {
            col = selectionAnchor.columnPosition;
            fire = false;
        }
        super.selectCell(col, rowPosition, withShiftMask, withControlMask, fire);
    }
}

