/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.action;

import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupUtils;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.reorder.action.ColumnReorderDragMode;

public class ColumnHeaderReorderDragMode
extends ColumnReorderDragMode {
    private final ColumnGroupModel model;

    public ColumnHeaderReorderDragMode(ColumnGroupModel model) {
        this.model = model;
    }

    @Override
    public boolean isValidTargetColumnPosition(ILayer natLayer, int fromGridColumnPosition, int toGridColumnPosition) {
        if (this.currentEvent != null) {
            toGridColumnPosition = natLayer.getColumnPositionByX(this.currentEvent.x);
        }
        int toColumnIndex = natLayer.getColumnIndexByPosition(toGridColumnPosition);
        int fromColumnIndex = natLayer.getColumnIndexByPosition(fromGridColumnPosition);
        if (this.model.isPartOfAnUnbreakableGroup(fromColumnIndex)) {
            return ColumnGroupUtils.isInTheSameGroup(fromColumnIndex, toColumnIndex, this.model);
        }
        boolean betweenTwoGroups = false;
        if (this.currentEvent != null) {
            int minX = this.currentEvent.x - 4;
            int maxX = this.currentEvent.x + 4;
            betweenTwoGroups = ColumnGroupUtils.isBetweenTwoGroups(natLayer, minX, maxX, this.model);
        }
        return !this.model.isPartOfAnUnbreakableGroup(toColumnIndex) || betweenTwoGroups;
    }
}

