/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection.command;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.ColumnPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.RowPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.swt.graphics.Rectangle;

public class SelectRegionCommand
implements ILayerCommand {
    private ILayer sourceLayer;
    private Rectangle region;
    private boolean shiftMask;
    private boolean controlMask;
    private int anchorRowPosition = -1;
    private int anchorColumnPosition = -1;

    public SelectRegionCommand(ILayer layer, int startColumnPosition, int startRowPosition, int regionWidth, int regionHeight, boolean shiftMask, boolean controlMask) {
        this(layer, new Rectangle(startColumnPosition, startRowPosition, regionWidth, regionHeight), shiftMask, controlMask);
    }

    public SelectRegionCommand(ILayer layer, Rectangle region, boolean shiftMask, boolean controlMask) {
        this.sourceLayer = layer;
        this.region = region;
        this.shiftMask = shiftMask;
        this.controlMask = controlMask;
    }

    protected SelectRegionCommand(SelectRegionCommand command) {
        this.sourceLayer = command.sourceLayer;
        this.region = command.region;
        this.shiftMask = command.shiftMask;
        this.controlMask = command.controlMask;
        this.anchorColumnPosition = command.anchorColumnPosition;
        this.anchorRowPosition = command.anchorRowPosition;
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        PositionCoordinate sourceCoordinate = new PositionCoordinate(this.sourceLayer, this.region.x, this.region.y);
        PositionCoordinate targetCoordinate = LayerCommandUtil.convertPositionToTargetContext(sourceCoordinate, targetLayer);
        if (targetCoordinate != null) {
            this.sourceLayer = targetCoordinate.getLayer();
            this.region.x = targetCoordinate.columnPosition;
            this.region.y = targetCoordinate.rowPosition;
            if (this.anchorColumnPosition >= 0) {
                ColumnPositionCoordinate sourceColumn = new ColumnPositionCoordinate(this.sourceLayer, this.anchorColumnPosition);
                ColumnPositionCoordinate targetColumn = LayerCommandUtil.convertColumnPositionToTargetContext(sourceColumn, targetLayer);
                this.anchorColumnPosition = targetColumn.getColumnPosition();
            }
            if (this.anchorRowPosition >= 0) {
                RowPositionCoordinate sourceRow = new RowPositionCoordinate(this.sourceLayer, this.anchorRowPosition);
                RowPositionCoordinate targetRow = LayerCommandUtil.convertRowPositionToTargetContext(sourceRow, targetLayer);
                this.anchorRowPosition = targetRow.getRowPosition();
            }
            return true;
        }
        return false;
    }

    @Override
    public ILayerCommand cloneCommand() {
        return new SelectRegionCommand(this);
    }

    public Rectangle getRegion() {
        return this.region;
    }

    public boolean isShiftMask() {
        return this.shiftMask;
    }

    public boolean isControlMask() {
        return this.controlMask;
    }

    public int getAnchorRowPosition() {
        return this.anchorRowPosition;
    }

    public void setAnchorRowPosition(int anchorRowPosition) {
        this.anchorRowPosition = anchorRowPosition;
    }

    public int getAnchorColumnPosition() {
        return this.anchorColumnPosition;
    }

    public void setAnchorColumnPosition(int anchorColumnPosition) {
        this.anchorColumnPosition = anchorColumnPosition;
    }
}

