/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.AbstractAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.CPTypeAnchorAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.CallinMethodMappingsAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.CalloutMappingsAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.OTSpecialAccessAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.RoleLocalTypesAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.SingleValueAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.WordValueAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.Lifting;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.SyntheticRoleFieldAccess;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.CalloutImplementor;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TypeModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.copyinheritance.CopyInheritance;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.copyinheritance.TypeLevel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.RoleSplitter;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class RoleModel
extends TypeModel {
    public static final int IsViewedAsTSuper = 1;
    public static final int BaseclassHasProblems = 2;
    public static final int HasLiftingProblem = 4;
    public static final char[] NO_SOURCE_FILE = "<intermediate>".toCharArray();
    private ClassFile _classFile = null;
    private byte[] _classByteCode = null;
    private int _headerOffset = 0;
    private int[] _constantPoolOffsets = null;
    private HashMap<MethodBinding, Integer> _methodByteCodeOffsets = new HashMap();
    private TeamModel _teamModel;
    private ReferenceBinding[] _tsuperRoleBindings = new ReferenceBinding[2];
    private int numTSuperRoles = 0;
    public TypeDeclaration _interfacePart = null;
    public TypeDeclaration _classPart = null;
    private ReferenceBinding _interfaceBinding = null;
    private ReferenceBinding _classBinding = null;
    private LinkedList<RoleModel> _localTypes = new LinkedList();
    private RoleModel[] _subRoles = null;
    public RoleModel _boundRootRole = null;
    public int tagBits = 0;
    public boolean _abstractLower = false;
    public boolean _refinesExtends = false;
    public boolean _hasBindingAmbiguity = false;
    public boolean _playedByEnclosing = false;
    private HashMap<Binding, Binding> _syntheticMap = new HashMap();
    public boolean _isLocalType;
    private HashSet<Binding> _copiedFeatureBindings = new HashSet();
    public ReferenceBinding _supercededBy;
    private int _extraRoleFlags = 0;
    private boolean hasCheckedBaseclass = false;
    private boolean isBound;
    public MethodBinding unimplementedGetBase;

    public RoleModel(ReferenceBinding roleBinding) {
        super(roleBinding);
        if (roleBinding.isLocalType()) {
            this._isLocalType = true;
        }
    }

    public RoleModel(TypeDeclaration roleAst) {
        super(roleAst);
        this.addAttribute(WordValueAttribute.compilerVersionAttribute());
        if (roleAst.scope != null && roleAst.scope.parent instanceof MethodScope) {
            this._isLocalType = true;
        }
    }

    public boolean hasState(int state) {
        return this._state.getState() >= state;
    }

    @Override
    public int setState(int state) {
        int oldState = super.setState(state);
        if (oldState >= 11 && state < 25 && this._ast != null) {
            CopyInheritance.copyGeneratedFeatures(this);
        }
        return oldState;
    }

    @Override
    public void setMemberState(int state) {
        super.setMemberState(state);
        if (state <= 2 || state >= 21) {
            Iterator<RoleModel> localTypes = this.localTypes();
            while (localTypes.hasNext()) {
                RoleModel type = localTypes.next();
                type.setState(state);
                type.setMemberState(state);
            }
        }
    }

    @Override
    public boolean isReadyToProcess(int state) {
        if (!this._state.isReadyToProcess(state)) {
            return false;
        }
        RoleModel otherModel = null;
        if (this._interfaceBinding != null) {
            otherModel = this._interfaceBinding.roleModel;
        }
        if ((otherModel == null || otherModel == this) && this._classBinding != null) {
            otherModel = this._classBinding.roleModel;
        }
        if (otherModel != null && otherModel != this) {
            return otherModel._state.isReadyToProcess(state);
        }
        return true;
    }

    @Override
    public boolean isTeam() {
        if (this._ast != null) {
            return this._ast.isTeam();
        }
        return this._binding.isTeam();
    }

    public TeamModel getTeamModelOfThis() {
        this.getClassPartAst();
        if (this._classPart != null && this._classPart.isTeam()) {
            return this._classPart.getTeamModel();
        }
        this.getClassPartBinding();
        if (this._classBinding != null && this._classBinding.isTeam()) {
            return this._classBinding.getTeamModel();
        }
        return null;
    }

    public static boolean isClass(ReferenceBinding memberType) {
        if (!memberType.isRole()) {
            return memberType.isClass();
        }
        ReferenceBinding realClass = memberType.getRealClass();
        return realClass != null && realClass.isClass();
    }

    public static boolean isInterface(ReferenceBinding memberType) {
        if (!memberType.isRole()) {
            return memberType.isInterface();
        }
        ReferenceBinding realClass = memberType.getRealClass();
        return realClass == null || !realClass.isClass();
    }

    public static boolean isSynthIfcOfClass(ReferenceBinding ifc, ReferenceBinding clazz) {
        return ifc.isSynthInterface() && ifc.roleModel != null && TypeBinding.equalsEquals(ifc.roleModel.getClassPartBinding(), clazz);
    }

    public static void setTagBit(ReferenceBinding role, int tagBit) {
        role.roleModel.tagBits |= tagBit;
    }

    public static boolean hasTagBit(ReferenceBinding typeBinding, int tagBit) {
        if (typeBinding.roleModel == null) {
            return false;
        }
        return (typeBinding.roleModel.tagBits & tagBit) != 0;
    }

    public void recordByteCode(MethodBinding method, byte[] code, int offset, int[] constantPoolOffsets) {
        this._methodByteCodeOffsets.put(method, new Integer(offset));
        if (this._classByteCode == null) {
            this._classByteCode = code;
            this._constantPoolOffsets = constantPoolOffsets;
        } else assert (this._classByteCode == code);
    }

    public static void maybeRecordByteCode(AbstractMethodDeclaration method, ClassFile file, int codeAttributeOffset) {
        TypeDeclaration clazz = method.scope.referenceType();
        if (clazz.isRole()) {
            TypeDeclaration memberType = clazz;
            RoleModel role = memberType.getRoleModel();
            role.recordClassFile(method.binding, file, codeAttributeOffset);
        }
    }

    public boolean hasByteCode() {
        MethodBinding[] methods;
        if (this._classByteCode != null || this._classFile != null || this._classFilePath != null) {
            return true;
        }
        TypeDeclaration ast = this._ast;
        if (ast == null) {
            TypeDeclaration typeDeclaration = ast = this._binding.isInterface() ? this._interfacePart : this._classPart;
        }
        if (ast == null) {
            return false;
        }
        if (TypeModel.isIgnoreFurtherInvestigation(ast)) {
            return false;
        }
        MethodBinding[] methodBindingArray = methods = ast.binding.methods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding methodBinding = methodBindingArray[n2];
            if (!methodBinding.bytecodeMissing) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized byte[] getByteCode() {
        if (this._classByteCode == null) {
            if (this._classFile == null && this._ast != null) {
                this._classFile = this._ast.compilationResult.findClassFile(this._binding);
            }
            if (this._classFile != null) {
                this._classByteCode = this._classFile.getBytes();
                this._headerOffset = this._classFile.headerOffset;
            } else {
                try {
                    ClassFileReader reader = this.read();
                    if (reader == null) {
                        if (Config.getConfig().ignoreMissingBytecode) {
                            return null;
                        }
                        throw new InternalCompilerError("Class file was not yet written to disk");
                    }
                    this._classByteCode = reader.getBytes();
                    this._headerOffset = reader.getHeaderOffset();
                    this._constantPoolOffsets = reader.getConstantPoolOffsets();
                }
                catch (Exception e) {
                    throw new InternalCompilerError("cannot retrieve generated class file: " + e);
                }
            }
        }
        assert (this._classByteCode != null);
        return this._classByteCode;
    }

    public int[] getConstantPoolOffsets() {
        if (this._constantPoolOffsets == null) {
            this.restoreCPOffsets();
        }
        return this._constantPoolOffsets;
    }

    public int getByteCodeOffset(MethodBinding method) {
        if (this.getByteCode() == null) {
            return -1;
        }
        Integer offset = this._methodByteCodeOffsets.get(method.original());
        if (offset == null) {
            if (!method.bytecodeMissing) {
                throw new InternalCompilerError("Method has no byte code: " + method);
            }
            return -1;
        }
        return offset + this._headerOffset;
    }

    @Override
    public synchronized void setClassFilePath(String classFilePath) {
        super.setClassFilePath(classFilePath);
        this._classFile = null;
        if (this.isTeam()) {
            this.getTeamModelOfThis().setClassFilePath(classFilePath);
        }
    }

    public synchronized void forgetByteCode() {
        this._methodByteCodeOffsets = new HashMap();
        this._classFile = null;
        this._classByteCode = null;
        this._constantPoolOffsets = null;
    }

    private synchronized void recordClassFile(MethodBinding method, ClassFile file, int offset) {
        this._methodByteCodeOffsets.put(method, new Integer(offset));
        if (this._classFile != null && this._classFile != file) {
            throw new InternalCompilerError("wrong ClassFile instance.");
        }
        this._classFile = file;
    }

    private void restoreCPOffsets() {
        try {
            byte[] code = this.getByteCode();
            if (code != null) {
                ClassFileReader reader = new ClassFileReader(code, NO_SOURCE_FILE);
                this._constantPoolOffsets = reader.getConstantPoolOffsets();
            }
        }
        catch (ClassFormatException ex) {
            throw new InternalCompilerError(ex.toString());
        }
    }

    public char[] getName() {
        return this._binding != null ? this._binding.sourceName() : this._ast.name;
    }

    public boolean isSourceRole() {
        return this._ast != null ? this._ast.isSourceRole() : this._binding.isSourceRole();
    }

    public boolean isPurelyCopied() {
        if (this._ast != null) {
            return this._ast.isPurelyCopied;
        }
        return (this._extraRoleFlags & 8) != 0;
    }

    public boolean isRoleFile() {
        if (this._ast == null) {
            return (this._extraRoleFlags & 0x10) != 0;
        }
        return this._ast.isRoleFile();
    }

    public void setExtraRoleFlags(int flags) {
        this._extraRoleFlags = flags;
    }

    public int getExtraRoleFlags() {
        return this._extraRoleFlags;
    }

    public boolean isLocalType() {
        if (this._binding != null) {
            return this._binding.isLocalType();
        }
        if (this._classBinding != null) {
            return this._classBinding.isLocalType();
        }
        if (this._ast != null && this._ast.scope != null) {
            return this._ast.scope.parent.kind == 2;
        }
        return false;
    }

    public TypeDeclaration getInterfaceAst() {
        RoleModel interfaceModel;
        if (this._interfacePart != null) {
            return this._interfacePart;
        }
        if (this._ast == null) {
            return null;
        }
        if (this._interfaceBinding != null && !this._ast.isInterface() && (interfaceModel = this._interfaceBinding.roleModel) != null && interfaceModel != this) {
            return interfaceModel.getInterfaceAst();
        }
        if ((this._ast.bits & 0x100) != 0) {
            return null;
        }
        assert (this._ast.isInterface());
        return this._ast;
    }

    public TypeDeclaration getClassPartAst() {
        RoleModel classRole;
        if (this._classPart != null) {
            return this._classPart;
        }
        if (this._ast != null && !this._ast.isInterface()) {
            this._classPart = this._ast;
            return this._classPart;
        }
        if (this._classBinding != null && (classRole = this._classBinding.roleModel) != null) {
            this._classPart = classRole._ast;
            return this._classPart;
        }
        return null;
    }

    public ReferenceBinding getInterfacePartBinding() {
        if (this._interfaceBinding == null) {
            if (this._interfacePart != null) {
                this._interfaceBinding = this._interfacePart.binding;
            } else if (this._binding != null && this._binding.enclosingType() != null) {
                this._interfaceBinding = this._binding.enclosingType().getMemberType(this._binding.sourceName());
            }
            if (this._interfaceBinding != null && this._binding != null && this._interfaceBinding.isBinaryBinding() != this._binding.isBinaryBinding()) {
                ClassScope scope = null;
                if (!this._binding.isBinaryBinding()) {
                    scope = ((SourceTypeBinding)this._binding).scope;
                } else if (!this._interfaceBinding.isBinaryBinding()) {
                    scope = ((SourceTypeBinding)this._interfaceBinding).scope;
                }
                String message = "Mismatching binary/source class/interface parts: " + String.valueOf(this._binding.readableName()) + " / " + String.valueOf(this._interfaceBinding.readableName());
                if (scope != null) {
                    ((Scope)scope).problemReporter().mismatchingRoleParts(this._interfaceBinding, ((Scope)scope).referenceType());
                } else {
                    throw new InternalCompilerError(message);
                }
            }
        }
        return this._interfaceBinding;
    }

    public ReferenceBinding getClassPartBinding() {
        if (this._classBinding == null) {
            if (this._binding == null) {
                return null;
            }
            if (!this._binding.isInterface()) {
                this._classBinding = this._binding;
            } else if (this._binding.isSynthInterface()) {
                if (this._classPart != null) {
                    this._classBinding = this._classPart.binding;
                }
                if (this._classBinding == null) {
                    this._classBinding = this._binding.enclosingType().getMemberType(CharOperation.concat(IOTConstants.OT_DELIM_NAME, this._binding.internalName()));
                }
            }
        }
        return this._classBinding;
    }

    public void setTeamModel(TeamModel teamModel) {
        this._teamModel = teamModel;
    }

    public TeamModel getTeamModel() {
        if (this._teamModel == null) {
            try {
                this._teamModel = this._binding != null ? TeamModel.getEnclosingTeam(this._binding).getTeamModel() : this._ast.enclosingType.getTeamModel();
            }
            catch (NullPointerException nullPointerException) {
                throw new InternalCompilerError("Missing enclosing team for " + this + "\n" + (this._ast != null ? this._ast : this._binding));
            }
        }
        return this._teamModel;
    }

    public ReferenceBinding getTSuperRoleBinding() {
        return this._tsuperRoleBindings[this.numTSuperRoles > 0 ? this.numTSuperRoles - 1 : 0];
    }

    public ReferenceBinding[] getTSuperRoleBindings() {
        ReferenceBinding[] tsupers = new ReferenceBinding[this.numTSuperRoles];
        System.arraycopy(this._tsuperRoleBindings, 0, tsupers, 0, this.numTSuperRoles);
        return tsupers;
    }

    public boolean hasRelevantTSuperRole() {
        return this.numTSuperRoles > 0 && !TypeAnalyzer.isPredefinedRole(this.getBinding());
    }

    public boolean hasTSuperRole(ReferenceBinding role) {
        if (!role.isRole()) {
            return false;
        }
        ReferenceBinding otherClass = null;
        ReferenceBinding otherIfc = null;
        if (role.isInterface()) {
            otherIfc = role;
            otherClass = role.getRealClass();
        } else {
            otherIfc = role.getRealType();
            otherClass = role;
        }
        Dependencies.ensureRoleState(this, 6);
        int i = 0;
        while (i < this.numTSuperRoles) {
            ReferenceBinding other;
            ReferenceBinding referenceBinding = other = this._tsuperRoleBindings[i].isInterface() ? otherIfc : otherClass;
            if (TypeBinding.equalsEquals(this._tsuperRoleBindings[i], other)) {
                return true;
            }
            if (this._tsuperRoleBindings[i].roleModel.hasTSuperRole(other)) {
                return true;
            }
            ++i;
        }
        ReferenceBinding outerRole = this._binding.enclosingType();
        if (outerRole.isRole()) {
            ReferenceBinding roleOuter = role.enclosingType();
            if (!roleOuter.isRole()) {
                return false;
            }
            if (!outerRole.roleModel.hasTSuperRole(roleOuter)) {
                return false;
            }
            return CharOperation.equals(role.internalName(), this._binding.internalName());
        }
        return false;
    }

    @Override
    public void setBinding(ReferenceBinding binding) {
        this._binding = binding;
        binding.roleModel = this;
    }

    public void addBinaryLocalType(ReferenceBinding local) {
        if (local instanceof BinaryTypeBinding) {
            ((BinaryTypeBinding)local).setEnclosingOfRoleLocal(this._binding);
        }
        this._localTypes.add(local.roleModel);
    }

    public void addLocalType(char[] constantPoolName, RoleModel local) {
        ClassScope scope;
        this._localTypes.add(local);
        local._isLocalType = true;
        if (constantPoolName != null && this._ast != null && (scope = this._ast.scope) != null) {
            CompilationUnitScope cuScope = scope.compilationUnitScope();
            cuScope.registerLocalType(constantPoolName, local.getAst());
        }
        if (this._attributes != null) {
            AbstractAttribute[] abstractAttributeArray = this._attributes;
            int n = this._attributes.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractAttribute attribute = abstractAttributeArray[n2];
                if (attribute.nameEquals(IOTConstants.ROLE_LOCAL_TYPES)) {
                    return;
                }
                ++n2;
            }
        }
        this.addAttribute(new RoleLocalTypesAttribute(this));
    }

    public void purgeLocalTypes(int sourceStart, int sourceEnd) {
        Iterator iterator = this._localTypes.iterator();
        while (iterator.hasNext()) {
            RoleModel role = (RoleModel)iterator.next();
            TypeDeclaration ast = role.getAst();
            if (ast == null || sourceStart >= ast.sourceStart || ast.declarationSourceEnd >= sourceEnd) continue;
            iterator.remove();
        }
    }

    public void maybeAddLocalToEnclosing() {
        ReferenceBinding enclosing = this._binding.enclosingType();
        if (enclosing != null && enclosing.isRole()) {
            enclosing.roleModel.addBinaryLocalType(this._binding);
        }
    }

    public ReferenceBinding[] getLocalTypes() {
        ReferenceBinding[] types = new ReferenceBinding[this._localTypes.size()];
        int j = 0;
        int i = 0;
        while (i < types.length) {
            types[j] = this._localTypes.get(i).getBinding();
            if (types[j] != null) {
                ++j;
            }
            ++i;
        }
        if (j != types.length) {
            ReferenceBinding[] referenceBindingArray = types;
            types = new ReferenceBinding[j];
            System.arraycopy(referenceBindingArray, 0, types, 0, j);
        }
        return types;
    }

    public Iterator<RoleModel> localTypes() {
        return this._localTypes.iterator();
    }

    @Override
    public ReferenceBinding findType(LookupEnvironment environment, char[][] compoundName) {
        char[][] myName = CharOperation.splitOn('/', this._binding.constantPoolName());
        if (this._binding.isLocalType() && CharOperation.equals(compoundName, myName)) {
            return this._binding;
        }
        Iterator<RoleModel> locals = this.localTypes();
        while (locals.hasNext()) {
            RoleModel role = locals.next();
            char[][] roleName = CharOperation.splitOn('/', role.getBinding().constantPoolName());
            if (!CharOperation.equals(compoundName, roleName)) continue;
            return role.getBinding();
        }
        if (this._binding.enclosingType().isRole()) {
            return this._binding.enclosingType().roleModel.findType(environment, compoundName);
        }
        return environment.getType(compoundName);
    }

    public ReferenceBinding findTypeRelative(char[] compoundName) {
        ReferenceBinding teamBinding = TeamModel.getEnclosingTeam(this._binding);
        if (this._binding.isLocalType() ? TypeAnalyzer.equalRoleLocal(teamBinding, this._binding, compoundName) : CharOperation.equals(this._binding.internalName(), compoundName)) {
            return this._binding;
        }
        Iterator<RoleModel> locals = this.localTypes();
        while (locals.hasNext()) {
            RoleModel role = locals.next();
            if (!TypeAnalyzer.equalRoleLocal(teamBinding, role.getBinding(), compoundName)) continue;
            return role.getBinding();
        }
        if (this._binding.enclosingType().isRole()) {
            return this._binding.enclosingType().roleModel.findTypeRelative(compoundName);
        }
        if (this._ast != null) {
            return (ReferenceBinding)this._ast.scope.getType(compoundName);
        }
        return null;
    }

    public boolean isBound() {
        if (this.hasCheckedBaseclass) {
            return this.isBound;
        }
        this.hasCheckedBaseclass = true;
        if (this._ast != null && this._ast.baseclass != null) {
            this.isBound = true;
            return true;
        }
        if (this._binding != null) {
            if (this._binding.rawBaseclass() != null) {
                this.isBound = true;
                return true;
            }
            ReferenceBinding superRole = this._binding.superclass();
            if (superRole != null && superRole.isRole() && superRole.roleModel.isBound()) {
                this.isBound = true;
                return true;
            }
        }
        int i = 0;
        while (i < this.numTSuperRoles) {
            if (this._tsuperRoleBindings[i].roleModel.isBound()) {
                this.isBound = true;
                return true;
            }
            ++i;
        }
        this.isBound = false;
        return false;
    }

    public boolean hasBaseclassProblem() {
        ReferenceBinding superclass;
        ReferenceBinding binding;
        if ((this.tagBits & 2) != 0) {
            return true;
        }
        ReferenceBinding referenceBinding = binding = this._classBinding != null ? this._classBinding : this._binding;
        if (binding.superclass() != null && ((superclass = binding.superclass()).isRole() && superclass.isHierarchyInconsistent() || superclass.roleModel != null && superclass.roleModel.hasBaseclassProblem())) {
            this.tagBits |= 2;
            return true;
        }
        return false;
    }

    public static boolean isRoleWithBaseProblem(TypeDeclaration declaration) {
        if (!declaration.isSourceRole()) {
            return false;
        }
        return declaration.getRoleModel().hasBaseclassProblem();
    }

    public ReferenceBinding getBaseTypeBinding() {
        return this._binding.baseclass();
    }

    public boolean isSuperTypeOf(RoleModel model) {
        ReferenceBinding[] superInterfaces;
        if (this._binding.isSuperclassOf(model.getBinding())) {
            return true;
        }
        ReferenceBinding[] referenceBindingArray = superInterfaces = model.getInterfacePartBinding() != null ? model.getInterfacePartBinding().superInterfaces() : model.getClassPartBinding().superInterfaces();
        if (superInterfaces != null) {
            int i = 0;
            while (i < superInterfaces.length) {
                if (TypeBinding.equalsEquals(superInterfaces[i], this._binding)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public RoleModel getExplicitSuperRole() {
        ReferenceBinding superClass = this._binding.superclass();
        if (superClass.superclass() == null) {
            return null;
        }
        return this._binding.superclass().roleModel;
    }

    public RoleModel getImplicitSuperRole() {
        if (this.getTSuperRoleBinding() == null) {
            return null;
        }
        return this.getTSuperRoleBinding().roleModel;
    }

    public static ReferenceBinding getTopmostBoundRole(BlockScope scope, ReferenceBinding startRole) {
        ReferenceBinding current = startRole;
        ReferenceBinding candidate = null;
        while (current != null) {
            if (!current.isRole()) {
                return candidate;
            }
            if (current.baseclass() == null) {
                return candidate;
            }
            candidate = current;
            current = current.roleModel.getTSuperRoleBinding();
        }
        return candidate;
    }

    public RoleModel getCopyInheritanceSource() {
        if (!this.isPurelyCopied()) {
            return this;
        }
        int i = 0;
        while (i < this._tsuperRoleBindings.length) {
            RoleModel model;
            if (this._tsuperRoleBindings[i] != null && (model = this._tsuperRoleBindings[i].roleModel.getCopyInheritanceSource()) != null) {
                return model;
            }
            ++i;
        }
        throw new InternalCompilerError("Unable to find real tsuper role of phantom role " + this);
    }

    public void setSubRoles(RoleModel[] subRoles) {
        this._subRoles = subRoles;
    }

    public RoleModel[] getSubRoles() {
        return this._subRoles;
    }

    RoleModel getSuperIfcRole(int idx) {
        if (this.getInterfacePartBinding().superInterfaces() == null) {
            return null;
        }
        if (this.getInterfacePartBinding().superInterfaces().length <= idx) {
            return null;
        }
        ReferenceBinding ifc = this.getInterfacePartBinding().superInterfaces()[idx];
        if (ifc.isSourceRole()) {
            return ifc.roleModel;
        }
        return null;
    }

    int getNumSuperIfc() {
        if (this._binding.superInterfaces() == null) {
            return 0;
        }
        return this._binding.superInterfaces().length;
    }

    public boolean isSynthInterface() {
        int AccSynthIfc = 4608;
        return (this._binding.modifiers & AccSynthIfc) == AccSynthIfc;
    }

    public boolean isRegularInterface() {
        return this._binding.isRegularInterface();
    }

    public boolean equals(RoleModel other) {
        if (other == null) {
            return false;
        }
        if (this._interfaceBinding != null && other._interfaceBinding != null) {
            return TypeBinding.equalsEquals(this._interfaceBinding, other._interfaceBinding);
        }
        if (this._classBinding != null && other._classBinding != null) {
            return TypeBinding.equalsEquals(this._classBinding, other._classBinding);
        }
        return this._ast == other._ast;
    }

    public void recordIfcPart(HashMap<String, TypeDeclaration> roleIfcs) {
        if (this._interfacePart == null) {
            String ifcName = null;
            if (this._binding != null) {
                ifcName = new String(this._binding.sourceName());
            } else if (this._ast != null && RoleSplitter.isClassPartName(this._ast.name)) {
                ifcName = new String(RoleSplitter.getInterfacePartName(this._ast.name));
            }
            if (ifcName != null) {
                this._interfacePart = roleIfcs.get(ifcName);
                this.checkClassAndIfcParts();
            } else assert (this._ast == null || this._ast.ignoreFurtherInvestigation) : "should only ever happen one erroneous code";
        }
    }

    public void checkClassAndIfcParts() {
        boolean hasError = false;
        ClassScope scope = null;
        char[] ifcName = null;
        char[] className = null;
        if (this._interfacePart != null && this._classPart != null) {
            scope = this._classPart.scope;
            ifcName = this._interfacePart.name;
            className = this._classPart.name;
            if (this._interfacePart.enclosingType != this._classPart.enclosingType) {
                hasError = true;
            }
        }
        if (this._interfaceBinding != null && this._classBinding != null) {
            ifcName = this._interfaceBinding.readableName();
            className = this._classBinding.readableName();
            if (TypeBinding.notEquals(this._interfaceBinding.enclosingType(), this._classBinding.enclosingType())) {
                hasError = true;
            }
        }
        if (hasError) {
            if (scope == null && this._ast != null) {
                scope = this._ast.scope;
            }
            if (scope == null) {
                throw new InternalCompilerError("Multiple errors processing role " + this.toString());
            }
            ((Scope)scope).problemReporter().inconsistentlyResolvedRole(this._ast, ifcName, className);
        }
    }

    public void connect(TeamModel teamModel, ReferenceBinding tsuperRole) {
        LookupEnvironment env;
        this.setTeamModel(teamModel);
        ReferenceBinding superTeamBinding = teamModel.getBinding().superclass();
        if (superTeamBinding instanceof ParameterizedTypeBinding && !(tsuperRole instanceof ParameterizedTypeBinding) && (env = Config.getLookupEnvironment()) != null) {
            tsuperRole = env.createParameterizedType(tsuperRole, null, superTeamBinding);
            RoleModel.setTagBit(tsuperRole, 1);
        }
        boolean tsuperAlreadyPresent = false;
        int i = 0;
        while (i < this.numTSuperRoles) {
            if (TypeBinding.equalsEquals(this._tsuperRoleBindings[i], tsuperRole)) {
                tsuperAlreadyPresent = true;
                break;
            }
            ++i;
        }
        if (!tsuperAlreadyPresent) {
            if (this.numTSuperRoles == this._tsuperRoleBindings.length) {
                this._tsuperRoleBindings = new ReferenceBinding[2 * this.numTSuperRoles];
                System.arraycopy(this._tsuperRoleBindings, 0, this._tsuperRoleBindings, 0, this.numTSuperRoles);
            }
            this._tsuperRoleBindings[this.numTSuperRoles++] = tsuperRole;
            if (this.getAst() != null && this.getAst().isInterface()) {
                TypeLevel.addImplicitInheritance(this.getAst(), tsuperRole);
            }
            WordValueAttribute.addClassFlags(this, 32);
            if (this._binding != null) {
                this._binding.modifiers |= 0x10000000;
            }
        }
        this._state.inititalize(2);
    }

    @Override
    protected String getKindString() {
        return "Role";
    }

    public void addSyntheticMethodMapping(MethodBinding srcMethod, MethodBinding dstMethod) {
        this._syntheticMap.put(srcMethod, dstMethod);
    }

    public MethodBinding mapSyntheticMethod(MethodBinding srcMethod) {
        if (srcMethod instanceof SyntheticRoleFieldAccess) {
            ReferenceBinding dstType = this.getBinding();
            if (dstType.isBinaryBinding()) {
                return null;
            }
            SyntheticMethodBinding[] synthetics = ((SourceTypeBinding)dstType).syntheticMethods();
            if (synthetics == null) {
                return null;
            }
            SyntheticMethodBinding[] syntheticMethodBindingArray = synthetics;
            int n = synthetics.length;
            int n2 = 0;
            while (n2 < n) {
                SyntheticMethodBinding methodBinding = syntheticMethodBindingArray[n2];
                if (CharOperation.equals(methodBinding.selector, srcMethod.selector)) {
                    return methodBinding;
                }
                ++n2;
            }
            return null;
        }
        return (MethodBinding)this._syntheticMap.get(srcMethod);
    }

    public void addSyntheticFieldMapping(FieldBinding srcField, FieldBinding newField) {
        this._syntheticMap.put(srcField, newField);
    }

    public FieldBinding mapSyntheticField(FieldBinding srcField) {
        return (FieldBinding)this._syntheticMap.get(srcField);
    }

    public int addInaccessibleBaseMethod(MethodBinding binding) {
        OTSpecialAccessAttribute specialAccess = this.getTeamModel().getSpecialAccessAttribute();
        ReferenceBinding declaringClass = binding.declaringClass;
        specialAccess.addAdaptedBaseClass(declaringClass);
        ReferenceBinding baseclass = this._binding.baseclass();
        boolean visibleInBaseClass = true;
        if (this.getWeavingScheme() == CompilerOptions.WeavingScheme.OTDRE) {
            TypeBinding declaringOriginal = declaringClass.original();
            if (binding.isPrivate()) {
                visibleInBaseClass = TypeBinding.equalsEquals(baseclass.original(), declaringOriginal);
            } else if (binding.isDefault()) {
                PackageBinding tgtPackage = declaringClass.fPackage;
                ReferenceBinding currentType = baseclass;
                while (currentType != null && TypeBinding.notEquals(currentType.original(), declaringOriginal)) {
                    if (tgtPackage != currentType.fPackage) {
                        visibleInBaseClass = false;
                        break;
                    }
                    currentType = currentType.superclass();
                }
            }
        }
        return specialAccess.addDecapsulatedMethodAccess(baseclass, binding, visibleInBaseClass);
    }

    public int addAccessedBaseField(FieldBinding field, int calloutModifier, OTSpecialAccessAttribute.CalloutToFieldDesc cpInheritanceSrc) {
        ReferenceBinding targetClass = field.declaringClass;
        if (!field.isStatic() && (field.isProtected() || field.isPublic())) {
            targetClass = this.getBaseTypeBinding();
        }
        OTSpecialAccessAttribute specialAccess = this.getTeamModel().getSpecialAccessAttribute();
        int accessId = specialAccess.addCalloutFieldAccess(field, targetClass, calloutModifier, cpInheritanceSrc);
        specialAccess.addAdaptedBaseClass(field.declaringClass);
        return accessId;
    }

    public void addMethodSuperAccess(MethodBinding baseMethod) {
        OTSpecialAccessAttribute specialAccess = this.getTeamModel().getSpecialAccessAttribute();
        specialAccess.addSuperMethodAccess(baseMethod);
    }

    public void markBaseClassDecapsulation(ReferenceBinding baseclass) {
        OTSpecialAccessAttribute specialAccess = this.getTeamModel().getSpecialAccessAttribute();
        specialAccess.addBaseClassDecapsulation(baseclass);
    }

    @Override
    public int writeAttributes(ClassFile file) {
        if (this._binding.callinCallouts != null) {
            int i = 0;
            while (i < this._binding.callinCallouts.length) {
                if (this._binding.callinCallouts[i].type != 1) {
                    this.addAttribute(new CalloutMappingsAttribute(this));
                    break;
                }
                ++i;
            }
        }
        return super.writeAttributes(file);
    }

    @Override
    public CPTypeAnchorAttribute getTypeAnchors() {
        return this._binding.model.getTypeAnchors();
    }

    public void setErrorFlag(boolean flag) {
        if (this._ast != null) {
            this._ast.ignoreFurtherInvestigation = flag;
        }
        if (this._classPart != null) {
            this._classPart.ignoreFurtherInvestigation = flag;
        }
        if (this._interfacePart != null) {
            this._interfacePart.ignoreFurtherInvestigation = flag;
        }
    }

    public void recordCopiedFeature(Binding feature) {
        this._copiedFeatureBindings.add(feature);
    }

    public boolean hasAlreadyBeenCopied(Binding feature) {
        return this._copiedFeatureBindings.contains(feature);
    }

    public char[] getBaseclassAttributename(boolean includeAnchor) {
        ReferenceBinding baseclass = this.getBinding().baseclass();
        char[] baseName = baseclass.getRealClass().attributeName();
        if (includeAnchor && RoleTypeBinding.isRoleWithExplicitAnchor(baseclass)) {
            return CharOperation.concat(baseName, CharOperation.concat(SingleValueAttribute.ANCHOR_DELIM, CharOperation.append(((RoleTypeBinding)baseclass)._teamAnchor.getBestName(), '>')));
        }
        return baseName;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this._copiedFeatureBindings = null;
    }

    public RoleModel getBoundRootRole() {
        if (this._boundRootRole != null) {
            return this._boundRootRole;
        }
        if (this._binding.isInterface() && this._classBinding != null) {
            RoleModel classPart = this._classBinding.roleModel;
            return classPart.getBoundRootRole();
        }
        return null;
    }

    public static int getDeclaredModifiers(ReferenceBinding typeBinding) {
        if (!typeBinding.isRole() || typeBinding.roleModel == null) {
            return typeBinding.modifiers;
        }
        ReferenceBinding classPartBinding = typeBinding.roleModel.getClassPartBinding();
        if (classPartBinding != null) {
            return classPartBinding.modifiers;
        }
        return typeBinding.modifiers;
    }

    public static boolean isRoleFromOuterEnclosing(SourceTypeBinding sourceType, ReferenceBinding baseclass) {
        ReferenceBinding enclosingTeam = sourceType.enclosingType();
        if (enclosingTeam == null || !enclosingTeam.isTeam()) {
            return false;
        }
        if (TypeBinding.equalsEquals(enclosingTeam, baseclass.enclosingType())) {
            return false;
        }
        do {
            if ((enclosingTeam = enclosingTeam.enclosingType()) != null && enclosingTeam.isTeam()) continue;
            return false;
        } while (!TypeBinding.equalsEquals(enclosingTeam, baseclass.enclosingType()));
        return true;
    }

    public boolean hasCallins() {
        if (this._attributes == null) {
            return false;
        }
        AbstractAttribute[] abstractAttributeArray = this._attributes;
        int n = this._attributes.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractAttribute attribute = abstractAttributeArray[n2];
            if (attribute.nameEquals(IOTConstants.CALLIN_METHOD_MAPPINGS) && !((CallinMethodMappingsAttribute)attribute).isInherited()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void implementMethodBindingsFromSuperinterfaces() {
        if (this._ast == null || this._ast.isInterface() || this._binding == null || this._binding.isLocalType()) {
            return;
        }
        ReferenceBinding interfacePartBinding = this.getInterfacePartBinding();
        if (interfacePartBinding == null) {
            return;
        }
        ReferenceBinding[] superInterfaces = interfacePartBinding.superInterfaces();
        if (superInterfaces == null) {
            return;
        }
        ReferenceBinding[] referenceBindingArray = superInterfaces;
        int n = superInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            CallinCalloutBinding[] methodMappings;
            ReferenceBinding superInterface = referenceBindingArray[n2];
            if (superInterface.isRole() && superInterface.roleModel.getState() >= 18 && Dependencies.ensureBindingState(superInterface, 19) && (methodMappings = superInterface.callinCallouts) != null) {
                CallinCalloutBinding[] callinCalloutBindingArray = methodMappings;
                int n3 = methodMappings.length;
                int n4 = 0;
                while (n4 < n3) {
                    CallinCalloutBinding mapping = callinCalloutBindingArray[n4];
                    if (mapping.isValidBinding() && mapping.isCallout()) {
                        new CalloutImplementor(this).generateFromBinding(mapping);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    @Override
    public void evaluateLateAttributes(int state) {
        if (state == 19) {
            ReferenceBinding[] referenceBindingArray = this.getTSuperRoleBindings();
            int n = referenceBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceBinding tsuperRole = referenceBindingArray[n2];
                Dependencies.ensureBindingState(tsuperRole, 19);
                ++n2;
            }
        }
        if (this._ast != null) {
            CopyInheritance.copyGeneratedFeatures(this);
        }
        super.evaluateLateAttributes(state);
    }

    public synchronized void releaseClassFile() {
        this._classFile = null;
    }

    public ReferenceBinding[] getBoundDescendants() {
        if (this._binding == null) {
            return new ReferenceBinding[0];
        }
        if (this._binding.baseclass() != null) {
            return new ReferenceBinding[]{this._binding};
        }
        ArrayList<ReferenceBinding> roles = new ArrayList<ReferenceBinding>();
        ReferenceBinding[] referenceBindingArray = this.getTeamModel().getKnownRoles();
        int n = referenceBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceBinding knownRole = referenceBindingArray[n2];
            if (knownRole.baseclass() != null && knownRole.isCompatibleWith(this._binding) && knownRole.superclass().baseclass() == null && !knownRole.isClass()) {
                roles.add(knownRole);
            }
            ++n2;
        }
        return roles.toArray(new ReferenceBinding[roles.size()]);
    }

    public MethodBinding getInheritedUnimplementedGetBase() {
        ReferenceBinding classPartBinding = this.getClassPartBinding();
        if (classPartBinding != null) {
            ReferenceBinding superclass = classPartBinding.superclass();
            while (superclass != null && superclass.isRole()) {
                RoleModel superRole = superclass.roleModel;
                if (superRole.unimplementedGetBase != null) {
                    return superRole.unimplementedGetBase;
                }
                superclass = superclass.superclass();
            }
        }
        return null;
    }

    public static Lifting.InstantiationPolicy getInstantiationPolicy(ReferenceBinding roleClassBinding) {
        if ((roleClassBinding.getAnnotationTagBits() & Long.MIN_VALUE) != 0L) {
            AnnotationBinding[] annotationBindingArray = roleClassBinding.getAnnotations();
            int n = annotationBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                AnnotationBinding annotation = annotationBindingArray[n2];
                if (annotation.getAnnotationType().id == 103) {
                    ElementValuePair[] elementValuePairArray = annotation.getElementValuePairs();
                    int n3 = elementValuePairArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ElementValuePair pair = elementValuePairArray[n4];
                        if (pair.value instanceof FieldBinding) {
                            String name = String.valueOf(((FieldBinding)pair.value).name);
                            try {
                                return Lifting.InstantiationPolicy.valueOf(name);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                return Lifting.InstantiationPolicy.ERROR;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return Lifting.InstantiationPolicy.ONDEMAND;
    }

    public static boolean areTypeParametersOfSameRole(TypeVariableBinding one, Binding two) {
        if (!(two instanceof TypeVariableBinding)) {
            return false;
        }
        Binding declaring1 = one.declaringElement;
        Binding declaring2 = ((TypeVariableBinding)two).declaringElement;
        if (!(declaring1 instanceof ReferenceBinding) || !(declaring2 instanceof ReferenceBinding)) {
            return false;
        }
        return TypeBinding.equalsEquals(((ReferenceBinding)declaring1).getRealType(), ((ReferenceBinding)declaring2).getRealType());
    }
}

