/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.migration;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.objectteams.otdt.core.ext.OTDTPlugin;
import org.eclipse.objectteams.otdt.internal.migration.Messages;
import org.eclipse.objectteams.otdt.internal.migration.MigrationMarkers;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.PDEManifestElement;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleHeader;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;
import org.eclipse.pde.internal.ui.correction.AbstractXMLMarkerResolution;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;

public class MigrationResolutions
implements IMarkerResolutionGenerator {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        switch (MigrationMarkers.getProblemID(marker)) {
            case 1: 
            case 2: {
                return new IMarkerResolution[]{new ProjectSetupResolution()};
            }
            case 3: {
                return new IMarkerResolution[]{new UpdateOTEquinoxDependency()};
            }
            case 4: {
                return new IMarkerResolution[]{new UpdateOTEquinoxExtensionpoint(marker)};
            }
        }
        return new IMarkerResolution[0];
    }

    private class ProjectSetupResolution
    implements IMarkerResolution {
        private ProjectSetupResolution() {
        }

        public String getLabel() {
            return Messages.MigrationResolutions_update_nature_and_builder_label;
        }

        public void run(IMarker marker) {
            try {
                IProject project = (IProject)marker.getResource();
                IProjectDescription prjDesc = project.getDescription();
                prjDesc.setNatureIds(this.replaceOrAddOTJavaNature(prjDesc));
                prjDesc.setBuildSpec(this.replaceOrAddOTBuilder(prjDesc));
                project.setDescription(prjDesc, null);
            }
            catch (CoreException ce) {
                JavaCore.getJavaCore().getLog().log((IStatus)new Status(4, "org.eclipse.objectteams.otdt.internal.pde.ui", "Error updating .project", (Throwable)ce));
            }
        }

        private String[] replaceOrAddOTJavaNature(IProjectDescription prjDesc) throws CoreException {
            String[] natures = prjDesc.getNatureIds();
            int i = 0;
            while (i < natures.length) {
                if ("org.objectteams.otdt.OTJavaNature".equals(natures[i])) {
                    natures[i] = "org.eclipse.objectteams.otdt.OTJavaNature";
                    return natures;
                }
                if ("org.eclipse.objectteams.otdt.OTJavaNature".equals(natures[i])) {
                    return natures;
                }
                ++i;
            }
            return OTDTPlugin.createProjectNatures((IProjectDescription)prjDesc);
        }

        private ICommand[] replaceOrAddOTBuilder(IProjectDescription prjDesc) {
            ICommand[] buildSpecs = prjDesc.getBuildSpec();
            ICommand otBuildCmd = OTDTPlugin.createProjectBuildCommand((IProjectDescription)prjDesc);
            int i = 0;
            while (i < buildSpecs.length) {
                if ("org.objectteams.otdt.builder.OTJBuilder".equals(buildSpecs[i].getBuilderName())) {
                    buildSpecs[i] = otBuildCmd;
                    return buildSpecs;
                }
                if ("org.eclipse.objectteams.otdt.builder.OTJBuilder".equals(buildSpecs[i].getBuilderName())) {
                    return buildSpecs;
                }
                ++i;
            }
            int len = buildSpecs.length;
            ICommand[] iCommandArray = buildSpecs;
            buildSpecs = new ICommand[len + 1];
            System.arraycopy(iCommandArray, 0, buildSpecs, 0, len);
            buildSpecs[len] = otBuildCmd;
            return buildSpecs;
        }
    }

    protected class UpdateOTEquinoxDependency
    extends AbstractManifestMarkerResolution {
        public UpdateOTEquinoxDependency() {
            super(-1);
        }

        public String getLabel() {
            return Messages.MigrationResolutions_update_bundle_name_label;
        }

        protected void createChange(BundleModel model) {
            IManifestHeader header = model.getBundle().getManifestHeader("Require-Bundle");
            if (header == null || !(header instanceof RequireBundleHeader)) {
                return;
            }
            PDEManifestElement[] pDEManifestElementArray = ((RequireBundleHeader)header).getElements();
            int n = pDEManifestElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                PDEManifestElement required = pDEManifestElementArray[n2];
                if ("org.objectteams.otequinox".equals(required.getValue())) {
                    required.setValue("org.eclipse.objectteams.otequinox");
                    header.update(true);
                    return;
                }
                ++n2;
            }
        }
    }

    protected class UpdateOTEquinoxExtensionpoint
    extends AbstractXMLMarkerResolution {
        static final String ICON = "icon";
        static final String ORG_OBJECTTEAMS = "org.objectteams";
        static final String ORG_ECLIPSE_OBJECTTEAMS = "org.eclipse.objectteams";

        public UpdateOTEquinoxExtensionpoint(IMarker marker) {
            super(-1, marker);
        }

        public String getLabel() {
            return Messages.MigrationResolutions_update_extension_label;
        }

        protected void createChange(IPluginModelBase model) {
            IExtensions extensions = model.getExtensions();
            if (extensions == null) {
                return;
            }
            IPluginExtension[] iPluginExtensionArray = extensions.getExtensions();
            int n = iPluginExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginExtension extension = iPluginExtensionArray[n2];
                if ("org.objectteams.otequinox.aspectBindings".equals(extension.getPoint())) {
                    try {
                        extension.setPoint("org.eclipse.objectteams.otequinox.aspectBindings");
                        IPluginObject[] iPluginObjectArray = extension.getChildren();
                        int n3 = iPluginObjectArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IPluginObject elem = iPluginObjectArray[n4];
                            if (elem instanceof IPluginParent) {
                                this.updateIcon(elem);
                                IPluginObject[] iPluginObjectArray2 = ((IPluginParent)elem).getChildren();
                                int n5 = iPluginObjectArray2.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    IPluginObject grandChild = iPluginObjectArray2[n6];
                                    this.updateIcon(grandChild);
                                    ++n6;
                                }
                            }
                            ++n4;
                        }
                    }
                    catch (CoreException ce) {
                        JavaCore.getJavaCore().getLog().log((IStatus)new Status(4, "org.eclipse.objectteams.otdt.internal.pde.ui", "Error updating plugin.xml", (Throwable)ce));
                    }
                }
                ++n2;
            }
        }

        private void updateIcon(IPluginObject element) {
            IDocumentElementNode node;
            String icon;
            if (element instanceof IDocumentElementNode && (icon = (node = (IDocumentElementNode)element).getXMLAttributeValue(ICON)) != null && icon.contains(ORG_OBJECTTEAMS)) {
                node.setXMLAttribute(ICON, icon.replace(ORG_OBJECTTEAMS, ORG_ECLIPSE_OBJECTTEAMS));
            }
        }
    }
}

