/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.objectteams.otredyn.bytecode.AbstractBoundClass;
import org.eclipse.objectteams.otredyn.bytecode.Method;
import org.eclipse.objectteams.otredyn.bytecode.asm.AbstractTransformableClassNode;
import org.eclipse.objectteams.otredyn.transformer.names.ClassNames;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ReplaceWickedSuperCallsAdapter
extends AbstractTransformableClassNode
implements AbstractTransformableClassNode.IBoundMethodIdInsnProvider {
    private AbstractBoundClass superclass;
    private List<Method> targetMethods = new ArrayList<Method>();
    private Map<MethodNode, List<MethodInsnNode>> instructionsToWeave = new HashMap<MethodNode, List<MethodInsnNode>>();

    public static void register(List<AbstractTransformableClassNode> nodes, AbstractBoundClass superclass, Method targetMethod) {
        for (AbstractTransformableClassNode node : nodes) {
            if (!(node instanceof ReplaceWickedSuperCallsAdapter)) continue;
            ((ReplaceWickedSuperCallsAdapter)node).addTargetMethod(targetMethod);
            return;
        }
        nodes.add(new ReplaceWickedSuperCallsAdapter(superclass, targetMethod));
    }

    private ReplaceWickedSuperCallsAdapter(AbstractBoundClass superclass, Method targetMethod) {
        this.superclass = superclass;
        this.targetMethods.add(targetMethod);
    }

    private void addTargetMethod(Method targetMethod) {
        this.targetMethods.add(targetMethod);
    }

    public MethodVisitor visitMethod(int access, final String enclosingMethodName, String enclosingMethodDesc, String signature, String[] exceptions) {
        final MethodNode mn = new MethodNode(access, enclosingMethodName, enclosingMethodDesc, signature, exceptions);
        this.methods.add(mn);
        return new MethodVisitor(this.api, (MethodVisitor)mn){

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
                if (opcode == 183 && !enclosingMethodName.equals(name) && owner.equals(ReplaceWickedSuperCallsAdapter.this.superclass.getInternalName())) {
                    for (Method tgt : ReplaceWickedSuperCallsAdapter.this.targetMethods) {
                        if (!tgt.getName().equals(name) || !tgt.getSignature().equals(desc)) continue;
                        ArrayList<MethodInsnNode> insns = (ArrayList<MethodInsnNode>)ReplaceWickedSuperCallsAdapter.this.instructionsToWeave.get(mn);
                        if (insns == null) {
                            insns = new ArrayList<MethodInsnNode>();
                            ReplaceWickedSuperCallsAdapter.this.instructionsToWeave.put(mn, insns);
                        }
                        insns.add((MethodInsnNode)mn.instructions.getLast());
                        break;
                    }
                }
            }
        };
    }

    @Override
    protected boolean transform() {
        if (this.instructionsToWeave.isEmpty()) {
            return false;
        }
        for (Map.Entry<MethodNode, List<MethodInsnNode>> toWeave : this.instructionsToWeave.entrySet()) {
            MethodNode enclosingMethod = toWeave.getKey();
            InsnList instructions = enclosingMethod.instructions;
            List<MethodInsnNode> superCallsToReplace = toWeave.getValue();
            Type returnType = Type.getReturnType((String)enclosingMethod.desc);
            boolean returnsJLObject = returnType.getSort() == 10 ? returnType.getInternalName().equals(ClassNames.OBJECT_SLASH) : false;
            this.replaceSuperCallsWithCallToCallOrig(instructions, superCallsToReplace, returnsJLObject, this);
        }
        return true;
    }

    @Override
    public AbstractInsnNode getLoadBoundMethodIdInsn(MethodInsnNode methodInsn) {
        Method otdreMethod = this.superclass.getMethod(methodInsn.name, methodInsn.desc, false, false);
        int methodID = otdreMethod.getGlobalId(this.superclass);
        return this.createLoadIntConstant(methodID);
    }
}

