/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otre.jplis;

import java.io.IOException;
import java.io.InputStream;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.MethodGen;
import org.eclipse.objectteams.otre.ClassEnhancer;
import org.eclipse.objectteams.otre.ClassLoaderAccess;
import org.eclipse.objectteams.otre.ObjectTeamsTransformation;
import org.objectteams.OTREInternalError;

public class JPLISEnhancer
implements ClassEnhancer {
    private Object loader;

    public JPLISEnhancer(ClassGen cg, Object loader) {
        this.loader = loader;
    }

    @Override
    public void addImplements(String interfaceName, ClassGen cg) {
        cg.addInterface(interfaceName);
    }

    @Override
    public void addMethod(Method m, ClassGen cg) {
        if (cg.containsMethod(m.getName(), m.getSignature()) != null) {
            new OTREInternalError("Warning: repetive adding of method " + m.getName() + m.getSignature() + " to class " + cg.getClassName()).printStackTrace();
        }
        cg.addMethod(m);
        JPLISEnhancer.requireClassFileVersionLessThan51(cg);
    }

    @Override
    public void addOrReplaceMethod(Method method, ClassGen cg) {
        Method existingMethod = cg.containsMethod(method.getName(), method.getSignature());
        if (existingMethod == null) {
            this.addMethod(method, cg);
        } else {
            cg.replaceMethod(existingMethod, method);
        }
        JPLISEnhancer.requireClassFileVersionLessThan51(cg);
    }

    public static void requireClassFileVersionLessThan51(ClassGen cg) {
        if (cg.getMajor() >= 51) {
            cg.setMajor(50);
        }
    }

    @Override
    public void addField(Field f, ClassGen cg) {
        if (cg.containsField(f.getName()) != null) {
            new OTREInternalError("Warning: repetitive adding of field " + f.getName() + f.getSignature() + " to class " + cg.getClassName()).printStackTrace();
        }
        cg.addField(f);
    }

    @Override
    public void loadClass(String className, ObjectTeamsTransformation client) {
        block14: {
            if (System.getProperty("ot.equinox") != null) {
                return;
            }
            InputStream is = null;
            try {
                try {
                    String binaryName = className.replace('.', '/');
                    is = ClassLoaderAccess.getResourceAsStream(this.loader, String.valueOf(binaryName) + ".class");
                    if (is != null) {
                        ClassGen cg = new ClassGen(new ClassParser(is, className).parse());
                        client.checkReadClassAttributes(this, cg, className, cg.getConstantPool());
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    if (is == null) break block14;
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public void decapsulateMethod(Method m, ClassGen cg, String packageName, ConstantPoolGen cpg) {
        String className = cg.getClassName();
        int flags = m.getAccessFlags();
        MethodGen mg = new MethodGen(m, className, cpg);
        if ((flags & 1) == 0) {
            int newFlags = flags;
            newFlags &= 0xFFFFFFF9;
            mg.setAccessFlags(newFlags |= 1);
            if (System.getProperty("ot.log") != null) {
                ObjectTeamsTransformation.printLogMessage("Adjusting from " + Utility.accessToString((int)flags) + " to public:\n\t" + className + "." + m);
            }
            if (!packageName.equals("NO_PACKAGE")) {
                JPLISEnhancer.checkSeal(packageName, className);
            }
        }
        cg.replaceMethod(m, mg.getMethod());
    }

    private static void checkSeal(String package_name, String class_name) {
        Package pckg = Package.getPackage(package_name);
        if (pckg != null && pckg.isSealed()) {
            throw new IllegalAccessError("OT/J callout binding:\nTrying to break sealed " + pckg);
        }
    }
}

