/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.bindingeditor;

import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractMethodMappingDeclaration;
import org.eclipse.jdt.core.dom.CallinMappingDeclaration;
import org.eclipse.jdt.core.dom.CalloutMappingDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldAccessSpec;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodMappingElement;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterMapping;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.RoleTypeDeclaration;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.ui.bindingeditor.AddTypeBindingDialog;
import org.eclipse.objectteams.otdt.internal.ui.bindingeditor.BindingConfiguration;
import org.eclipse.objectteams.otdt.internal.ui.bindingeditor.CallinMappingConfiguration;
import org.eclipse.objectteams.otdt.internal.ui.bindingeditor.CalloutMappingConfiguration;
import org.eclipse.objectteams.otdt.internal.ui.bindingeditor.Messages;
import org.eclipse.objectteams.otdt.ui.ImageManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class BindingEditor
extends Composite {
    private IType _team;
    final BindingConfiguration bindConfig;
    private Tree _connTableTree;
    private TabFolder _tabFolder;
    private CallinMappingConfiguration _callinMapConfig;
    private CalloutMappingConfiguration _calloutMapConfig;
    private TabItem _paraMapItem;
    private TabItem _methMapItem;
    private final TabItem[] _methMapItems;
    private final TabItem[] _paraMapItems;
    final TreeViewer _connTableViewer;
    private TypeDeclaration _rootTeam;
    HashMap<String, String> _baseClassLookup = new HashMap();

    public BindingEditor(final Composite parent, int style, final IType teamType, final CompilationUnit root) {
        super(parent, style);
        this._team = teamType;
        this.calculateRootNode(root);
        this.setLayout((Layout)new FormLayout());
        Group connDefGroup = new Group((Composite)this, 0);
        connDefGroup.setText(Messages.BindingEditor_connector_title);
        FormData formData = new FormData();
        formData.bottom = new FormAttachment(58, 0);
        formData.right = new FormAttachment(100, -5);
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 5);
        connDefGroup.setLayoutData((Object)formData);
        connDefGroup.setLayout((Layout)new FormLayout());
        this._connTableViewer = new TreeViewer((Composite)connDefGroup, 2048);
        this._connTableViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this._connTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this._connTableViewer.setAutoExpandLevel(2);
        this._connTableTree = this._connTableViewer.getTree();
        FormData formData_2 = new FormData();
        formData_2.bottom = new FormAttachment(84, 0);
        formData_2.right = new FormAttachment(100, -5);
        formData_2.top = new FormAttachment(0, 5);
        formData_2.left = new FormAttachment(0, 5);
        this._connTableTree.setLayoutData((Object)formData_2);
        this._connTableTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                BindingEditor.this.bindingTableSelectionChanged();
            }
        });
        this._connTableTree.setLinesVisible(true);
        this._connTableTree.setHeaderVisible(true);
        TreeColumn rolesCol = new TreeColumn(this._connTableTree, 0);
        rolesCol.setWidth(300);
        rolesCol.setText(Messages.BindingEditor_role_types_title);
        TreeColumn methMapColumn = new TreeColumn(this._connTableTree, 0);
        methMapColumn.setWidth(80);
        TreeColumn baseCol = new TreeColumn(this._connTableTree, 0);
        baseCol.setWidth(300);
        baseCol.setText(Messages.BindingEditor_base_types_title);
        this._connTableViewer.setInput((Object)this._rootTeam);
        Composite buttonComp = new Composite((Composite)connDefGroup, 0);
        FormData formData_3 = new FormData();
        formData_3.bottom = new FormAttachment(100, -5);
        formData_3.right = new FormAttachment(100, -5);
        formData_3.top = new FormAttachment((Control)this._connTableTree, 5, 1024);
        formData_3.left = new FormAttachment((Control)this._connTableTree, 0, 16384);
        buttonComp.setLayoutData((Object)formData_3);
        buttonComp.setLayout((Layout)new FormLayout());
        Button addConnBtn = new Button(buttonComp, 0);
        FormData formData_4 = new FormData();
        formData_4.top = new FormAttachment(0, 5);
        formData_4.left = new FormAttachment(0, 5);
        addConnBtn.setLayoutData((Object)formData_4);
        addConnBtn.setText(Messages.BindingEditor_add_type_binding_button);
        addConnBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IType roleClass = null;
                AddTypeBindingDialog dlg = AddTypeBindingDialog.create(parent.getShell(), teamType);
                if (dlg.open() != 0) {
                    return;
                }
                roleClass = dlg.getRoleType();
                AST ast = BindingEditor.this._rootTeam.getAST();
                RoleTypeDeclaration role = ast.newRoleTypeDeclaration();
                role.setName(ast.newSimpleName(roleClass.getElementName()));
                role.setRole(true);
                try {
                    int flags = roleClass.getFlags() & 0xFFFFFBFF;
                    role.modifiers().addAll(ast.newModifiers(flags));
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
                String qualifiedBaseTypeName = dlg.getBaseTypeName();
                String[] identifiers = qualifiedBaseTypeName.split("\\.");
                int len = identifiers.length;
                String singleName = identifiers[len - 1];
                role.setBaseClassType((Type)ast.newSimpleType(ast.newName(singleName)));
                BindingEditor.this._baseClassLookup.put(singleName, qualifiedBaseTypeName);
                BindingEditor.this._rootTeam.bodyDeclarations().add(role);
                ImportDeclaration baseImport = ast.newImportDeclaration();
                baseImport.setBase(true);
                baseImport.setName(ast.newName(identifiers));
                root.imports().add(baseImport);
                BindingEditor.this.refresh();
                BindingEditor.this._connTableViewer.setSelection((ISelection)new StructuredSelection((Object)role));
                BindingEditor.this.bindingTableSelectionChanged();
            }
        });
        Button remConnBtn = new Button(buttonComp, 0);
        FormData formData_5 = new FormData();
        formData_5.top = new FormAttachment((Control)addConnBtn, 0, 128);
        formData_5.left = new FormAttachment((Control)addConnBtn, 5, 131072);
        remConnBtn.setLayoutData((Object)formData_5);
        remConnBtn.setText(Messages.BindingEditor_remove_button);
        remConnBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                BindingEditor.this.removeElementsFromAST();
                BindingEditor.this.refresh();
                BindingEditor.this.bindConfig.resetLists();
            }
        });
        this._tabFolder = new TabFolder((Composite)this, 0);
        FormData formData_1 = new FormData();
        formData_1.bottom = new FormAttachment(100, -5);
        formData_1.right = new FormAttachment(100, -5);
        formData_1.top = new FormAttachment((Control)connDefGroup, 5, 1024);
        formData_1.left = new FormAttachment(0, 5);
        this._tabFolder.setLayoutData((Object)formData_1);
        this.bindConfig = new BindingConfiguration((Composite)this._tabFolder, 0);
        this.bindConfig.setCurrentTeamForMethodFake(teamType);
        this._methMapItem = new TabItem(this._tabFolder, 0);
        this._methMapItem.setText(Messages.BindingEditor_method_binding_tab);
        this._methMapItem.setControl((Control)this.bindConfig);
        this._methMapItems = new TabItem[]{this._methMapItem};
        this._callinMapConfig = new CallinMappingConfiguration((Composite)this._tabFolder, 0);
        this._calloutMapConfig = new CalloutMappingConfiguration((Composite)this._tabFolder, 0);
        this._paraMapItem = new TabItem(this._tabFolder, 0);
        this._paraMapItem.setText(Messages.BindingEditor_param_mapping_tab);
        this._paraMapItem.setControl((Control)this._callinMapConfig);
        this._paraMapItems = new TabItem[]{this._paraMapItem};
    }

    private void calculateRootNode(CompilationUnit cu) {
        try {
            final TypeDeclaration[] teamDecl = new TypeDeclaration[1];
            final int teamPos = this._team.getNameRange().getOffset();
            GenericVisitor visitor = new GenericVisitor(){

                public boolean visit(CompilationUnit node) {
                    for (TypeDeclaration type : node.types()) {
                        if (this.visit(type)) continue;
                        return false;
                    }
                    return false;
                }

                public boolean visit(TypeDeclaration node) {
                    int pos = node.getName().getStartPosition();
                    if (pos == teamPos) {
                        teamDecl[0] = node;
                        return false;
                    }
                    TypeDeclaration[] memberTypes = node.getTypes();
                    int i = 0;
                    while (i < memberTypes.length) {
                        if (!this.visit(memberTypes[i])) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }

                public boolean visit(RoleTypeDeclaration node) {
                    return this.visit((TypeDeclaration)node);
                }
            };
            visitor.visit(cu);
            this._rootTeam = teamDecl[0];
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private void prepareParameterMappingConfiguration(AbstractMethodMappingDeclaration methMap, ParameterMapping paraMap) {
        if (methMap == null) {
            this._paraMapItem.setControl(null);
        } else if (methMap instanceof CallinMappingDeclaration) {
            this._paraMapItem.setControl((Control)this._callinMapConfig);
            this._callinMapConfig.setFocus(paraMap, (CallinMappingDeclaration)methMap);
        } else if (methMap instanceof CalloutMappingDeclaration) {
            this._paraMapItem.setControl((Control)this._calloutMapConfig);
            this._calloutMapConfig.setFocus(paraMap, (CalloutMappingDeclaration)methMap);
        }
    }

    private void removeElementsFromAST() {
        TreeItem[] selectedItems = this._connTableTree.getSelection();
        ASTNode selectedNode = null;
        int idx = 0;
        while (idx < selectedItems.length) {
            selectedNode = (ASTNode)selectedItems[idx].getData();
            if (selectedNode.getParent() instanceof TypeDeclaration) {
                this.removeElementFromAST(selectedNode);
            } else if (selectedNode.getParent() instanceof AbstractMethodMappingDeclaration) {
                this.removeElementFromAST((ParameterMapping)selectedNode);
            }
            ++idx;
        }
    }

    private void removeElementFromAST(ASTNode selectedNode) {
        TypeDeclaration parent = (TypeDeclaration)selectedNode.getParent();
        parent.bodyDeclarations().remove(selectedNode);
    }

    private void removeElementFromAST(ParameterMapping selectedNode) {
        AbstractMethodMappingDeclaration abstractMethodMappingDeclaration = (AbstractMethodMappingDeclaration)selectedNode.getParent();
        abstractMethodMappingDeclaration.getParameterMappings().remove(selectedNode);
    }

    protected void checkSubclass() {
    }

    private AbstractMethodMappingDeclaration getAbstractMethodMapping(ParameterMapping paraMap) {
        return (AbstractMethodMappingDeclaration)paraMap.getParent();
    }

    public void refresh() {
        this._connTableViewer.refresh();
    }

    public void bindingTableSelectionChanged() {
        TreeItem[] selectedItems = this._connTableTree.getSelection();
        ASTNode selectedNode = null;
        int idx = 0;
        while (idx < selectedItems.length) {
            selectedNode = (ASTNode)selectedItems[idx].getData();
            switch (selectedNode.getNodeType()) {
                case 128: {
                    RoleTypeDeclaration roleTypeDecl = (RoleTypeDeclaration)selectedNode;
                    this.bindConfig.setFocusRole(roleTypeDecl, this._team, true);
                    this.prepareParameterMappingConfiguration(null, null);
                    this._tabFolder.setSelection(this._methMapItems);
                    break;
                }
                case 121: {
                    this.bindConfig.setCalloutMapping(selectedNode, this._team);
                    this.prepareParameterMappingConfiguration((AbstractMethodMappingDeclaration)selectedNode, null);
                    this._tabFolder.setSelection(this._methMapItems);
                    break;
                }
                case 120: {
                    this.bindConfig.setCallinMapping(selectedNode, this._team);
                    this.prepareParameterMappingConfiguration((AbstractMethodMappingDeclaration)selectedNode, null);
                    this._tabFolder.setSelection(this._methMapItems);
                    break;
                }
                case 125: {
                    ParameterMapping paraMap = (ParameterMapping)selectedNode;
                    AbstractMethodMappingDeclaration methMap = this.getAbstractMethodMapping(paraMap);
                    this.prepareParameterMappingConfiguration(methMap, paraMap);
                    this._tabFolder.setSelection(this._paraMapItems);
                    break;
                }
            }
            ++idx;
        }
    }

    public void methodBindingAdded(AbstractMethodMappingDeclaration mapping) {
        this._connTableViewer.expandToLevel((Object)mapping.getParent(), 1);
        this.bindingTableSelectionChanged();
    }

    private Name getRoleBaseClass(RoleTypeDeclaration element) {
        Name result = null;
        Type baseType = element.getBaseClassType();
        if (baseType != null) {
            if (baseType.isParameterizedType()) {
                baseType = ((ParameterizedType)baseType).getType();
            }
            if (baseType.isSimpleType()) {
                result = ((SimpleType)baseType).getName();
            } else if (baseType.isQualifiedType()) {
                result = ((QualifiedType)baseType).getName();
            } else assert (false);
        }
        return result;
    }

    public boolean isRootTeam(TypeDeclaration currentType) {
        return this._rootTeam == currentType;
    }

    class LabelProvider
    extends WorkbenchLabelProvider
    implements ITableLabelProvider {
        private static final String INDENT = "    ";
        private static final String PARAMETER_MAPPING_RIGHT = "->";
        private static final String EMPTY_TEXT = "";

        LabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ASTNode node = (ASTNode)element;
            switch (columnIndex) {
                case 0: {
                    if (node.getNodeType() != 128) break;
                    if (((RoleTypeDeclaration)node).isTeam()) {
                        return ImageManager.getSharedInstance().get("team_role_obj.gif");
                    }
                    return ImageManager.getSharedInstance().get("role_obj.png");
                }
                case 2: {
                    MethodMappingElement baseMappingElement;
                    if (node.getNodeType() == 128) {
                        ITypeBinding binding = ((TypeDeclaration)node).resolveBinding();
                        if (binding != null) {
                            binding = binding.getBaseClass();
                        }
                        if (binding != null) {
                            if (binding.isRole()) {
                                if (binding.isTeam()) {
                                    return ImageManager.getSharedInstance().get("team_role_obj.gif");
                                }
                                return ImageManager.getSharedInstance().get("role_obj.png");
                            }
                            if (binding.isTeam()) {
                                return ImageManager.getSharedInstance().get("team_obj.gif");
                            }
                        }
                        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
                    }
                    if (node.getNodeType() != 121 || (baseMappingElement = ((CalloutMappingDeclaration)node).getBaseMappingElement()).getNodeType() != 127) break;
                    IVariableBinding field = ((FieldAccessSpec)baseMappingElement).resolveBinding();
                    if (field != null) {
                        if (Modifier.isPublic((int)field.getModifiers())) {
                            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.field_public_obj.gif");
                        }
                        if (Modifier.isProtected((int)field.getModifiers())) {
                            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.field_protected_obj.gif");
                        }
                        if (Modifier.isPrivate((int)field.getModifiers())) {
                            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.field_private_obj.gif");
                        }
                    }
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.field_default_obj.gif");
                }
                case 1: {
                    switch (node.getNodeType()) {
                        case 120: {
                            int callinModifier = ((CallinMappingDeclaration)element).getCallinModifier();
                            if (Modifier.isAfter((int)callinModifier)) {
                                return ImageManager.getSharedInstance().get("callinbindingafter_obj.gif");
                            }
                            if (Modifier.isBefore((int)callinModifier)) {
                                return ImageManager.getSharedInstance().get("callinbindingbefore_obj.gif");
                            }
                            return ImageManager.getSharedInstance().get("callinbindingreplace_obj.gif");
                        }
                        case 121: {
                            return ImageManager.getSharedInstance().get("calloutbinding_obj.gif");
                        }
                        case 125: {
                            ParameterMapping mapping = (ParameterMapping)element;
                            if (mapping.getDirection().equals(PARAMETER_MAPPING_RIGHT)) {
                                return ImageManager.getSharedInstance().get("calloutbinding_obj.gif");
                            }
                            return ImageManager.getSharedInstance().get("callinbindingreplace_obj.gif");
                        }
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ASTNode node = (ASTNode)element;
            switch (node.getNodeType()) {
                case 128: {
                    RoleTypeDeclaration role = (RoleTypeDeclaration)element;
                    switch (columnIndex) {
                        case 0: {
                            return role.getName().getIdentifier();
                        }
                        case 1: {
                            return EMPTY_TEXT;
                        }
                        case 2: {
                            Name baseClass = BindingEditor.this.getRoleBaseClass(role);
                            if (baseClass != null) {
                                return baseClass.getFullyQualifiedName();
                            }
                            return EMPTY_TEXT;
                        }
                    }
                    return EMPTY_TEXT;
                }
                case 120: {
                    CallinMappingDeclaration callinDecl = (CallinMappingDeclaration)element;
                    switch (columnIndex) {
                        case 0: {
                            return callinDecl.getRoleMappingElement().toString();
                        }
                        case 1: {
                            if (Modifier.isAfter((int)callinDecl.getCallinModifier())) {
                                return new String(IOTConstants.NAME_AFTER);
                            }
                            if (Modifier.isBefore((int)callinDecl.getCallinModifier())) {
                                return new String(IOTConstants.NAME_BEFORE);
                            }
                            if (Modifier.isReplace((int)callinDecl.getCallinModifier())) {
                                return new String(IOTConstants.NAME_REPLACE);
                            }
                            return EMPTY_TEXT;
                        }
                        case 2: {
                            List baseMappingElements = callinDecl.getBaseMappingElements();
                            String result = INDENT;
                            int idx = 0;
                            while (idx < baseMappingElements.size()) {
                                if (idx > 0) {
                                    result = String.valueOf(result) + ", ";
                                }
                                result = String.valueOf(result) + baseMappingElements.get(idx).toString();
                                ++idx;
                            }
                            return result;
                        }
                    }
                    return EMPTY_TEXT;
                }
                case 121: {
                    CalloutMappingDeclaration callout = (CalloutMappingDeclaration)element;
                    switch (columnIndex) {
                        case 0: {
                            return callout.getRoleMappingElement().toString();
                        }
                        case 1: {
                            return EMPTY_TEXT;
                        }
                        case 2: {
                            return INDENT + callout.getBaseMappingElement().toString();
                        }
                    }
                    return EMPTY_TEXT;
                }
                case 125: {
                    ParameterMapping mapping = (ParameterMapping)element;
                    switch (columnIndex) {
                        case 0: {
                            if (mapping.getDirection().equals(PARAMETER_MAPPING_RIGHT)) {
                                return mapping.getExpression().toString();
                            }
                            return mapping.getIdentifier().getIdentifier();
                        }
                        case 1: {
                            return EMPTY_TEXT;
                        }
                        case 2: {
                            if (mapping.getDirection().equals(PARAMETER_MAPPING_RIGHT)) {
                                return INDENT + mapping.getIdentifier();
                            }
                            return INDENT + mapping.getExpression().toString();
                        }
                    }
                    return EMPTY_TEXT;
                }
            }
            return EMPTY_TEXT;
        }
    }

    class TreeContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        TreeContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            TypeDeclaration decl = (TypeDeclaration)inputElement;
            return decl.getTypes();
        }

        public Object[] getChildren(Object parentElement) {
            ASTNode node = (ASTNode)parentElement;
            if (node.getNodeType() == 128) {
                RoleTypeDeclaration roleNode = (RoleTypeDeclaration)node;
                CalloutMappingDeclaration[] callouts = roleNode.getCallOuts();
                CallinMappingDeclaration[] callins = roleNode.getCallIns();
                RoleTypeDeclaration[] roles = roleNode.getRoles();
                Object[] result = new Object[roles.length + callouts.length + callins.length];
                System.arraycopy(roles, 0, result, 0, roles.length);
                System.arraycopy(callouts, 0, result, roles.length, callouts.length);
                System.arraycopy(callins, 0, result, roles.length + callouts.length, callins.length);
                return result;
            }
            if (node.getNodeType() == 120 || node.getNodeType() == 121) {
                AbstractMethodMappingDeclaration mapping = (AbstractMethodMappingDeclaration)node;
                List pMappings = mapping.getParameterMappings();
                return pMappings.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }
}

