/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.compiler.adaptor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.objectteams.otdt.internal.compiler.adaptor.AspectBindingReader;

public class AdaptedBaseBundle {
    private HashMap<AspectBindingReader, Object> readers = new HashMap();
    String symbolicName;
    Set<String> adaptingTeams;
    public final Set<String> cpEntryPaths = new HashSet<String>();

    public AdaptedBaseBundle(String symbolicName, AspectBindingReader reader) {
        this.symbolicName = symbolicName;
        this.adaptingTeams = reader.getTeamsForBase(symbolicName);
        this.readers.put(reader, reader.token);
    }

    public boolean isAdaptedBy(String teamName) {
        this.checkReload();
        for (String aTeam : this.adaptingTeams) {
            if (!aTeam.equals(teamName)) continue;
            return true;
        }
        return false;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public synchronized boolean merge(AdaptedBaseBundle otherData) {
        if (this.symbolicName.equals(otherData.symbolicName)) {
            this.adaptingTeams.addAll(otherData.adaptingTeams);
            this.readers.putAll(otherData.readers);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReload() {
        HashMap<AspectBindingReader, Object> hashMap = this.readers;
        synchronized (hashMap) {
            boolean reloadNeeded = false;
            for (Map.Entry<AspectBindingReader, Object> readerEntry : this.readers.entrySet()) {
                AspectBindingReader reader = readerEntry.getKey();
                if (readerEntry.getValue() == reader.token) continue;
                reloadNeeded = true;
                this.readers.put(reader, reader.token);
            }
            if (!reloadNeeded) {
                return;
            }
            HashSet<String> newSet = new HashSet<String>();
            for (AspectBindingReader reader : this.readers.keySet()) {
                newSet.addAll(reader.getTeamsForBase(this.symbolicName));
            }
            this.adaptingTeams = newSet;
        }
    }

    public String toString() {
        String result = "bundle " + this.symbolicName + " is adapted by";
        if (this.adaptingTeams == null) {
            return result + " (null)";
        }
        if (this.adaptingTeams.isEmpty()) {
            return result + " no teams";
        }
        for (String aTeam : this.adaptingTeams) {
            result = result + "\n\t" + aTeam;
        }
        return result;
    }
}

