/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.bindingeditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CalloutMappingDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccessSpec;
import org.eclipse.jdt.core.dom.MethodMappingElement;
import org.eclipse.jdt.core.dom.MethodSpec;
import org.eclipse.jdt.core.dom.ParameterMapping;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTNodeCreator;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.objectteams.otdt.internal.ui.bindingeditor.BindingEditor;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CalloutMappingConfiguration
extends Group {
    private CalloutMappingDeclaration _callout;
    private ListViewer _paraListViewer;
    private TextViewer _paraTextViewer;
    private ListViewer _resListViewer;
    private TextViewer _resTextViewer;
    private BindingEditor _bindingEditor;
    private Label _methBindLabel;
    private final Object[] EMPTY = new Object[0];
    private static final String EMPTY_TEXT = "";

    public CalloutMappingConfiguration(Composite parent, int style) {
        super(parent, style);
        this._bindingEditor = (BindingEditor)parent.getParent();
        this.setText(OTDTUIPlugin.getResourceString("CalloutMappingConfiguration_dialog_title"));
        this.setLayout((Layout)new FormLayout());
        this._methBindLabel = new Label((Composite)this, 0);
        FormData formData = new FormData();
        formData.right = new FormAttachment(100, -5);
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 10);
        this._methBindLabel.setLayoutData((Object)formData);
        this._methBindLabel.setText(OTDTUIPlugin.getResourceString("MethodMappingConfiguration_no_method_binding_selected"));
        Group paraMapGrp = new Group((Composite)this, 0);
        paraMapGrp.setText(OTDTUIPlugin.getResourceString("MethodMappingConfiguration_param_mapping_group_title"));
        FormData formData_1 = new FormData();
        formData_1.bottom = new FormAttachment(50, 0);
        formData_1.right = new FormAttachment(100, -5);
        formData_1.top = new FormAttachment(0, 28);
        formData_1.left = new FormAttachment(0, 5);
        paraMapGrp.setLayoutData((Object)formData_1);
        paraMapGrp.setLayout((Layout)new FormLayout());
        this._paraTextViewer = new TextViewer((Composite)paraMapGrp, 2048);
        this._paraTextViewer.setDocument((IDocument)new Document());
        StyledText paraText = this._paraTextViewer.getTextWidget();
        FormData formData_5 = new FormData();
        formData_5.right = new FormAttachment(43, 0);
        formData_5.bottom = new FormAttachment(100, -5);
        formData_5.top = new FormAttachment(0, 5);
        formData_5.left = new FormAttachment(0, 5);
        paraText.setLayoutData((Object)formData_5);
        this._paraTextViewer.setInput(new Object());
        this._paraListViewer = new ListViewer((Composite)paraMapGrp, 2048);
        this._paraListViewer.setContentProvider((IContentProvider)new BaseMethodParameterContentProvider());
        org.eclipse.swt.widgets.List paraList = this._paraListViewer.getList();
        FormData formData_7 = new FormData();
        formData_7.bottom = new FormAttachment(100, -5);
        formData_7.right = new FormAttachment(100, -5);
        formData_7.top = new FormAttachment(0, 5);
        formData_7.left = new FormAttachment(59, 0);
        paraList.setLayoutData((Object)formData_7);
        this._paraListViewer.setInput(new Object());
        this._paraListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!CalloutMappingConfiguration.this._paraListViewer.getSelection().isEmpty()) {
                    CalloutMappingConfiguration.this._resListViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
        });
        Composite paraBtnComp = new Composite((Composite)paraMapGrp, 0);
        FormData formData_6 = new FormData();
        formData_6.right = new FormAttachment((Control)paraList, -5, 16384);
        formData_6.bottom = new FormAttachment(100, -5);
        formData_6.top = new FormAttachment((Control)paraText, 0, 128);
        formData_6.left = new FormAttachment((Control)paraText, 5, 131072);
        paraBtnComp.setLayoutData((Object)formData_6);
        paraBtnComp.setLayout((Layout)new FormLayout());
        Button paraMapBtn = new Button(paraBtnComp, 0);
        FormData formData_2 = new FormData();
        formData_2.right = new FormAttachment(100, -5);
        formData_2.top = new FormAttachment(34, 0);
        formData_2.left = new FormAttachment(0, 5);
        paraMapBtn.setLayoutData((Object)formData_2);
        paraMapBtn.setText("->");
        Button applyBtn = new Button((Composite)this, 0);
        FormData formData_11 = new FormData();
        formData_11.bottom = new FormAttachment(100, -5);
        formData_11.right = new FormAttachment(100, -5);
        applyBtn.setLayoutData((Object)formData_11);
        applyBtn.setText(OTDTUIPlugin.getResourceString("MethodMappingConfiguration_apply_button_label"));
        applyBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CalloutMappingConfiguration.this.applySelectedMapping();
            }
        });
        Group resMapGrp = new Group((Composite)this, 0);
        resMapGrp.setText(OTDTUIPlugin.getResourceString("MethodMappingConfiguration_result_mapping_group_title"));
        FormData formData_4 = new FormData();
        formData_4.bottom = new FormAttachment((Control)applyBtn, -5, 128);
        formData_4.right = new FormAttachment(100, -5);
        formData_4.top = new FormAttachment((Control)paraMapGrp, 5, 1024);
        formData_4.left = new FormAttachment(0, 5);
        resMapGrp.setLayoutData((Object)formData_4);
        resMapGrp.setLayout((Layout)new FormLayout());
        this._resListViewer = new ListViewer((Composite)resMapGrp, 2048);
        this._resListViewer.setContentProvider((IContentProvider)new ResultContentProvider());
        org.eclipse.swt.widgets.List resList = this._resListViewer.getList();
        FormData formData_8 = new FormData();
        formData_8.bottom = new FormAttachment(100, -5);
        formData_8.right = new FormAttachment(43, 0);
        formData_8.top = new FormAttachment(0, 5);
        formData_8.left = new FormAttachment(0, 5);
        resList.setLayoutData((Object)formData_8);
        this._resListViewer.setInput(new Object());
        this._resListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!CalloutMappingConfiguration.this._resListViewer.getSelection().isEmpty()) {
                    CalloutMappingConfiguration.this._paraListViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
        });
        this._resTextViewer = new TextViewer((Composite)resMapGrp, 2048);
        StyledText resText = this._resTextViewer.getTextWidget();
        FormData formData_10 = new FormData();
        formData_10.bottom = new FormAttachment(100, -5);
        formData_10.right = new FormAttachment(100, -5);
        formData_10.top = new FormAttachment(0, 5);
        formData_10.left = new FormAttachment(59, 0);
        resText.setLayoutData((Object)formData_10);
        this._resTextViewer.setInput(new Object());
        Composite resBtnComp = new Composite((Composite)resMapGrp, 0);
        FormData formData_3 = new FormData();
        formData_3.right = new FormAttachment((Control)resText, -5, 16384);
        formData_3.bottom = new FormAttachment(100, -5);
        formData_3.top = new FormAttachment((Control)resText, 0, 128);
        formData_3.left = new FormAttachment((Control)resList, 5, 131072);
        resBtnComp.setLayoutData((Object)formData_3);
        resBtnComp.setLayout((Layout)new FormLayout());
        Button resMapBtn = new Button(resBtnComp, 0);
        FormData formData_9 = new FormData();
        formData_9.right = new FormAttachment(100, -5);
        formData_9.top = new FormAttachment(0, 5);
        formData_9.left = new FormAttachment(0, 5);
        resMapBtn.setLayoutData((Object)formData_9);
        resMapBtn.setText("<-");
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    private void applySelectedMapping() {
        IStructuredSelection selection = null;
        String identifier = null;
        String expr = null;
        selection = (IStructuredSelection)this._paraListViewer.getSelection();
        if (!selection.isEmpty()) {
            identifier = (String)selection.getFirstElement();
            expr = this._paraTextViewer.getDocument().get();
            if (!expr.equals(EMPTY_TEXT)) {
                this.updateParameterMapping(identifier, expr);
            }
        }
        if (!(selection = (IStructuredSelection)this._resListViewer.getSelection()).isEmpty()) {
            identifier = (String)selection.getFirstElement();
            expr = this._resTextViewer.getDocument().get();
            if (!expr.equals(EMPTY_TEXT)) {
                this.updateParameterMapping(identifier, expr);
            }
        }
        this._bindingEditor.refresh();
    }

    protected void setFocus(ParameterMapping paraMap, CalloutMappingDeclaration callout) {
        this.setMethodBinding(callout);
        this.setParameterMapping(paraMap);
    }

    protected void setParameterMapping(ParameterMapping paraMap) {
        if (paraMap == null) {
            this._resTextViewer.setDocument((IDocument)new Document(EMPTY_TEXT));
            this._paraTextViewer.setDocument((IDocument)new Document(EMPTY_TEXT));
            this.clearSelections();
            return;
        }
        String identifier = paraMap.getIdentifier().getIdentifier();
        ASTNode expr = paraMap.getExpression();
        if (paraMap.hasResultFlag()) {
            this._paraListViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            this._resListViewer.setSelection((ISelection)new StructuredSelection((Object)identifier));
            this._resTextViewer.setDocument((IDocument)new Document(expr.toString()));
        } else {
            this._resListViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            this._paraListViewer.setSelection((ISelection)new StructuredSelection((Object)identifier));
            this._paraTextViewer.setDocument((IDocument)new Document(expr.toString()));
        }
    }

    protected void setMethodBinding(CalloutMappingDeclaration callout) {
        this._callout = callout;
        this._methBindLabel.setText(String.valueOf(this._callout.getRoleMappingElement().toString()) + (this._callout.isCalloutOverride() ? "=>" : "->") + this._callout.getBaseMappingElement().toString());
        this._paraListViewer.refresh();
    }

    protected void updateParameterMapping(String identifier, String expr) {
        ParameterMapping paraMap = null;
        Expression exprNode = ASTNodeCreator.createExpression((AST)this._callout.getAST(), (String)expr);
        if (exprNode == null) {
            return;
        }
        List paraMaps = this._callout.getParameterMappings();
        for (ParameterMapping mapping : paraMaps) {
            if (!identifier.equals(mapping.getIdentifier())) continue;
            paraMap = mapping;
            break;
        }
        if (paraMap == null) {
            paraMap = this._callout.getAST().newParameterMapping();
            paraMaps.add(paraMap);
        }
        paraMap.setIdentifier(this._callout.getAST().newSimpleName(identifier));
        if (identifier.equals("result")) {
            paraMap.setDirection("<-");
            paraMap.setResultFlag(true);
        } else {
            paraMap.setDirection("->");
            paraMap.setResultFlag(false);
        }
        paraMap.setExpression(exprNode);
    }

    public void clearSelections() {
        this._resListViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this._paraListViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this._resTextViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this._paraTextViewer.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    class BaseMethodParameterContentProvider
    implements IStructuredContentProvider {
        BaseMethodParameterContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (CalloutMappingConfiguration.this._callout == null) {
                return CalloutMappingConfiguration.this.EMPTY;
            }
            ArrayList<String> result = new ArrayList<String>();
            MethodMappingElement baseElement = CalloutMappingConfiguration.this._callout.getBaseMappingElement();
            if (baseElement instanceof FieldAccessSpec) {
                result.add(baseElement.getName().toString());
            } else if (baseElement instanceof MethodSpec) {
                MethodSpec methSpec = (MethodSpec)baseElement;
                for (SingleVariableDeclaration param : methSpec.parameters()) {
                    result.add(param.getName().toString());
                }
            }
            return result.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ResultContentProvider
    implements IStructuredContentProvider {
        ResultContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return new Object[]{"result"};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

