/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otre.bcel;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.JavaClass;
import org.eclipse.objectteams.otre.bcel.ConstantPool;
import org.eclipse.objectteams.otre.bcel.DietJavaClass;

public final class DietClassParser {
    private DataInputStream file;
    private String file_name;
    private int class_name_index;
    private int superclass_name_index;
    private int access_flags;
    private boolean is_zip;
    private static final int BUFSIZE = 8192;

    public DietClassParser(InputStream file, String file_name) {
        this.file_name = file_name;
        String clazz = file.getClass().getName();
        this.is_zip = clazz.startsWith("java.util.zip.") || clazz.startsWith("java.util.jar.");
        this.file = file instanceof DataInputStream ? (DataInputStream)file : new DataInputStream(new BufferedInputStream(file, 8192));
    }

    public JavaClass parse() throws IOException, ClassFormatException {
        if (this.file.readInt() != -889275714) {
            throw new ClassFormatException(this.file_name + " is not a Java .class file");
        }
        int minor = this.file.readUnsignedShort();
        int major = this.file.readUnsignedShort();
        ConstantPool constant_pool = new ConstantPool(this.file);
        this.readClassInfo();
        int[] interfaces = this.readInterfaces();
        return new DietJavaClass(this.class_name_index, this.superclass_name_index, this.file_name, major, minor, this.access_flags, constant_pool, interfaces, this.is_zip ? (byte)3 : 2);
    }

    private final void readClassInfo() throws IOException {
        this.access_flags = this.file.readUnsignedShort();
        if ((this.access_flags & 0x200) != 0) {
            this.access_flags |= 0x400;
        }
        this.class_name_index = this.file.readUnsignedShort();
        this.superclass_name_index = this.file.readUnsignedShort();
    }

    private int[] readInterfaces() throws IOException {
        int interfaces_count = this.file.readUnsignedShort();
        int[] interfaces = new int[interfaces_count];
        int i = 0;
        while (i < interfaces_count) {
            interfaces[i] = this.file.readUnsignedShort();
            ++i;
        }
        return interfaces;
    }
}

