/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.oomph.internal.setup.SetupPrompter;
import org.eclipse.oomph.internal.setup.SetupProperties;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupCorePlugin;
import org.eclipse.oomph.setup.util.OS;
import org.eclipse.oomph.setup.util.StringExpander;
import org.eclipse.oomph.util.OfflineMode;
import org.eclipse.oomph.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSetupTaskContext
extends StringExpander
implements SetupTaskContext,
SetupProperties {
    private static final Map<String, StringFilter> STRING_FILTER_REGISTRY = new HashMap<String, StringFilter>();
    private SetupPrompter prompter;
    private Trigger trigger;
    private SetupContext setupContext;
    private boolean performing;
    private boolean mirrors;
    private Set<String> restartReasons = new LinkedHashSet<String>();
    private URIConverter uriConverter;
    private Map<Object, Object> map = new LinkedHashMap<Object, Object>();

    static {
        AbstractSetupTaskContext.registerFilter("uri", new StringFilter(){

            public String filter(String value) {
                return URI.createFileURI((String)value).toString();
            }
        });
        AbstractSetupTaskContext.registerFilter("uriLastSegment", new StringFilter(){

            public String filter(String value) {
                URI uri = URI.createURI((String)value);
                if (!uri.isHierarchical()) {
                    uri = URI.createURI((String)uri.opaquePart());
                }
                return URI.decode((String)uri.lastSegment());
            }
        });
        AbstractSetupTaskContext.registerFilter("gitRepository", new StringFilter(){

            public String filter(String value) {
                String result;
                URI uri = URI.createURI((String)value);
                if (!uri.isHierarchical()) {
                    uri = URI.createURI((String)uri.opaquePart());
                }
                if ((result = URI.decode((String)uri.lastSegment())).endsWith(".git")) {
                    result = result.substring(0, result.length() - 4);
                }
                return result;
            }
        });
        AbstractSetupTaskContext.registerFilter("preferenceNode", new StringFilter(){

            public String filter(String value) {
                return value.replaceAll("/", "\\\\2f");
            }
        });
        AbstractSetupTaskContext.registerFilter("upper", new StringFilter(){

            public String filter(String value) {
                return value.toUpperCase();
            }
        });
        AbstractSetupTaskContext.registerFilter("lower", new StringFilter(){

            public String filter(String value) {
                return value.toLowerCase();
            }
        });
        AbstractSetupTaskContext.registerFilter("cap", new StringFilter(){

            public String filter(String value) {
                return StringUtil.cap((String)value);
            }
        });
        AbstractSetupTaskContext.registerFilter("allCap", new StringFilter(){

            public String filter(String value) {
                return StringUtil.capAll((String)value);
            }
        });
        AbstractSetupTaskContext.registerFilter("property", new StringFilter(){

            public String filter(String value) {
                return value.replaceAll("\\\\", "\\\\\\\\");
            }
        });
        AbstractSetupTaskContext.registerFilter("path", new StringFilter(){

            public String filter(String value) {
                return value.replaceAll("\\\\", "/");
            }
        });
        AbstractSetupTaskContext.registerFilter("basePath", new StringFilter(){

            public String filter(String value) {
                int pos = (value = value.replaceAll("\\\\", "/")).lastIndexOf(47);
                if (pos == -1) {
                    return "";
                }
                return value.substring(0, pos);
            }
        });
        AbstractSetupTaskContext.registerFilter("lastSegment", new StringFilter(){

            public String filter(String value) {
                int pos = Math.max(value.lastIndexOf(47), value.lastIndexOf(92));
                if (pos == -1) {
                    return value;
                }
                return value.substring(pos + 1);
            }
        });
    }

    protected AbstractSetupTaskContext(URIConverter uriConverter, SetupPrompter prompter, Trigger trigger, SetupContext setupContext) {
        this.uriConverter = uriConverter;
        this.prompter = prompter;
        this.trigger = trigger;
        this.initialize(setupContext);
    }

    private void initialize(SetupContext setupContext) {
        this.setSetupContext(setupContext);
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        this.put("oomph.update.url", SetupCorePlugin.UPDATE_URL);
    }

    public Map<Object, Object> getMap() {
        return this.map;
    }

    public SetupPrompter getPrompter() {
        return this.prompter;
    }

    public void setPrompter(SetupPrompter prompter) {
        this.prompter = prompter;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public void checkCancelation() {
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public boolean isOffline() {
        return OfflineMode.isEnabled();
    }

    public void setOffline(boolean offline) {
        OfflineMode.setEnabled((boolean)offline);
    }

    public boolean isMirrors() {
        return this.mirrors;
    }

    public void setMirrors(boolean mirrors) {
        this.mirrors = mirrors;
    }

    public boolean isPerforming() {
        return this.performing;
    }

    public boolean isRestartNeeded() {
        return !this.restartReasons.isEmpty();
    }

    public void setRestartNeeded(String reason) {
        this.restartReasons.add(reason);
    }

    public Set<String> getRestartReasons() {
        return this.restartReasons;
    }

    public URI redirect(URI uri) {
        if (uri == null) {
            return null;
        }
        return this.getURIConverter().normalize(uri);
    }

    public String redirect(String uri) {
        if (StringUtil.isEmpty((String)uri)) {
            return null;
        }
        return this.redirect(URI.createURI((String)uri)).toString();
    }

    public URIConverter getURIConverter() {
        return this.uriConverter;
    }

    public OS getOS() {
        return OS.INSTANCE;
    }

    public File getProductLocation() {
        File installationLocation = this.getInstallationLocation();
        if (installationLocation == null) {
            return null;
        }
        String lastSegment = this.getTrigger() == Trigger.BOOTSTRAP ? this.getOS().getEclipseDir() : SetupContext.PRODUCT_LOCATION.lastSegment();
        return new File(installationLocation, lastSegment);
    }

    public File getProductConfigurationLocation() {
        File productLocation = this.getProductLocation();
        if (productLocation == null) {
            return null;
        }
        return new File(productLocation, "configuration");
    }

    public Workspace getWorkspace() {
        return this.setupContext.getWorkspace();
    }

    public SetupContext getSetupContext() {
        return this.setupContext;
    }

    protected final void setSetupContext(SetupContext setupContext) {
        this.setupContext = setupContext;
    }

    public User getUser() {
        return this.setupContext.getUser();
    }

    public Installation getInstallation() {
        return this.setupContext.getInstallation();
    }

    protected final void setPerforming(boolean performing) {
        this.performing = performing;
    }

    public Object get(Object key) {
        String name;
        Object value = this.map.get(key);
        if (value == null && key instanceof String && (name = (String)key).indexOf(46) != -1) {
            name = name.replace('.', '_');
            value = this.map.get(name);
        }
        return value;
    }

    public Object put(Object key, Object value) {
        return this.map.put(key, value);
    }

    public Set<Object> keySet() {
        return this.map.keySet();
    }

    protected String lookup(String key) {
        Object object = this.get(key);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    protected String filter(String value, String filterName) {
        StringFilter filter = STRING_FILTER_REGISTRY.get(filterName.toLowerCase());
        if (filter != null) {
            return filter.filter(value);
        }
        return value;
    }

    private static void registerFilter(String filterName, StringFilter filter) {
        STRING_FILTER_REGISTRY.put(filterName.toLowerCase(), filter);
    }

    public static interface StringFilter {
        public String filter(String var1);
    }
}

