/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySheetEntry;

public class OomphPropertySheetPage
extends ExtendedPropertySheetPage {
    private CopyValuePropertyAction copyPropertyValueAction;
    private Clipboard clipboard;

    public OomphPropertySheetPage(AdapterFactoryEditingDomain editingDomain, ExtendedPropertySheetPage.Decoration decoration, IDialogSettings dialogSettings) {
        super(editingDomain, decoration, dialogSettings);
    }

    public void setRootEntry(IPropertySheetEntry entry) {
        Shell shell = this.getControl().getShell();
        this.clipboard = new Clipboard(shell.getDisplay());
        this.copyPropertyValueAction = new CopyValuePropertyAction(this.clipboard);
        super.setRootEntry(entry);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Menu menu = this.getControl().getMenu();
        IMenuManager menuManager = (IMenuManager)menu.getData("org.eclipse.jface.action.MenuManager.managerKey");
        menuManager.insertAfter("copy", (IAction)this.copyPropertyValueAction);
    }

    public void handleEntrySelection(ISelection selection) {
        super.handleEntrySelection(selection);
        this.copyPropertyValueAction.selectionChanged((IStructuredSelection)selection);
    }

    public void dispose() {
        super.dispose();
        this.clipboard.dispose();
    }

    private static class CopyValuePropertyAction
    extends Action {
        private Clipboard clipboard;
        private IStructuredSelection selection;

        public CopyValuePropertyAction(Clipboard clipboard) {
            super("Copy &Value");
            this.clipboard = clipboard;
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        }

        public void run() {
            if (this.selection != null && !this.selection.isEmpty()) {
                IPropertySheetEntry entry = (IPropertySheetEntry)this.selection.getFirstElement();
                this.setClipboard(entry.getValueAsString());
            }
        }

        public void selectionChanged(IStructuredSelection selection) {
            this.selection = selection;
            this.setEnabled(!selection.isEmpty());
        }

        private void setClipboard(String text) {
            try {
                Object[] data = new Object[]{text};
                Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
                this.clipboard.setContents(data, transferTypes);
            }
            catch (SWTError ex) {
                UIPlugin.INSTANCE.log(ex);
            }
        }
    }
}

