/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class DiagnosticComposite
extends Composite {
    public static int ERROR_WARNING_MASK = 6;
    protected Diagnostic diagnostic;
    protected TextProvider textProvider;
    protected boolean showRootDiagnostic = false;
    protected TreeViewer diagnosticTreeViewer;
    protected Text detailText;
    protected int severityMask = 0;

    public static boolean severityMatches(Diagnostic diagnostic, int mask) {
        return (diagnostic.getSeverity() & mask) != 0;
    }

    public DiagnosticComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        int spacing = 3;
        layout.marginTop = -5;
        layout.marginBottom = -5;
        layout.marginLeft = -5;
        layout.marginRight = -5;
        layout.horizontalSpacing = spacing;
        layout.verticalSpacing = spacing;
        this.setLayout((Layout)layout);
    }

    public void dispose() {
        this.diagnostic = null;
        this.diagnosticTreeViewer = null;
        this.detailText = null;
        super.dispose();
    }

    public void initialize(Diagnostic diagnostic) {
        if (!this.isInitialized()) {
            this.setDiagnostic(diagnostic);
            this.createControls(this);
        }
    }

    public boolean isInitialized() {
        return this.diagnosticTreeViewer != null && this.detailText != null;
    }

    public void setDiagnostic(Diagnostic diagnostic) {
        this.diagnostic = diagnostic;
        if (this.isInitialized()) {
            this.detailText.setText("");
            if (this.getDiagnostic() != null) {
                this.diagnosticTreeViewer.setInput((Object)this.getDiagnostic());
            } else {
                this.diagnosticTreeViewer.getTree().removeAll();
            }
        }
    }

    public Diagnostic getDiagnostic() {
        return this.diagnostic;
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
        if (this.detailText != null) {
            String detail = this.getTextProvider().getDetail(this.getSelection());
            this.setDetailText(detail);
        }
    }

    public TextProvider getTextProvider() {
        if (this.textProvider == null) {
            this.textProvider = new TextProvider();
        }
        return this.textProvider;
    }

    public void setShowRootDiagnostic(boolean showRootDiagnostic) {
        this.showRootDiagnostic = showRootDiagnostic;
    }

    public boolean isShowRootDiagnostic() {
        return this.showRootDiagnostic;
    }

    public void setSeverityMask(int severityMask) {
        this.severityMask = severityMask;
    }

    public int getSeverityMask() {
        return this.severityMask;
    }

    protected void createControls(Composite parent) {
        SashForm sashForm = new SashForm(parent, 512);
        sashForm.setLayoutData((Object)new GridData(1808));
        this.diagnosticTreeViewer = new TreeViewer((Composite)sashForm, 2048);
        this.diagnosticTreeViewer.getTree().setLayoutData((Object)new GridData(1810));
        this.detailText = new Text((Composite)sashForm, 2826);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 20;
        gridData.grabExcessVerticalSpace = true;
        this.detailText.setLayoutData((Object)gridData);
        this.detailText.setBackground(this.detailText.getDisplay().getSystemColor(25));
        sashForm.setWeights(new int[]{70, 30});
        sashForm.setMaximizedControl((Control)this.diagnosticTreeViewer.getTree());
        this.diagnosticTreeViewer.setContentProvider((IContentProvider)this.createContentProvider());
        this.diagnosticTreeViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.diagnosticTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    Diagnostic diagnostic = (Diagnostic)((IStructuredSelection)event.getSelection()).getFirstElement();
                    DiagnosticComposite.this.diagnosticSelected(diagnostic);
                } else {
                    DiagnosticComposite.this.detailText.setText("");
                }
            }
        });
        if (this.getDiagnostic() != null) {
            this.diagnosticTreeViewer.setInput((Object)this.getDiagnostic());
        }
        this.diagnosticTreeViewer.expandToLevel(2);
    }

    public void setDetailText(String text) {
        if (text == null) {
            text = "";
        }
        if (this.detailText != null && !text.equals(this.detailText.getText())) {
            this.detailText.setText(text);
        }
    }

    public String getDetailText() {
        return this.detailText == null ? "" : this.detailText.getText();
    }

    public Diagnostic getSelection() {
        return this.diagnosticTreeViewer == null ? null : (Diagnostic)((IStructuredSelection)this.diagnosticTreeViewer.getSelection()).getFirstElement();
    }

    protected void diagnosticSelected(Diagnostic selection) {
        String detail = this.getTextProvider().getDetail(selection).trim();
        SashForm sashForm = (SashForm)this.detailText.getParent();
        this.setDetailText(detail);
        if (detail.length() == 0) {
            sashForm.setMaximizedControl((Control)this.diagnosticTreeViewer.getTree());
        } else {
            sashForm.setMaximizedControl(null);
            if (this.diagnosticTreeViewer != null) {
                this.diagnosticTreeViewer.getTree().showSelection();
            }
        }
    }

    protected ITreeContentProvider createContentProvider() {
        return new ITreeContentProvider(){
            private boolean isRootElement;
            private Map<Diagnostic, Diagnostic[]> parentToChildrenMap;
            {
                this.isRootElement = DiagnosticComposite.this.isShowRootDiagnostic();
                this.parentToChildrenMap = new HashMap<Diagnostic, Diagnostic[]>();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.parentToChildrenMap.clear();
            }

            public void dispose() {
                this.parentToChildrenMap.clear();
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (this.isRootElement) {
                    this.isRootElement = false;
                    Diagnostic diagnostic = (Diagnostic)inputElement;
                    if (DiagnosticComposite.severityMatches(diagnostic, DiagnosticComposite.this.severityMask)) {
                        if (diagnostic.getMessage() != null || diagnostic.getException() != null) {
                            return new Object[]{diagnostic};
                        }
                    } else {
                        return new Object[0];
                    }
                }
                return this.getChildren(inputElement);
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object[] getChildren(Object parentElement) {
                Object[] children = this.parentToChildrenMap.get(parentElement);
                if (children == null) {
                    Diagnostic diagnostic = (Diagnostic)parentElement;
                    ArrayList<Diagnostic> childList = new ArrayList<Diagnostic>(diagnostic.getChildren().size());
                    for (Diagnostic child : diagnostic.getChildren()) {
                        if (!DiagnosticComposite.severityMatches(child, DiagnosticComposite.this.severityMask)) continue;
                        childList.add(child);
                    }
                    children = childList.toArray(new Diagnostic[childList.size()]);
                    this.parentToChildrenMap.put(diagnostic, (Diagnostic[])children);
                }
                return children;
            }
        };
    }

    protected ILabelProvider createLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                Diagnostic diagnostic = (Diagnostic)element;
                String message = diagnostic.getMessage();
                if (message == null) {
                    switch (diagnostic.getSeverity()) {
                        case 4: {
                            message = CommonUIPlugin.getPlugin().getString("_UI_DiagnosticError_label");
                            break;
                        }
                        case 2: {
                            message = CommonUIPlugin.getPlugin().getString("_UI_DiagnosticWarning_label");
                            break;
                        }
                        default: {
                            message = CommonUIPlugin.getPlugin().getString("_UI_Diagnostic_label");
                        }
                    }
                }
                return message;
            }

            public Image getImage(Object element) {
                Diagnostic diagnostic = (Diagnostic)element;
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                switch (diagnostic.getSeverity()) {
                    case 4: {
                        return sharedImages.getImage("IMG_OBJS_ERROR_TSK");
                    }
                    case 2: 
                    case 8: {
                        return sharedImages.getImage("IMG_OBJS_WARN_TSK");
                    }
                    case 0: 
                    case 1: {
                        return sharedImages.getImage("IMG_OBJS_INFO_TSK");
                    }
                }
                return null;
            }
        };
    }

    public static class TextProvider {
        public String getDetail(Diagnostic diagnostic) {
            Throwable throwable = diagnostic.getException();
            if (throwable != null) {
                StringWriter in = new StringWriter();
                PrintWriter ps = new PrintWriter(in);
                throwable.printStackTrace(ps);
                return in.getBuffer().toString();
            }
            for (Object datum : diagnostic.getData()) {
                if (!(datum instanceof StringBuilder)) continue;
                return datum.toString();
            }
            return "";
        }
    }
}

