/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.TextModification;
import org.eclipse.oomph.setup.TextModifyTask;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.util.DownloadUtil;
import org.eclipse.oomph.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextModifyTaskImpl
extends SetupTaskImpl
implements TextModifyTask {
    protected static final String URL_EDEFAULT = null;
    protected String uRL = URL_EDEFAULT;
    protected EList<TextModification> modifications;
    protected static final String ENCODING_EDEFAULT = null;
    protected String encoding = ENCODING_EDEFAULT;

    protected TextModifyTaskImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return SetupPackage.Literals.TEXT_MODIFY_TASK;
    }

    @Override
    public String getURL() {
        return this.uRL;
    }

    @Override
    public void setURL(String newURL) {
        String oldURL = this.uRL;
        this.uRL = newURL;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldURL, (Object)this.uRL));
        }
    }

    @Override
    public EList<TextModification> getModifications() {
        if (this.modifications == null) {
            this.modifications = new EObjectContainmentEList.Resolving(TextModification.class, (InternalEObject)this, 10);
        }
        return this.modifications;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String newEncoding) {
        String oldEncoding = this.encoding;
        this.encoding = newEncoding;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldEncoding, (Object)this.encoding));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 10: {
                return ((InternalEList)this.getModifications()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                return this.getURL();
            }
            case 10: {
                return this.getModifications();
            }
            case 11: {
                return this.getEncoding();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.setURL((String)newValue);
                return;
            }
            case 10: {
                this.getModifications().clear();
                this.getModifications().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.setEncoding((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.setURL(URL_EDEFAULT);
                return;
            }
            case 10: {
                this.getModifications().clear();
                return;
            }
            case 11: {
                this.setEncoding(ENCODING_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return URL_EDEFAULT == null ? this.uRL != null : !URL_EDEFAULT.equals(this.uRL);
            }
            case 10: {
                return this.modifications != null && !this.modifications.isEmpty();
            }
            case 11: {
                return ENCODING_EDEFAULT == null ? this.encoding != null : !ENCODING_EDEFAULT.equals(this.encoding);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (uRL: ");
        result.append(this.uRL);
        result.append(", encoding: ");
        result.append(this.encoding);
        result.append(')');
        return result.toString();
    }

    private String getText(SetupTaskContext context) throws IOException {
        return DownloadUtil.load(context.getURIConverter(), URI.createURI((String)this.getURL()), this.encoding);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isNeeded(SetupTaskContext context) throws Exception {
        try {
            TextModification modification;
            Pattern pattern;
            Matcher matcher;
            String text = this.getText(context);
            Iterator iterator = this.getModifications().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(matcher = (pattern = Pattern.compile((modification = (TextModification)iterator.next()).getPattern())).matcher(text)).find());
            return true;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    @Override
    public void perform(SetupTaskContext context) throws Exception {
        URI uri = this.createResolvedURI(this.getURL());
        URIConverter uriConverter = context.getURIConverter();
        context.log("Modifying " + uriConverter.normalize(uri));
        String text = this.getText(context);
        for (TextModification modification : this.getModifications()) {
            int index = 0;
            StringBuilder result = new StringBuilder();
            Pattern pattern = Pattern.compile(modification.getPattern());
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                int n = index;
                index = matcher.start();
                result.append(text, n, index);
                HashMap<String, String> captures = new HashMap<String, String>();
                int i = 1;
                int count = matcher.groupCount();
                while (i <= count) {
                    captures.put("\\" + i, matcher.group(i));
                    ++i;
                }
                i = 1;
                count = matcher.groupCount();
                while (i <= count) {
                    result.append(text, index, matcher.start(i));
                    String substitution = (String)modification.getSubstitutions().get(i - 1);
                    for (Map.Entry entry : captures.entrySet()) {
                        substitution = substitution.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                    }
                    result.append(substitution);
                    index = matcher.end(i);
                    ++i;
                }
                int n2 = index;
                index = matcher.end();
                result.append(text, n2, index);
            }
            result.append(text, index, text.length());
            text = result.toString();
        }
        PrintStream printStream = null;
        try {
            OutputStream outputStream = uriConverter.createOutputStream(uri);
            printStream = this.encoding == null ? new PrintStream(outputStream) : new PrintStream(outputStream, false, this.encoding);
            printStream.print(text);
        }
        catch (Throwable throwable) {
            IOUtil.close(printStream);
            throw throwable;
        }
        IOUtil.close((Closeable)printStream);
    }
}

