/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;

public final class P2Indexer
implements IApplication {
    private static final String CHARSET = "UTF-8";
    private final Map<URI, Repository> repositories = new ConcurrentHashMap<URI, Repository>();
    private final Map<String, List<Capability>> capabilities = new HashMap<String, List<Capability>>();
    private final Map<String, Set<String>> capabilityIndex = new HashMap<String, Set<String>>();
    private final Deque<Future<?>> deque = new ConcurrentLinkedDeque();
    private final long timeStamp = System.currentTimeMillis();
    private int refreshHours = 24;
    private int maxRepos = Integer.MAX_VALUE;
    private boolean verbose;

    public Object start(IApplicationContext context) throws Exception {
        long start = System.currentTimeMillis();
        String[] args = (String[])context.getArguments().get("application.args");
        LinkedList<String> arguments = new LinkedList<String>(Arrays.asList(args));
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 4);
        try {
            File scanFolder = new File(arguments.removeFirst()).getCanonicalFile();
            this.refreshHours = Integer.parseInt(arguments.removeFirst());
            URI baseURI = URI.createURI((String)arguments.removeFirst());
            File outputFolder = new File(arguments.removeFirst()).getCanonicalFile();
            while (!arguments.isEmpty()) {
                String arg = arguments.removeFirst();
                if ("-maxrepos".equals(arg) || "-m".equals(arg)) {
                    this.maxRepos = Integer.parseInt(arguments.removeFirst());
                    continue;
                }
                if (!"-verbose".equals(arg) && !"-v".equals(arg)) continue;
                this.verbose = true;
            }
            this.scanFolder(executor, scanFolder, baseURI);
            Future<?> future = this.deque.pollFirst();
            while (future != null) {
                future.get();
                future = this.deque.pollFirst();
            }
            this.generateRepositoryMetadata(executor);
            future = this.deque.pollFirst();
            while (future != null) {
                future.get();
                future = this.deque.pollFirst();
            }
            this.generateIndex(outputFolder);
        }
        finally {
            System.out.println("Took " + (System.currentTimeMillis() - start) / 1000L + " seconds.");
            executor.shutdown();
        }
        return null;
    }

    public void stop() {
    }

    private void scanFolder(final ExecutorService executor, final File folder, final URI uri) {
        if (this.repositories.size() >= this.maxRepos) {
            return;
        }
        this.deque.addLast(executor.submit(new Runnable(){

            public void run() {
                File metadataFile = P2Indexer.this.getMetadataFile(folder);
                if (metadataFile != null) {
                    if (P2Indexer.this.verbose) {
                        System.out.println("Found " + metadataFile);
                    }
                    if (metadataFile.getName().startsWith("composite")) {
                        P2Indexer.this.repositories.put(uri, new Repository.Composite(uri, metadataFile));
                    } else {
                        P2Indexer.this.repositories.put(uri, new Repository.Simple(uri, metadataFile));
                    }
                }
            }
        }));
        Object[] children = folder.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return P2Indexer.isValidFolder(file);
            }
        });
        if (children != null) {
            Arrays.sort(children);
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String encodedName;
                Object child = objectArray[n2];
                String name = ((File)child).getName();
                if (name.equals(URI.decode((String)(encodedName = URI.encodeSegment((String)name, (boolean)false))))) {
                    this.deque.addLast(executor.submit(new Runnable((File)child, uri, encodedName){
                        private final /* synthetic */ File val$child;
                        private final /* synthetic */ URI val$uri;
                        private final /* synthetic */ String val$encodedName;
                        {
                            this.val$child = file;
                            this.val$uri = uRI;
                            this.val$encodedName = string;
                        }

                        public void run() {
                            P2Indexer.this.scanFolder(executor, this.val$child, this.val$uri.appendSegment(this.val$encodedName));
                        }
                    }));
                } else {
                    System.err.println("Can't encode " + child);
                }
                ++n2;
            }
        }
    }

    private File getMetadataFile(File folder) {
        File file;
        Map properties;
        String factoryOrder;
        File p2IndexFile = new File(folder, "p2.index");
        if (p2IndexFile.canRead() && (factoryOrder = (String)(properties = PropertiesUtil.loadProperties((File)p2IndexFile)).get("metadata.repository.factory.order")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(factoryOrder, ",");
            while (tokenizer.hasMoreTokens()) {
                File file2;
                String factory = tokenizer.nextToken();
                if ("!".equals(factory)) break;
                if ("content.xml".equals(factory)) {
                    file2 = new File(folder, "content.jar");
                    if (file2.isFile()) {
                        return file2;
                    }
                    file2 = new File(folder, "content.xml");
                    if (file2.isFile()) {
                        return file2;
                    }
                }
                if (!"compositeContent.xml".equals(factory)) continue;
                file2 = new File(folder, "compositeContent.jar");
                if (file2.isFile()) {
                    return file2;
                }
                file2 = new File(folder, "compositeContent.xml");
                if (!file2.isFile()) continue;
                return file2;
            }
        }
        if ((file = new File(folder, "content.jar")).isFile()) {
            return file;
        }
        file = new File(folder, "content.xml");
        if (file.isFile()) {
            return file;
        }
        file = new File(folder, "compositeContent.jar");
        if (file.isFile()) {
            return file;
        }
        file = new File(folder, "compositeContent.xml");
        if (file.isFile()) {
            return file;
        }
        return null;
    }

    private void generateRepositoryMetadata(ExecutorService executor) {
        for (final Map.Entry<URI, Repository> entry : this.repositories.entrySet()) {
            final Repository repository = entry.getValue();
            this.deque.addLast(executor.submit(new Runnable(){

                public void run() {
                    if (P2Indexer.this.verbose) {
                        System.out.println("Processing " + repository.getMetadataFile());
                    }
                    try {
                        repository.processsMetadata(P2Indexer.this, P2Indexer.this.verbose);
                    }
                    catch (Exception ex) {
                        P2Indexer.this.repositories.remove(entry.getKey());
                        P2Indexer.this.print("Processing " + repository.getMetadataFile(), ex);
                    }
                }
            }));
        }
    }

    private void print(String message, Exception exception) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(bytes);
            out.println(message);
            exception.printStackTrace(out);
            System.err.write(bytes.toByteArray());
        }
        catch (Exception exception2) {}
    }

    private void generateIndex(File outputFolder) throws Exception {
        int id = 0;
        for (Repository repository : this.repositories.values()) {
            repository.setID(++id);
        }
        outputFolder.mkdirs();
        int count = this.writeCapabilities(outputFolder);
        this.writeRepositories(outputFolder);
        this.writeCapabilityIndex(outputFolder);
        if (this.verbose) {
            System.out.println(String.valueOf(this.repositories.size()) + " repositories");
            System.out.println(String.valueOf(count) + " capabilities");
        }
    }

    private void writeCapabilityIndex(File outputFolder) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        FileOutputStream outputStream = null;
        try {
            File capabilitiesFile = new File(outputFolder, "capabilities");
            outputStream = new FileOutputStream(capabilitiesFile);
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("VERSION", BinaryResourceImpl.BinaryIO.Version.VERSION_1_1);
            options.put("DATA_CONVERTER", Boolean.TRUE);
            options.put("BUFFER_CAPACITY", 8192);
            BinaryResourceImpl.EObjectOutputStream stream = new BinaryResourceImpl.EObjectOutputStream((OutputStream)outputStream, options);
            stream.writeInt(this.refreshHours);
            stream.writeCompressedInt(this.capabilityIndex.size());
            for (Map.Entry<String, Set<String>> entry : this.capabilityIndex.entrySet()) {
                Set<String> values = entry.getValue();
                stream.writeSegmentedString(entry.getKey());
                stream.writeCompressedInt(values.size());
                for (String value : values) {
                    stream.writeSegmentedString(value);
                }
            }
            stream.flush();
        }
        catch (Throwable throwable) {
            IOUtil.close(outputStream);
            throw throwable;
        }
        IOUtil.close((Closeable)outputStream);
    }

    private void writeRepositories(File outputFolder) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        FileOutputStream outputStream = null;
        try {
            File repositoriesFile = new File(outputFolder, "repositories");
            outputStream = new FileOutputStream(repositoriesFile);
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("VERSION", BinaryResourceImpl.BinaryIO.Version.VERSION_1_1);
            options.put("DATA_CONVERTER", Boolean.TRUE);
            options.put("BUFFER_CAPACITY", 8192);
            BinaryResourceImpl.EObjectOutputStream stream = new BinaryResourceImpl.EObjectOutputStream((OutputStream)outputStream, options);
            stream.writeLong(this.timeStamp);
            stream.writeInt(this.refreshHours);
            stream.writeInt(this.repositories.size());
            for (Repository repository : this.repositories.values()) {
                repository.write(this, stream);
            }
            stream.flush();
        }
        catch (Throwable throwable) {
            IOUtil.close(outputStream);
            throw throwable;
        }
        IOUtil.close((Closeable)outputStream);
    }

    private int writeCapabilities(File outputFolder) {
        int count = 0;
        for (Map.Entry<String, List<Capability>> entry : this.capabilities.entrySet()) {
            ++count;
            String name = entry.getKey();
            if (this.verbose) {
                System.out.println("Capability " + name);
            }
            HashMap<Repository, HashSet<String>> versions = new HashMap<Repository, HashSet<String>>();
            for (Capability capability : entry.getValue()) {
                Repository repository = capability.getRepository();
                if (!this.repositories.containsKey(repository.getURI())) continue;
                HashSet<String> set = (HashSet<String>)versions.get(repository);
                if (set == null) {
                    set = new HashSet<String>();
                    versions.put(repository, set);
                }
                set.add(capability.getVersion());
            }
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(Long.toString(this.timeStamp));
            for (Map.Entry versionEntry : versions.entrySet()) {
                Repository repository = (Repository)versionEntry.getKey();
                StringBuilder builder = new StringBuilder();
                builder.append(repository.getID());
                for (String version : (Set)versionEntry.getValue()) {
                    builder.append(",");
                    builder.append(version);
                }
                lines.add(builder.toString());
            }
            try {
                File file = new File(outputFolder, name);
                file.getParentFile().mkdirs();
                IOUtil.writeLines((File)file, (String)CHARSET, lines);
            }
            catch (Exception ex) {
                this.print("Capability " + name, ex);
            }
        }
        return count;
    }

    private static Pattern pattern(String pattern) {
        pattern = pattern.replaceAll(" ", "\\\\s+");
        pattern = pattern.replaceAll("=", "\\\\s*=\\\\s*");
        pattern = pattern.replaceAll("/>", "\\\\s*/>");
        pattern = pattern.replaceAll("'", " ");
        pattern = pattern.replaceAll("\"", " ");
        pattern = pattern.replaceAll(" ", "['\"]");
        pattern = pattern.replaceAll("#", "([^'\"]+)");
        return Pattern.compile(pattern);
    }

    private static boolean isValidFolder(File folder) {
        try {
            return folder.isDirectory() && folder.getAbsoluteFile().equals(folder.getCanonicalFile());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    static /* synthetic */ Pattern access$0(String string) {
        return P2Indexer.pattern(string);
    }

    private static final class Capability {
        private final Repository repository;
        private final String version;

        public Capability(Repository repository, String version) {
            this.repository = repository;
            this.version = version;
        }

        public Repository getRepository() {
            return this.repository;
        }

        public String getVersion() {
            return this.version;
        }
    }

    private static abstract class Repository {
        private static final String XML_SUFFIX = ".xml";
        private static final String JAR_SUFFIX = ".jar";
        private static final Pattern TIMESTAMP_PATTERN = P2Indexer.access$0("<property name='p2.timestamp' value='#'/>");
        private static final long NO_TIMESTAMP = 0L;
        protected final List<Composite> composites = new ArrayList<Composite>();
        protected final URI uri;
        protected final File metadataFile;
        protected int id;
        protected long timestamp = 0L;

        public Repository(URI uri, File metadataFile) {
            this.uri = uri;
            this.metadataFile = metadataFile;
        }

        public File getMetadataFile() {
            return this.metadataFile;
        }

        public URI getURI() {
            return this.uri;
        }

        public int getID() {
            return this.id;
        }

        public void setID(int id) {
            this.id = id;
        }

        public abstract boolean isComposed();

        public boolean isCompressed() {
            return this.metadataFile.getName().endsWith(JAR_SUFFIX);
        }

        public int getCapabilityCount() {
            return 0;
        }

        public void processsMetadata(P2Indexer indexer, boolean verbose) throws IOException {
            ZipFile jarFile = null;
            BufferedReader reader = null;
            try {
                String line;
                InputStream inputStream;
                if (this.isCompressed()) {
                    String name = this.metadataFile.getName();
                    name = String.valueOf(name.substring(0, name.length() - JAR_SUFFIX.length())) + XML_SUFFIX;
                    jarFile = new JarFile(this.metadataFile);
                    JarEntry jarEntry = ((JarFile)jarFile).getJarEntry(name);
                    inputStream = ((JarFile)jarFile).getInputStream(jarEntry);
                } else {
                    inputStream = new FileInputStream(this.metadataFile);
                }
                reader = new BufferedReader(new InputStreamReader(inputStream, P2Indexer.CHARSET));
                while ((line = reader.readLine()) != null) {
                    Matcher matcher;
                    if (this.timestamp == 0L && (matcher = TIMESTAMP_PATTERN.matcher(line)).find()) {
                        try {
                            this.timestamp = Long.parseLong(matcher.group(1));
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.err.println("Bad timestamp value '" + matcher.group(1) + "' for: " + this.metadataFile);
                        }
                    }
                    while (!line.trim().endsWith(">")) {
                        String incompleteLine = line;
                        line = reader.readLine();
                        if (line == null) break;
                        line = String.valueOf(incompleteLine) + " " + line;
                    }
                    this.processsMetadata(indexer, line, verbose);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                if (jarFile != null) {
                    jarFile.close();
                }
                throw throwable;
            }
            IOUtil.close((Closeable)reader);
            if (jarFile != null) {
                jarFile.close();
            }
        }

        protected abstract void processsMetadata(P2Indexer var1, String var2, boolean var3);

        public void write(P2Indexer indexer, BinaryResourceImpl.EObjectOutputStream stream) throws IOException {
            stream.writeURI(this.uri);
            stream.writeBoolean(this.isComposed());
            stream.writeBoolean(this.isCompressed());
            stream.writeLong(this.timestamp);
            if (!this.isComposed()) {
                stream.writeInt(this.getCapabilityCount());
            }
            for (Composite composite : this.composites) {
                stream.writeBoolean(true);
                stream.writeInt(composite.getID());
            }
            stream.writeBoolean(false);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Repository other = (Repository)obj;
            return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
        }

        public String toString() {
            return this.uri.toString();
        }

        private static final class Composite
        extends Repository {
            private static final Pattern CHILD_PATTERN = P2Indexer.access$0("<child location='#'/>");

            public Composite(URI uri, File metadataFile) {
                super(uri, metadataFile);
            }

            public boolean isComposed() {
                return true;
            }

            protected void processsMetadata(P2Indexer indexer, String line, boolean verbose) {
                String child;
                Matcher matcher = CHILD_PATTERN.matcher(line);
                if (matcher.find() && !StringUtil.isEmpty((String)(child = matcher.group(1)))) {
                    Repository childRepository;
                    URI childURI = URI.createURI((String)child);
                    if (childURI.hasTrailingPathSeparator()) {
                        childURI = childURI.trimSegments(1);
                    }
                    if (childURI.isRelative()) {
                        childURI = childURI.resolve(this.uri.hasTrailingPathSeparator() ? this.uri : this.uri.appendSegment(""));
                    }
                    if ((childRepository = (Repository)indexer.repositories.get(childURI)) != null) {
                        childRepository.composites.add(this);
                    } else if (verbose) {
                        System.err.println("Child repository of " + this.getURI() + " not found: " + childURI);
                    }
                }
            }
        }

        private static final class Simple
        extends Repository {
            private static final Pattern CAPABILITY_PATTERN = P2Indexer.access$0("<provided namespace='#' name='#' version='#'/>");
            private static final Pattern CAPABILITY_PATTERN_ALT = P2Indexer.access$0("<provided name='#' namespace='#' version='#'/>");
            private int capabilityCount;

            public Simple(URI uri, File metadataFile) {
                super(uri, metadataFile);
            }

            public boolean isComposed() {
                return false;
            }

            public int getCapabilityCount() {
                return this.capabilityCount;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void processsMetadata(P2Indexer indexer, String line, boolean verbose) {
                int namespaceIndex = 1;
                int nameIndex = 2;
                int versionIndex = 3;
                Matcher matcher = CAPABILITY_PATTERN.matcher(line);
                boolean found = matcher.find();
                if (!found) {
                    matcher = CAPABILITY_PATTERN_ALT.matcher(line);
                    nameIndex = 1;
                    namespaceIndex = 2;
                    found = matcher.find();
                }
                if (found) {
                    String namespace = URI.encodeSegment((String)matcher.group(namespaceIndex), (boolean)false);
                    String name = URI.encodeSegment((String)matcher.group(nameIndex), (boolean)false);
                    String qualifiedName = String.valueOf(namespace) + "/" + name;
                    if (name.equals(".") || name.equals("..") || name.startsWith("file:")) {
                        if (verbose) {
                            System.err.println("Skipping " + qualifiedName);
                        }
                        return;
                    }
                    Map map = indexer.capabilityIndex;
                    synchronized (map) {
                        CollectionUtil.add((Map)indexer.capabilityIndex, (Object)namespace, (Object)name);
                        String version = matcher.group(versionIndex);
                        ArrayList<Capability> list = (ArrayList<Capability>)indexer.capabilities.get(qualifiedName);
                        if (list == null) {
                            list = new ArrayList<Capability>();
                            indexer.capabilities.put(qualifiedName, list);
                        }
                        list.add(new Capability(this, version));
                        ++this.capabilityCount;
                    }
                }
            }
        }
    }
}

