/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.presentations;

import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.AnimationEngine;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.Messages;
import org.eclipse.ui.internal.intro.impl.model.IntroLaunchBarElement;
import org.eclipse.ui.internal.intro.impl.model.IntroLaunchBarShortcut;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroTheme;
import org.eclipse.ui.internal.intro.impl.swt.SharedStyleManager;
import org.eclipse.ui.internal.intro.impl.util.ImageUtil;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.config.CustomizableIntroPart;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IntroURLFactory;

public class IntroLaunchBar {
    private static final String LAUNCHBAR_ID = "org.eclipse.ui.internal.intro.impl.presentations.IntroLaunchBar";
    private static final String BUNDLECLASS_URI = "bundleclass://org.eclipse.ui.intro/" + IntroLaunchBar.class.getName();
    private static final String LAST_PAGE_ID = "lastPageId";
    private static final String INTRO_CONFIG_ID = "introConfigId";
    private Composite container;
    protected ToolBarManager toolBarManager;
    protected String lastPageId;
    protected Action closeAction = null;
    @Inject
    @Optional
    private IntroLaunchBarElement element;
    @Inject
    @Optional
    private IntroTheme theme;
    static final int[] TOP_LEFT_CORNER;
    static final int[] TOP_RIGHT_CORNER;
    static final int[] BOTTOM_LEFT_CORNER;
    static final int[] BOTTOM_RIGHT_CORNER;
    static final int[] SIMPLE_TOP_LEFT_CORNER;
    static final int[] SIMPLE_TOP_RIGHT_CORNER;
    static final int[] SIMPLE_BOTTOM_LEFT_CORNER;
    static final int[] SIMPLE_BOTTOM_RIGHT_CORNER;
    static final String S_STORED_LOCATION = "introLaunchBar.location";
    private static final String LAUNCH_COMMAND_BASE = "http://org.eclipse.ui.intro/showPage?id=";
    private Color fg;
    private Color bg;
    private MToolControl trimControl;

    static {
        int[] nArray = new int[12];
        nArray[1] = 6;
        nArray[2] = 1;
        nArray[3] = 5;
        nArray[4] = 1;
        nArray[5] = 4;
        nArray[6] = 4;
        nArray[7] = 1;
        nArray[8] = 5;
        nArray[9] = 1;
        nArray[10] = 6;
        TOP_LEFT_CORNER = nArray;
        int[] nArray2 = new int[12];
        nArray2[0] = -6;
        nArray2[2] = -5;
        nArray2[3] = 1;
        nArray2[4] = -4;
        nArray2[5] = 1;
        nArray2[6] = -1;
        nArray2[7] = 4;
        nArray2[8] = -1;
        nArray2[9] = 5;
        nArray2[11] = 6;
        TOP_RIGHT_CORNER = nArray2;
        int[] nArray3 = new int[12];
        nArray3[1] = -6;
        nArray3[2] = 1;
        nArray3[3] = -5;
        nArray3[4] = 1;
        nArray3[5] = -4;
        nArray3[6] = 4;
        nArray3[7] = -1;
        nArray3[8] = 5;
        nArray3[9] = -1;
        nArray3[10] = 6;
        BOTTOM_LEFT_CORNER = nArray3;
        int[] nArray4 = new int[12];
        nArray4[0] = -6;
        nArray4[2] = -5;
        nArray4[3] = -1;
        nArray4[4] = -4;
        nArray4[5] = -1;
        nArray4[6] = -1;
        nArray4[7] = -4;
        nArray4[8] = -1;
        nArray4[9] = -5;
        nArray4[11] = -6;
        BOTTOM_RIGHT_CORNER = nArray4;
        int[] nArray5 = new int[6];
        nArray5[1] = 2;
        nArray5[2] = 1;
        nArray5[3] = 1;
        nArray5[4] = 2;
        SIMPLE_TOP_LEFT_CORNER = nArray5;
        int[] nArray6 = new int[6];
        nArray6[0] = -2;
        nArray6[2] = -1;
        nArray6[3] = 1;
        nArray6[5] = 2;
        SIMPLE_TOP_RIGHT_CORNER = nArray6;
        int[] nArray7 = new int[6];
        nArray7[1] = -2;
        nArray7[2] = 1;
        nArray7[3] = -1;
        nArray7[4] = 2;
        SIMPLE_BOTTOM_LEFT_CORNER = nArray7;
        int[] nArray8 = new int[6];
        nArray8[0] = -2;
        nArray8[2] = -1;
        nArray8[3] = -1;
        nArray8[5] = -2;
        SIMPLE_BOTTOM_RIGHT_CORNER = nArray8;
    }

    public static IntroLaunchBar create(IWorkbenchWindow window, IntroModelRoot modelRoot, IntroLaunchBarElement element) {
        EModelService modelService = (EModelService)window.getService(EModelService.class);
        MTrimmedWindow trimmedWindow = (MTrimmedWindow)window.getService(MTrimmedWindow.class);
        MToolControl trimControl = (MToolControl)modelService.createModelElement(MToolControl.class);
        trimControl.setElementId(LAUNCHBAR_ID);
        trimControl.setContributionURI(BUNDLECLASS_URI);
        trimControl.getPersistedState().put(INTRO_CONFIG_ID, modelRoot.getId());
        trimControl.getPersistedState().put(LAST_PAGE_ID, modelRoot.getCurrentPageId());
        trimControl.getTags().add("Draggable");
        MTrimBar bar = modelService.getTrim(trimmedWindow, IntroLaunchBar.determineLocation(element));
        bar.getChildren().add(trimControl);
        return (IntroLaunchBar)trimControl.getObject();
    }

    public static void destroyAll(IWorkbench workbench) {
        EModelService modelService = (EModelService)workbench.getService(EModelService.class);
        MApplication application = (MApplication)workbench.getService(MApplication.class);
        List candidates = modelService.findElements((MApplicationElement)application, MToolControl.class, 16, toolControl -> LAUNCHBAR_ID.equals(toolControl.getElementId()) && BUNDLECLASS_URI.equals(((MToolControl)toolControl).getContributionURI()));
        for (MToolControl trimControl : candidates) {
            if (trimControl.getParent() == null) continue;
            trimControl.getParent().getChildren().remove(trimControl);
        }
    }

    private static SideValue determineLocation(IntroLaunchBarElement element) {
        IDialogSettings settings = IntroPlugin.getDefault().getDialogSettings();
        try {
            int storedLocation = settings.getInt(S_STORED_LOCATION);
            if (storedLocation > 0) {
                return IntroLaunchBar.toSideValue(storedLocation);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return IntroLaunchBar.toSideValue(element.getLocation());
    }

    private static SideValue toSideValue(int location) {
        switch (location) {
            case 16384: {
                return SideValue.LEFT;
            }
            case 131072: {
                return SideValue.RIGHT;
            }
            case 128: {
                return SideValue.TOP;
            }
            case 1024: {
                return SideValue.BOTTOM;
            }
        }
        return SideValue.BOTTOM;
    }

    private static int toSWT(SideValue sv) {
        switch (sv) {
            case LEFT: {
                return 16384;
            }
            case RIGHT: {
                return 131072;
            }
            case TOP: {
                return 128;
            }
            case BOTTOM: {
                return 1024;
            }
        }
        return 1024;
    }

    @PostConstruct
    void init(Composite parent, MToolControl trimControl) {
        this.trimControl = trimControl;
        this.lastPageId = (String)trimControl.getPersistedState().get(LAST_PAGE_ID);
        if (this.element == null || this.theme == null) {
            String configId = (String)trimControl.getPersistedState().get(INTRO_CONFIG_ID);
            IntroModelRoot modelRoot = IntroPlugin.getDefault().getExtensionPointManager().getModel(configId);
            this.element = modelRoot.getPresentation().getLaunchBarElement();
            this.theme = modelRoot.getTheme();
        }
        this.createControl(parent);
        this.storeLocation();
    }

    private void storeLocation() {
        IDialogSettings settings = IntroPlugin.getDefault().getDialogSettings();
        settings.put(S_STORED_LOCATION, IntroLaunchBar.toSWT(this.getLocation()));
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.computeColors(parent.getDisplay());
        this.container.setLayout((Layout)new BarLayout());
        this.toolBarManager = new ToolBarManager(0x800000 | this.getOrientation());
        this.fillToolBar();
        this.toolBarManager.createControl(this.container);
        ToolBar toolBar = this.toolBarManager.getControl();
        if (this.bg != null) {
            toolBar.setBackground(this.bg);
        }
        this.container.addPaintListener(this::onPaint);
        MenuManager manager = new MenuManager();
        IMenuListener listener = this::contextMenuAboutToShow;
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(listener);
        Menu contextMenu = manager.createContextMenu((Control)this.toolBarManager.getControl());
        this.toolBarManager.getControl().setMenu(contextMenu);
        IntroPlugin.getDefault().setLaunchBar(this);
    }

    private SideValue getLocation() {
        MElementContainer parent = this.trimControl.getParent();
        while (parent != null) {
            if (parent instanceof MTrimBar) {
                return ((MTrimBar)parent).getSide();
            }
            parent = parent.getParent();
        }
        return SideValue.BOTTOM;
    }

    protected void onPaint(PaintEvent e) {
        GC gc = e.gc;
        Color color = this.fg;
        if (color == null) {
            color = e.display.getSystemColor(18);
        }
        gc.setForeground(color);
        if (this.bg != null) {
            gc.setBackground(this.bg);
        }
        Point size = this.container.getSize();
        gc.fillRectangle(0, 0, size.x, size.y);
        gc.drawRectangle(0, 0, size.x - 1, size.y - 1);
    }

    private void computeColors(Display display) {
        RGB r;
        String value;
        if (this.element.getBackground() != null && (value = this.resolveColor(this.element.getBackground())) != null && (r = SharedStyleManager.parseRGB(value)) != null) {
            this.bg = new Color((Device)display, r);
        }
        if (this.element.getForeground() != null && (value = this.resolveColor(this.element.getForeground())) != null && (r = SharedStyleManager.parseRGB(value)) != null) {
            this.fg = new Color((Device)display, r);
        }
    }

    private String resolveColor(String value) {
        Map<String, String> properties;
        if (value.indexOf(36) == -1) {
            return value;
        }
        if (value.charAt(0) == '$' && value.charAt(value.length() - 1) == '$' && this.theme != null && (properties = this.theme.getProperties()) != null) {
            String key = value.substring(1, value.length() - 1);
            return properties.get(key);
        }
        return value;
    }

    public Control getControl() {
        return this.container;
    }

    @PreDestroy
    public void dispose() {
        if (this.container != null) {
            this.container.dispose();
        }
        if (this.toolBarManager != null) {
            this.toolBarManager.dispose();
            this.toolBarManager.removeAll();
        }
        this.toolBarManager = null;
        this.container = null;
        if (this.bg != null) {
            this.bg.dispose();
        }
        if (this.fg != null) {
            this.fg.dispose();
        }
    }

    private void fillToolBar() {
        this.closeAction = new Action("close"){

            public void run() {
                IntroLaunchBar.this.closeLaunchBar(false);
            }
        };
        this.closeAction.setText(Messages.IntroLaunchBar_close_label);
        this.closeAction.setToolTipText(Messages.IntroLaunchBar_close_tooltip);
        Action action = new Action("restore"){

            public void run() {
                IntroLaunchBar.this.openPage(IntroLaunchBar.this.lastPageId);
            }
        };
        action.setToolTipText(Messages.IntroLaunchBar_restore_tooltip);
        action.setImageDescriptor(ImageUtil.createImageDescriptor("full/etool16/restore_welcome.png"));
        this.toolBarManager.add((IAction)action);
        this.toolBarManager.add((IContributionItem)new Separator());
        if (this.element == null) {
            return;
        }
        IntroLaunchBarShortcut[] shortcuts = this.element.getShortcuts();
        int i = 0;
        while (i < shortcuts.length) {
            IntroLaunchBarShortcut shortcut = shortcuts[i];
            this.addShortcut(shortcut, (IToolBarManager)this.toolBarManager);
            ++i;
        }
    }

    private void addShortcut(final IntroLaunchBarShortcut shortcut, IToolBarManager toolBarManager) {
        Action action = new Action(shortcut.getToolTip()){

            public void run() {
                IntroLaunchBar.this.executeShortcut(shortcut.getURL());
            }
        };
        action.setImageDescriptor(shortcut.getImageDescriptor());
        action.setToolTipText(shortcut.getToolTip());
        toolBarManager.add((IAction)action);
    }

    public void close() {
        this.closeLaunchBar(false);
    }

    protected IIntroPart closeLaunchBar(boolean restore) {
        IntroPlugin.getDefault().setLaunchBar(null);
        if (this.trimControl.getParent() != null) {
            this.trimControl.getParent().getChildren().remove(this.trimControl);
        }
        IIntroPart intro = null;
        if (restore) {
            IWorkbenchWindow window = this.getWorkbenchWindow();
            intro = PlatformUI.getWorkbench().getIntroManager().showIntro(window, false);
            CustomizableIntroPart cpart = (CustomizableIntroPart)intro;
            Rectangle startBounds = Geometry.toDisplay((Control)this.getControl().getParent(), (Rectangle)this.getControl().getBounds());
            Rectangle endBounds = Geometry.toDisplay((Control)cpart.getControl().getParent(), (Rectangle)cpart.getControl().getBounds());
            AnimationEngine.createTweakedAnimation((Shell)window.getShell(), (int)400, (Rectangle)startBounds, (Rectangle)endBounds);
        }
        this.dispose();
        return intro;
    }

    private IWorkbenchWindow getWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    protected void executeShortcut(String url) {
        IIntroURL introURL = IntroURLFactory.createIntroURL(url);
        if (introURL != null) {
            IIntroPart intro = this.closeLaunchBar(true);
            if (intro == null) {
                return;
            }
            introURL.execute();
        }
    }

    protected void openPage(String id) {
        IIntroPart intro = this.closeLaunchBar(true);
        if (intro == null) {
            return;
        }
        StringBuilder url = new StringBuilder();
        url.append(LAUNCH_COMMAND_BASE);
        url.append(id);
        IIntroURL introURL = IntroURLFactory.createIntroURL(url.toString());
        if (introURL != null) {
            introURL.execute();
        }
    }

    protected void contextMenuAboutToShow(IMenuManager manager) {
        manager.add((IAction)this.closeAction);
    }

    public void dock(int side) {
    }

    private int getOrientation() {
        switch (this.getLocation()) {
            case LEFT: 
            case RIGHT: {
                return 512;
            }
        }
        return 256;
    }

    public String getId() {
        return LAUNCHBAR_ID;
    }

    public String getDisplayName() {
        return Messages.IntroLaunchBar_welcome;
    }

    public boolean isCloseable() {
        return this.element.getClose();
    }

    public void handleClose() {
        this.closeLaunchBar(false);
    }

    public int getWidthHint() {
        return -1;
    }

    public int getHeightHint() {
        return -1;
    }

    public boolean isResizeable() {
        return false;
    }

    class BarLayout
    extends Layout {
        BarLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean changed) {
            boolean vertical = (IntroLaunchBar.this.getOrientation() & 0x200) != 0;
            int marginWidth = vertical ? 1 : 3;
            int marginHeight = !vertical ? 1 : 3;
            int width = 0;
            int height = 0;
            Point tsize = IntroLaunchBar.this.toolBarManager.getControl().computeSize(-1, -1, changed);
            if (vertical) {
                width = tsize.x;
                height = tsize.y;
            } else {
                height = tsize.y;
                width = tsize.x;
            }
            if (vertical) {
                width += marginWidth;
                height += marginHeight + marginHeight;
            } else {
                width += marginWidth + marginWidth;
                height += marginHeight;
            }
            return new Point(width, height);
        }

        protected void layout(Composite composite, boolean changed) {
            boolean vertical = (IntroLaunchBar.this.getOrientation() & 0x200) != 0;
            int marginWidth = vertical ? 1 : 4;
            int marginHeight = !vertical ? 1 : 4;
            Point tsize = IntroLaunchBar.this.toolBarManager.getControl().computeSize(-1, -1, changed);
            Rectangle carea = composite.getClientArea();
            int x = carea.x + (IntroLaunchBar.this.getLocation() == SideValue.LEFT ? 0 : marginWidth);
            int y = carea.y + marginHeight;
            if (vertical) {
                IntroLaunchBar.this.toolBarManager.getControl().setBounds(x, y, carea.width - marginWidth, tsize.y);
            } else {
                IntroLaunchBar.this.toolBarManager.getControl().setBounds(x, y, tsize.x, carea.height - marginHeight);
            }
        }
    }
}

