/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.dialogs.about;

import java.util.Optional;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.ui.dialogs.textbundles.E4DialogMessages;
import org.eclipse.e4.ui.internal.dialogs.about.AboutText;
import org.eclipse.e4.ui.internal.dialogs.about.ParsedAbout;
import org.eclipse.e4.ui.internal.dialogs.about.ProductInformation;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class AboutDialogE4
extends TrayDialog {
    private final int maxImageWidth = 250;
    private final ProductInformation product = new ProductInformation(Platform.getProduct());
    private StyledText textWidget;
    private AboutText aboutText;

    public AboutDialogE4(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(NLS.bind((String)E4DialogMessages.AboutDialog_shellTitle, (Object)this.product.getName()));
    }

    protected Control createDialogArea(Composite parent) {
        String aboutTextProperty;
        Optional<Object> aboutImage = Optional.empty();
        Optional<Object> aboutItem = Optional.empty();
        aboutImage = this.product.getAboutImage();
        if (!(aboutImage.isPresent() && ((Image)aboutImage.get()).getBounds().width > 250 || (aboutTextProperty = this.product.getAboutText()) == null)) {
            this.aboutText = new AboutText(aboutTextProperty);
            aboutItem = this.aboutText.getAboutItem();
        }
        Composite workArea = (Composite)((CompositeFactory)WidgetFactory.composite((int)0).layoutData((Object)new GridData(1808))).create((Widget)parent);
        GridLayoutFactory.fillDefaults().applyTo(workArea);
        Color background = JFaceColors.getBannerBackground((Display)parent.getDisplay());
        Color foreground = JFaceColors.getBannerForeground((Display)parent.getDisplay());
        Composite top = (Composite)super.createDialogArea(workArea);
        GridLayoutFactory.fillDefaults().applyTo(top);
        top.setLayoutData((Object)new GridData(1808));
        top.setBackground(background);
        top.setForeground(foreground);
        Composite topContainer = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).background(background)).foreground(foreground)).create((Widget)top);
        GridLayoutFactory.fillDefaults().numColumns(aboutImage == null || !aboutItem.isPresent() ? 1 : 2).applyTo(topContainer);
        int topContainerHeightHint = this.calculateTopContainerHeightAndCreateImage(aboutImage, background, foreground, topContainer, parent);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, topContainerHeightHint).applyTo((Control)topContainer);
        aboutItem.ifPresent(c -> this.createTextWidget(parent, (ParsedAbout)c, background, foreground, topContainer));
        return workArea;
    }

    private void createTextWidget(Composite parent, ParsedAbout aboutItem, Color background, Color foreground, Composite topContainer) {
        Composite textComposite = (Composite)((CompositeFactory)WidgetFactory.composite((int)0).background(background)).create((Widget)topContainer);
        GridDataFactory.fillDefaults().grab(true, true).hint(400, -1).applyTo((Control)textComposite);
        GridLayoutFactory.fillDefaults().applyTo(textComposite);
        this.textWidget = new StyledText(textComposite, 2634);
        this.textWidget.setFont(parent.getFont());
        this.textWidget.setText(aboutItem.text());
        this.textWidget.setBackground(background);
        this.textWidget.setForeground(foreground);
        this.textWidget.setAlwaysShowScrollBars(false);
        this.aboutText = new AboutText(this.textWidget, () -> aboutItem);
        this.createTextMenu();
        GridDataFactory.swtDefaults().align(4, 1).grab(true, true).applyTo((Control)this.textWidget);
        textComposite.layout();
    }

    private int calculateTopContainerHeightAndCreateImage(Optional<Image> aboutImage, Color background, Color foreground, Composite topContainer, Composite parent) {
        GC gc = new GC((Drawable)parent);
        int topContainerHeightHint = 100;
        try {
            topContainerHeightHint = Math.max(topContainerHeightHint, gc.getFontMetrics().getHeight() * 6);
        }
        finally {
            gc.dispose();
        }
        if (aboutImage.isPresent()) {
            Label imageLabel = (Label)((LabelFactory)((LabelFactory)WidgetFactory.label((int)0).background(background)).foreground(foreground)).image(aboutImage.get()).create((Widget)topContainer);
            GridDataFactory.swtDefaults().align(4, 1).applyTo((Control)imageLabel);
            topContainerHeightHint = Math.max(topContainerHeightHint, aboutImage.get().getBounds().height);
        }
        return topContainerHeightHint;
    }

    private void createTextMenu() {
        MenuManager popupManager = new MenuManager();
        this.textWidget.setMenu(popupManager.createContextMenu((Control)this.textWidget));
        this.textWidget.addDisposeListener(e -> popupManager.dispose());
    }

    protected boolean isResizable() {
        return true;
    }
}

