/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.urischeme.IOperatingSystemRegistration;
import org.eclipse.urischeme.IScheme;
import org.eclipse.urischeme.IUriSchemeExtensionReader;

public class AutoRegisterSchemeHandlersJob
extends Job {
    private static final String SKIP_PREFERENCE = "skipAutoRegistration";
    private static final String PROCESSED_SCHEMES_PREFERENCE = "processedSchemes";
    private static final String SCHEME_LIST_PREFERENCE_SEPARATOR = ",";
    private static boolean alreadyTriggered = false;
    private final IEclipsePreferences preferenceNode = InstanceScope.INSTANCE.getNode("org.eclipse.urischeme");

    public AutoRegisterSchemeHandlersJob() {
        super(AutoRegisterSchemeHandlersJob.class.getSimpleName());
        this.setSystem(true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        IUriSchemeExtensionReader extensionReader = IUriSchemeExtensionReader.newInstance();
        LinkedHashSet<String> processedSchemes = new LinkedHashSet<String>(Arrays.asList(this.preferenceNode.get(PROCESSED_SCHEMES_PREFERENCE, "").split(SCHEME_LIST_PREFERENCE_SEPARATOR)));
        Collection<IScheme> toProcessSchemes = new LinkedHashSet<IScheme>(extensionReader.getSchemes());
        toProcessSchemes.removeIf(scheme -> processedSchemes.contains(scheme.getName()));
        if (toProcessSchemes.isEmpty()) {
            alreadyTriggered = true;
            return Status.OK_STATUS;
        }
        IOperatingSystemRegistration osRegistration = IOperatingSystemRegistration.getInstance();
        try {
            toProcessSchemes = osRegistration.getSchemesInformation(toProcessSchemes).stream().filter(scheme -> !scheme.isHandled()).collect(Collectors.toSet());
            if (toProcessSchemes.isEmpty()) {
                alreadyTriggered = true;
                return Status.OK_STATUS;
            }
            osRegistration.handleSchemes(toProcessSchemes, Collections.emptyList());
            processedSchemes.addAll(toProcessSchemes.stream().map(IScheme::getName).collect(Collectors.toList()));
            this.preferenceNode.put(PROCESSED_SCHEMES_PREFERENCE, processedSchemes.stream().collect(Collectors.joining(SCHEME_LIST_PREFERENCE_SEPARATOR)));
            this.preferenceNode.flush();
            alreadyTriggered = true;
        }
        catch (Exception e) {
            Platform.getLog(((Object)((Object)this)).getClass()).error(e.getMessage(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public boolean shouldSchedule() {
        return !Platform.getOS().equals("win32") && !alreadyTriggered && !Platform.getPreferencesService().getBoolean("org.eclipse.urischeme", SKIP_PREFERENCE, false, null);
    }
}

