/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.eclipse.userstorage.IBlob;
import org.eclipse.userstorage.IStorage;
import org.eclipse.userstorage.internal.Storage;
import org.eclipse.userstorage.internal.util.IOUtil;
import org.eclipse.userstorage.internal.util.StringUtil;
import org.eclipse.userstorage.util.BadKeyException;
import org.eclipse.userstorage.util.ConflictException;
import org.eclipse.userstorage.util.NoServiceException;

public class Blob
implements IBlob {
    public static final Map<String, String> NO_PROPERTIES = Collections.emptyMap();
    public static final InputStream NOT_MODIFIED = new InputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }
    };
    public static final String ETAG = "etag";
    private final Storage storage;
    private final String key;
    private final Map<String, String> properties;
    private boolean disposed;

    public Blob(Storage storage, String key, Map<String, String> properties) throws BadKeyException {
        this.storage = storage;
        this.key = BadKeyException.validate(key);
        this.properties = properties;
    }

    @Override
    public IStorage getStorage() {
        return this.storage;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Map<String, String> getProperties() throws IllegalStateException {
        this.checkNotDisposed();
        return Collections.unmodifiableMap(this.properties);
    }

    public void setProperties(Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            this.properties.put(key, String.valueOf(value));
        }
    }

    @Override
    public String getETag() throws IllegalStateException {
        this.checkNotDisposed();
        return this.properties.get(ETAG);
    }

    @Override
    public void setETag(String eTag) throws IllegalStateException {
        this.checkNotDisposed();
        this.storage.setETag(this.key, this.properties, eTag);
    }

    @Override
    public InputStream getContents() throws IOException, NoServiceException, IllegalStateException {
        this.checkNotDisposed();
        return this.storage.retrieveBlob(this.key, this.properties);
    }

    @Override
    public boolean setContents(InputStream in) throws IOException, ConflictException, NoServiceException, IllegalStateException {
        try {
            this.checkNotDisposed();
            boolean bl = this.storage.updateBlob(this.key, this.properties, in);
            return bl;
        }
        finally {
            IOUtil.closeSilent(in);
        }
    }

    @Override
    public String getContentsUTF() throws IOException, NoServiceException, IllegalStateException {
        InputStream contents = this.getContents();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtil.copy(contents, baos);
            String string = StringUtil.fromUTF(baos.toByteArray());
            return string;
        }
        finally {
            IOUtil.close(contents);
        }
    }

    @Override
    public boolean setContentsUTF(String value) throws IOException, ConflictException, NoServiceException, IllegalStateException {
        return this.setContents(IOUtil.streamUTF(value));
    }

    @Override
    public int getContentsInt() throws IOException, NumberFormatException, NoServiceException, IllegalStateException {
        return Integer.parseInt(this.getContentsUTF());
    }

    @Override
    public boolean setContentsInt(int value) throws IOException, ConflictException, NoServiceException, IllegalStateException {
        return this.setContentsUTF(Integer.toString(value));
    }

    @Override
    public boolean getContentsBoolean() throws IOException, NoServiceException, IllegalStateException {
        return Boolean.parseBoolean(this.getContentsUTF());
    }

    @Override
    public boolean setContentsBoolean(boolean value) throws IOException, ConflictException, NoServiceException, IllegalStateException {
        return this.setContentsUTF(Boolean.toString(value));
    }

    @Override
    public boolean delete() throws IOException, ConflictException, NoServiceException, IllegalStateException {
        this.checkNotDisposed();
        return this.storage.deleteBlob(this.key, this.properties);
    }

    public String toString() {
        return this.storage.getService() + " (" + this.storage.getApplicationToken() + "/" + this.key + ")";
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    void dispose() {
        this.disposed = true;
    }

    private void checkNotDisposed() throws IllegalStateException {
        if (this.disposed) {
            throw new IllegalStateException("Blob disposed: " + this);
        }
    }
}

