/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.ui;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.userstorage.IStorage;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.internal.StorageServiceRegistry;
import org.eclipse.userstorage.ui.ServiceSelectorComposite;

public class StorageConfigurationComposite
extends ServiceSelectorComposite {
    private final IStorage storage;
    private IStorageService defaultService;

    public StorageConfigurationComposite(Composite parent, int style, IStorage storage) {
        super(parent, style);
        this.storage = storage;
        this.defaultService = storage.getService();
        this.performDefaults();
    }

    public final IStorage getStorage() {
        return this.storage;
    }

    public final boolean isDirty() {
        IStorageService selectedService = this.getSelectedService();
        return selectedService != this.defaultService;
    }

    public final boolean performDefaults() {
        if (this.isDirty()) {
            this.setSelectedService(this.defaultService);
            return true;
        }
        return false;
    }

    public final boolean performApply() {
        if (this.isDirty()) {
            this.defaultService = this.getSelectedService();
            this.storage.setService(this.defaultService);
            return true;
        }
        return false;
    }

    @Override
    protected void serviceRemoved(IStorageService service) {
        IStorageService selectedService = this.getSelectedService();
        if (service == selectedService) {
            service = StorageServiceRegistry.INSTANCE.getFirstService();
            this.setSelectedService(service);
        }
    }
}

