/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.oomph.ui.ErrorDialog;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class UIUtil {
    public static final IWorkbench WORKBENCH;
    private static Image errorImage;
    private static Image warningImage;
    private static Image infoImage;
    private static Boolean browserAvailable;

    static {
        IWorkbench workbench = null;
        try {
            workbench = PlatformUI.getWorkbench();
        }
        catch (Throwable throwable) {}
        WORKBENCH = workbench;
    }

    private UIUtil() {
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            try {
                display = PlatformUI.getWorkbench().getDisplay();
            }
            catch (Throwable throwable) {}
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (display == null) {
            display = new Display();
        }
        return display;
    }

    public static Shell getShell() {
        final Shell[] shell = new Shell[1];
        final Display display = UIUtil.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                Shell[] shells;
                shell[0] = display.getActiveShell();
                if (shell[0] == null) {
                    try {
                        IWorkbenchWindow[] windows;
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()).length != 0) {
                            window = windows[0];
                        }
                        if (window != null) {
                            shell[0] = window.getShell();
                        }
                    }
                    catch (Throwable throwable) {}
                }
                if (shell[0] == null && (shells = display.getShells()).length > 0) {
                    shell[0] = shells[0];
                }
            }
        });
        return shell[0];
    }

    public static synchronized boolean isBrowserAvailable() {
        if (browserAvailable == null) {
            UIUtil.syncExec(new Runnable(){

                public void run() {
                    block11: {
                        Shell shell = null;
                        try {
                            try {
                                shell = new Shell();
                                new Browser((Composite)shell, 0);
                                browserAvailable = true;
                            }
                            catch (SWTError sWTError) {
                                browserAvailable = false;
                                try {
                                    shell.dispose();
                                }
                                catch (Exception exception) {}
                                break block11;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                shell.dispose();
                            }
                            catch (Exception exception) {}
                            throw throwable;
                        }
                        try {
                            shell.dispose();
                        }
                        catch (Exception exception) {}
                    }
                }
            });
        }
        return browserAvailable;
    }

    public static boolean isParent(Composite parent, Control controlToCheck) {
        if (parent == null || controlToCheck == null) {
            throw new IllegalArgumentException("Neither parent nor controlToCheck must be null");
        }
        if (controlToCheck == parent) {
            return true;
        }
        Composite tmpParent = controlToCheck.getParent();
        while (tmpParent != parent && tmpParent != null) {
            tmpParent = tmpParent.getParent();
        }
        return tmpParent == parent;
    }

    public static GridLayout createGridLayout(int numColumns) {
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        return layout;
    }

    public static GridData applyGridData(Control control) {
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        control.setLayoutData((Object)data);
        return data;
    }

    public static GridData grabVertical(GridData data) {
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        return data;
    }

    public static void clearTextSelection(Object control) {
        Text text = UIUtil.findTextControl(control);
        if (text != null) {
            text.clearSelection();
        }
    }

    public static void setSelectionToEnd(Widget control) {
        Text text = UIUtil.findTextControl(control);
        if (text != null) {
            String content = text.getText();
            text.setSelection(content.length() + 1);
        }
    }

    public static void setSelectionTo(Widget control, Point selection) {
        Text text = UIUtil.findTextControl(control);
        if (text != null) {
            text.setSelection(selection);
        }
    }

    public static void selectAllText(Widget control) {
        Text text = UIUtil.findTextControl(control);
        if (text != null) {
            text.selectAll();
        }
    }

    private static Text findTextControl(Object control) {
        if (control instanceof Viewer) {
            control = ((Viewer)control).getControl();
        }
        if (control instanceof CCombo) {
            CCombo combo = (CCombo)control;
            try {
                control = ReflectUtil.getValue((String)"text", (Object)combo);
            }
            catch (Throwable throwable) {}
        }
        if (control instanceof Text) {
            return (Text)control;
        }
        return null;
    }

    public static void runInProgressDialog(Shell shell, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        block3: {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell){

                protected Point getInitialSize() {
                    Point calculatedSize = super.getInitialSize();
                    if (calculatedSize.x < 800) {
                        calculatedSize.x = 800;
                    }
                    return calculatedSize;
                }
            };
            try {
                dialog.run(true, true, runnable);
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InvocationTargetException ex) {
                if (ex.getCause() instanceof OperationCanceledException) break block3;
                throw ex;
            }
        }
    }

    public static void handleException(Throwable ex) {
        UIPlugin.INSTANCE.log(ex);
        ErrorDialog.open(ex);
    }

    public static Color getEclipseThemeColor() {
        return UIPlugin.getColor(44, 34, 85);
    }

    public static Image[] extractSprites(Image textureAtlas, int countX, int countY) {
        Rectangle atlasBounds = textureAtlas.getBounds();
        int width = atlasBounds.width / countX;
        int height = atlasBounds.height / countY;
        Image[] sprites = new Image[countX * countY];
        int y = 0;
        while (y < countY) {
            int x = 0;
            while (x < countX) {
                sprites[countX * y + x] = UIUtil.extractSprite(textureAtlas, x * width, y * width, width, height);
                ++x;
            }
            ++y;
        }
        return sprites;
    }

    public static Image extractSprite(Image textureAtlas, int x, int y, int width, int height) {
        ImageData textureAtlasData = textureAtlas.getImageData();
        PaletteData textureAtlasPaletteData = textureAtlasData.palette;
        ImageData spriteImageData = new ImageData(width, height, textureAtlasData.depth, new PaletteData(textureAtlasPaletteData.redMask, textureAtlasPaletteData.greenMask, textureAtlasPaletteData.blueMask));
        int[] pixels = new int[width * height];
        byte[] alphas = new byte[width * height];
        int scanline = 0;
        while (scanline < height) {
            int yOffset = y + scanline;
            textureAtlasData.getPixels(x, yOffset, width, pixels, scanline * width);
            textureAtlasData.getAlphas(x, yOffset, width, alphas, scanline * width);
            ++scanline;
        }
        spriteImageData.setPixels(0, 0, pixels.length, pixels, 0);
        spriteImageData.setAlphas(0, 0, alphas.length, alphas, 0);
        return new Image((Device)UIUtil.getDisplay(), spriteImageData);
    }

    public static Image getStatusImage(int severity) {
        if (severity == 4) {
            if (errorImage == null) {
                errorImage = UIPlugin.INSTANCE.getSWTImage("error");
            }
            return errorImage;
        }
        if (severity == 2) {
            if (warningImage == null) {
                warningImage = UIPlugin.INSTANCE.getSWTImage("warning");
            }
            return warningImage;
        }
        if (infoImage == null) {
            infoImage = UIPlugin.INSTANCE.getSWTImage("info");
        }
        return infoImage;
    }

    public static void exec(Display display, boolean async, Runnable runnable) {
        if (async) {
            UIUtil.asyncExec(display, runnable);
        } else {
            UIUtil.syncExec(display, runnable);
        }
    }

    public static void asyncExec(Runnable runnable) {
        Display display = UIUtil.getDisplay();
        if (display != null) {
            UIUtil.asyncExec(display, runnable);
        }
    }

    public static void asyncExec(final Control control, final Runnable runnable) {
        block3: {
            try {
                if (control.isDisposed()) {
                    return;
                }
                control.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (!control.isDisposed()) {
                            runnable.run();
                        }
                    }
                });
            }
            catch (SWTException ex) {
                if (ex.code == 24) break block3;
                throw ex;
            }
        }
    }

    public static void asyncExec(final Display display, final Runnable runnable) {
        block3: {
            try {
                if (display.isDisposed()) {
                    return;
                }
                display.asyncExec(new Runnable(){

                    public void run() {
                        block3: {
                            if (display.isDisposed()) {
                                return;
                            }
                            try {
                                runnable.run();
                            }
                            catch (SWTException ex) {
                                if (ex.code == 24) break block3;
                                throw ex;
                            }
                        }
                    }
                });
            }
            catch (SWTException ex) {
                if (ex.code == 24) break block3;
                throw ex;
            }
        }
    }

    public static void syncExec(Runnable runnable) {
        Display display = UIUtil.getDisplay();
        if (Display.getCurrent() == display || display == null) {
            runnable.run();
        } else {
            UIUtil.syncExec(display, runnable);
        }
    }

    public static void syncExec(final Display display, final Runnable runnable) {
        block3: {
            try {
                if (display.isDisposed()) {
                    return;
                }
                display.syncExec(new Runnable(){

                    public void run() {
                        block3: {
                            if (display.isDisposed()) {
                                return;
                            }
                            try {
                                runnable.run();
                            }
                            catch (SWTException ex) {
                                if (ex.code == 24) break block3;
                                throw ex;
                            }
                        }
                    }
                });
            }
            catch (SWTException ex) {
                if (ex.code == 24) break block3;
                throw ex;
            }
        }
    }

    public static void timerExec(int milliseconds, Runnable runnable) {
        Display display = UIUtil.getDisplay();
        if (display != null) {
            UIUtil.timerExec(milliseconds, display, runnable);
        }
    }

    public static void timerExec(int milliseconds, final Display display, final Runnable runnable) {
        block3: {
            try {
                if (display.isDisposed()) {
                    return;
                }
                display.timerExec(milliseconds, new Runnable(){

                    public void run() {
                        block3: {
                            if (display.isDisposed()) {
                                return;
                            }
                            try {
                                runnable.run();
                            }
                            catch (SWTException ex) {
                                if (ex.code == 24) break block3;
                                throw ex;
                            }
                        }
                    }
                });
            }
            catch (SWTException ex) {
                if (ex.code == 24) break block3;
                throw ex;
            }
        }
    }

    public static IDialogSettings getOrCreateSection(IDialogSettings settings, String sectionName) {
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    public static void dispose(Resource ... resources) {
        int i = 0;
        while (i < resources.length) {
            Resource resource = resources[i];
            if (resource != null && !resource.isDisposed()) {
                resource.dispose();
            }
            ++i;
        }
    }

    public static void simulateKey(char character) {
        Display display = UIUtil.getDisplay();
        Event event = new Event();
        event.type = 1;
        event.character = character;
        display.post(event);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {}
        event.type = 2;
        display.post(event);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static String stripHTML(String html) {
        try {
            final StringBuilder builder = new StringBuilder();
            new ParserDelegator().parse(new StringReader(html), new HTMLEditorKit.ParserCallback(){

                public void handleText(char[] text, int pos) {
                    builder.append(text);
                }
            }, Boolean.TRUE);
            return builder.toString();
        }
        catch (IOException iOException) {
            return html;
        }
    }
}

