/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.BasicResourceHandler;
import org.eclipse.oomph.base.util.BytesResourceFactoryImpl;
import org.eclipse.oomph.p2.internal.core.PGPKeyResourceImpl;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.internal.core.util.ECFURIHandlerImpl;
import org.eclipse.oomph.setup.internal.core.util.Messages;
import org.eclipse.oomph.setup.internal.core.util.ProxyResolver;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.util.IOExceptionWithCause;
import org.eclipse.oomph.util.WorkerPool;
import org.eclipse.osgi.util.NLS;

public class ResourceMirror
extends WorkerPool<ResourceMirror, URI, LoadJob> {
    private ResourceSet resourceSet;
    private DelegatingResourceLocator resourceLocator;
    private HashSet<URI> visited = new HashSet();

    public ResourceMirror() {
        this(SetupCoreUtil.createResourceSet());
    }

    public ResourceMirror(ResourceSet resourceSet) {
        this(resourceSet, Runtime.getRuntime().availableProcessors() * 2);
    }

    public ResourceMirror(ResourceSet resourceSet, int maxWorker) {
        super(maxWorker);
        this.resourceSet = resourceSet;
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(".asc".substring(1), uri -> new PGPKeyResourceImpl(uri));
        this.resourceLocator = new DelegatingResourceLocator((ResourceSetImpl)resourceSet);
    }

    protected LoadJob createWorker(URI key, int workerID, boolean secondary) {
        LoadJob loadJob = new LoadJob(this, key, workerID, secondary);
        loadJob.setSystem(true);
        return loadJob;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void begin(final IProgressMonitor monitor) {
        Map loadOptions = this.resourceSet.getLoadOptions();
        final String taskName = loadOptions.get("OPTION_CACHE_HANDLING") == ECFURIHandlerImpl.CacheHandling.CACHE_WITHOUT_ETAG_CHECKING ? Messages.ResourceMirror_LoadingLocalCache_task : Messages.ResourceMirror_LoadingInternet_task;
        BasicResourceHandler resourceHandler = new BasicResourceHandler(){
            private int counter;
            private final Set<ResourceSet> resourceSets = new HashSet<ResourceSet>();

            public synchronized void preLoad(XMLResource resource, InputStream inputStream, Map<?, ?> options) {
                ResourceSet resourceSet = ResourceMirror.this.getResourceSet();
                this.resourceSets.add(resourceSet);
                int total = 0;
                for (ResourceSet rs : this.resourceSets) {
                    total += rs.getResources().size();
                }
                ++this.counter;
                if (total < this.counter) {
                    total = this.counter;
                }
                monitor.setTaskName(NLS.bind((String)Messages.ResourceMirror_LoadingXofY_task, (Object[])new Object[]{taskName, this.counter, total}));
                monitor.subTask(NLS.bind((String)Messages.ResourceMirror_Loading_task, (Object)resource.getURI()));
                monitor.worked(1);
            }
        };
        1 oldResourceHandler = loadOptions.put("RESOURCE_HANDLER", resourceHandler);
        loadOptions.put("OPTION_MONITOR", monitor);
        monitor.beginTask(taskName, 50);
        this.begin(taskName, monitor);
        loadOptions.put("RESOURCE_HANDLER", oldResourceHandler);
        loadOptions.remove("OPTION_MONITOR");
    }

    protected void resolveProxies() {
        IProgressMonitor monitor = this.getMonitor();
        this.resourceLocator.dispose();
        this.resourceLocator = null;
        new ProxyResolver(this.resourceSet).begin(monitor);
    }

    public void dispose() {
        this.resourceSet = null;
        if (this.resourceLocator != null) {
            this.resourceLocator.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isCompleted(URI uri) {
        if (this.resourceSet == null) {
            return true;
        }
        ResourceSet resourceSet = this.resourceSet;
        synchronized (resourceSet) {
            block5: {
                Resource resource = this.resourceSet.getResource(uri, false);
                if (resource == null || !resource.isLoaded() || this.visited.add(uri)) break block5;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource createResource(URI uri) {
        Resource resource;
        ResourceSet resourceSet = this.resourceSet;
        synchronized (resourceSet) {
            resource = this.resourceSet.getResource(uri, false);
            if (resource == null) {
                resource = this.resourceSet.createResource(uri);
            }
        }
        return resource;
    }

    protected void visit(EObject eObject) {
    }

    private final class DelegatingResourceLocator
    extends ResourceSetImpl.ResourceLocator {
        private DelegatingResourceLocator(ResourceSetImpl resourceSet) {
            super(resourceSet);
        }

        public Resource getResource(URI uri, boolean loadOnDemand) {
            if (loadOnDemand && "setup".equals(uri.fileExtension())) {
                return null;
            }
            return this.basicGetResource(uri, loadOnDemand);
        }

        public void dispose() {
            super.dispose();
        }
    }

    public static class LoadJob
    extends WorkerPool.Worker<URI, ResourceMirror> {
        private LoadJob(ResourceMirror resourceMirror, URI uri, int id, boolean secondary) {
            super(NLS.bind((String)Messages.ResourceMirror_Load_job, (Object)uri), (WorkerPool)resourceMirror, (Object)uri, id, secondary);
        }

        protected IStatus perform(IProgressMonitor monitor) {
            Resource resource = ((ResourceMirror)this.getWorkPool()).createResource((URI)this.getKey());
            if (!resource.isLoaded()) {
                try {
                    resource.load(((ResourceMirror)this.getWorkPool()).resourceSet.getLoadOptions());
                }
                catch (Throwable throwable) {
                    new ResourceSetImpl(){

                        public void handleDemandLoadException(Resource resource, IOException exception) throws RuntimeException {
                            try {
                                super.handleDemandLoadException(resource, exception);
                            }
                            catch (RuntimeException runtimeException) {
                                // empty catch block
                            }
                        }
                    }.handleDemandLoadException(resource, throwable instanceof IOException ? (IOException)throwable : new IOExceptionWithCause(throwable));
                }
            }
            this.visit(resource);
            return Status.OK_STATUS;
        }

        private void delay() {
        }

        private void visit(Resource resource) {
            ResourceMirror workPool = (ResourceMirror)this.getWorkPool();
            TreeIterator it = EcoreUtil.getAllContents((Resource)resource, (boolean)false);
            block0: while (it.hasNext()) {
                this.delay();
                if (workPool.isCanceled()) break;
                EObject eObject = (EObject)it.next();
                if (eObject.eIsProxy()) {
                    URI proxyURI = ((InternalEObject)eObject).eProxyURI().trimFragment();
                    workPool.schedule(proxyURI, false);
                    continue;
                }
                workPool.visit(eObject);
                ListIterator it2 = ((InternalEList)eObject.eCrossReferences()).basicListIterator();
                while (it2.hasNext()) {
                    this.delay();
                    if (workPool.isCanceled()) continue block0;
                    EObject eCrossReference = (EObject)it2.next();
                    if (!eCrossReference.eIsProxy()) continue;
                    URI proxyURI = ((InternalEObject)eCrossReference).eProxyURI().trimFragment();
                    workPool.schedule(proxyURI, true);
                }
            }
        }
    }

    public static class WithProductImages
    extends ResourceMirror {
        public WithProductImages(ResourceSet resourceSet) {
            this(resourceSet, Runtime.getRuntime().availableProcessors() * 2);
        }

        public WithProductImages(ResourceSet resourceSet, int maxWorker) {
            super(resourceSet, maxWorker);
            BytesResourceFactoryImpl bytesResourceFactory = new BytesResourceFactoryImpl();
            Map extensionToFactoryMap = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
            extensionToFactoryMap.put("gif", bytesResourceFactory);
            extensionToFactoryMap.put("png", bytesResourceFactory);
            extensionToFactoryMap.put("jpeg", bytesResourceFactory);
            extensionToFactoryMap.put("jpg", bytesResourceFactory);
        }

        @Override
        protected void visit(EObject eObject) {
            Scope scope;
            URI uri;
            if (eObject instanceof Scope && (uri = SetupCoreUtil.getBrandingImageURI(scope = (Scope)eObject)) != null && this.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap().containsKey(uri.fileExtension())) {
                this.schedule(uri, true);
            }
            super.visit(eObject);
        }
    }
}

