/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.lz;

import java.io.DataInputStream;
import java.io.IOException;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.CorruptedInputException;

public final class LZDecoder {
    private final byte[] buf;
    private final int bufSize;
    private int start = 0;
    private int pos = 0;
    private int full = 0;
    private int limit = 0;
    private int pendingLen = 0;
    private int pendingDist = 0;

    public LZDecoder(int n, byte[] byArray, ArrayCache arrayCache) {
        this.bufSize = n;
        this.buf = arrayCache.getByteArray(this.bufSize, false);
        if (byArray != null) {
            this.full = this.pos = Math.min(byArray.length, n);
            this.start = this.pos;
            System.arraycopy(byArray, byArray.length - this.pos, this.buf, 0, this.pos);
        }
    }

    public void putArraysToCache(ArrayCache arrayCache) {
        arrayCache.putArray(this.buf);
    }

    public void reset() {
        this.start = 0;
        this.pos = 0;
        this.full = 0;
        this.limit = 0;
        this.buf[this.bufSize - 1] = 0;
    }

    public void setLimit(int n) {
        this.limit = this.bufSize - this.pos <= n ? this.bufSize : this.pos + n;
    }

    public boolean hasSpace() {
        return this.pos < this.limit;
    }

    public boolean hasPending() {
        return this.pendingLen > 0;
    }

    public int getPos() {
        return this.pos;
    }

    public int getByte(int n) {
        int n2 = this.pos - n - 1;
        if (n >= this.pos) {
            n2 += this.bufSize;
        }
        return this.buf[n2] & 0xFF;
    }

    public void putByte(byte by) {
        this.buf[this.pos++] = by;
        if (this.full < this.pos) {
            this.full = this.pos;
        }
    }

    public void repeat(int n, int n2) throws IOException {
        int n3;
        if (n < 0 || n >= this.full) {
            throw new CorruptedInputException();
        }
        int n4 = Math.min(this.limit - this.pos, n2);
        this.pendingLen = n2 - n4;
        this.pendingDist = n;
        int n5 = this.pos - n - 1;
        if (n5 < 0) {
            assert (this.full == this.bufSize);
            n3 = Math.min(this.bufSize - (n5 += this.bufSize), n4);
            assert (n3 <= n + 1);
            System.arraycopy(this.buf, n5, this.buf, this.pos, n3);
            this.pos += n3;
            n5 = 0;
            if ((n4 -= n3) == 0) {
                return;
            }
        }
        assert (n5 < this.pos);
        assert (n4 > 0);
        do {
            n3 = Math.min(n4, this.pos - n5);
            System.arraycopy(this.buf, n5, this.buf, this.pos, n3);
            this.pos += n3;
        } while ((n4 -= n3) > 0);
        if (this.full < this.pos) {
            this.full = this.pos;
        }
    }

    public void repeatPending() throws IOException {
        if (this.pendingLen > 0) {
            this.repeat(this.pendingDist, this.pendingLen);
        }
    }

    public void copyUncompressed(DataInputStream dataInputStream, int n) throws IOException {
        int n2 = Math.min(this.bufSize - this.pos, n);
        dataInputStream.readFully(this.buf, this.pos, n2);
        this.pos += n2;
        if (this.full < this.pos) {
            this.full = this.pos;
        }
    }

    public int flush(byte[] byArray, int n) {
        int n2 = this.pos - this.start;
        if (this.pos == this.bufSize) {
            this.pos = 0;
        }
        System.arraycopy(this.buf, this.start, byArray, n, n2);
        this.start = this.pos;
        return n2;
    }
}

