/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.model.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.internal.Position;
import org.eclipse.e4.ui.model.internal.PositionInfo;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ModelUtils {
    public static final String CONTAINING_PARENT = "ModelUtils.containingParent";

    public static EClassifier getTypeArgument(EClass eClass, EGenericType eGenericType) {
        ETypeParameter eTypeParameter = eGenericType.getETypeParameter();
        if (eTypeParameter != null) {
            for (EGenericType eGenericSuperType : eClass.getEAllGenericSuperTypes()) {
                EList eTypeParameters = eGenericSuperType.getEClassifier().getETypeParameters();
                int index = eTypeParameters.indexOf((Object)eTypeParameter);
                if (index == -1 || eGenericSuperType.getETypeArguments().size() <= index) continue;
                return ModelUtils.getTypeArgument(eClass, (EGenericType)eGenericSuperType.getETypeArguments().get(index));
            }
            return null;
        }
        return eGenericType.getEClassifier();
    }

    public static MApplicationElement findElementById(MApplicationElement element, String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        if (id.equals(element.getElementId())) {
            return element;
        }
        EList elements = ((EObject)element).eContents();
        for (EObject childElement : elements) {
            MApplicationElement result;
            if (!(childElement instanceof MApplicationElement) || (result = ModelUtils.findElementById((MApplicationElement)childElement, id)) == null) continue;
            return result;
        }
        return null;
    }

    public static List<MApplicationElement> merge(MApplicationElement container, EStructuralFeature feature, List<MApplicationElement> elements, String positionInList) {
        EObject eContainer = (EObject)container;
        if (feature.isMany()) {
            ArrayList<MApplicationElement> copy = new ArrayList<MApplicationElement>(elements);
            List list = (List)eContainer.eGet(feature);
            boolean flag = true;
            if (positionInList != null && positionInList.trim().length() != 0) {
                int index = -1;
                PositionInfo posInfo = PositionInfo.parse(positionInList);
                if (posInfo != null) {
                    switch (posInfo.getPosition()) {
                        case FIRST: {
                            index = 0;
                            break;
                        }
                        case INDEX: {
                            index = posInfo.getPositionReferenceAsInteger();
                            break;
                        }
                        case BEFORE: 
                        case AFTER: {
                            int tmpIndex = -1;
                            String elementId = posInfo.getPositionReference();
                            int i = 0;
                            while (i < list.size()) {
                                if (elementId.equals(((MApplicationElement)list.get(i)).getElementId())) {
                                    tmpIndex = i;
                                    break;
                                }
                                ++i;
                            }
                            if (tmpIndex != -1) {
                                if (posInfo.getPosition() == Position.BEFORE) {
                                    index = tmpIndex;
                                    break;
                                }
                                index = tmpIndex + 1;
                                break;
                            }
                            Platform.getLog(ModelUtils.class).warn(MessageFormat.format("Could not find element with Id ''{0}'' in ''{1}''", elementId, container.getElementId()));
                        }
                    }
                } else {
                    ModelUtils.invalidPrefixWarning(container, positionInList);
                }
                if (index >= 0 && list.size() > index) {
                    flag = false;
                    ModelUtils.mergeList(list, elements, index);
                }
            }
            if (flag) {
                ModelUtils.mergeList(list, elements, -1);
            }
            return copy;
        }
        if (elements.size() >= 1) {
            if (elements.size() > 1) {
                System.err.println("The feature is single valued but a list of values is passed in.");
            }
            MApplicationElement e = elements.get(0);
            eContainer.eSet(feature, (Object)e);
            return Collections.singletonList(e);
        }
        return Collections.emptyList();
    }

    private static void mergeList(List<MApplicationElement> list, List<MApplicationElement> elements, int index) {
        MApplicationElement[] tmp = new MApplicationElement[elements.size()];
        elements.toArray(tmp);
        MApplicationElement[] mApplicationElementArray = tmp;
        int n = tmp.length;
        int n2 = 0;
        while (n2 < n) {
            MApplicationElement element = mApplicationElementArray[n2];
            String elementID = element.getElementId();
            boolean found = false;
            if (elementID != null && elementID.length() != 0) {
                for (MApplicationElement existingObject : list) {
                    MApplicationElement existingEObject;
                    if (!(existingObject instanceof MApplicationElement) || !elementID.equals((existingEObject = existingObject).getElementId())) continue;
                    if (EcoreUtil.equals((EObject)((EObject)existingEObject), (EObject)((EObject)element))) {
                        found = true;
                        break;
                    }
                    EObject root = EcoreUtil.getRootContainer((EObject)((EObject)existingEObject));
                    EcoreUtil.replace((EObject)((EObject)existingEObject), (EObject)((EObject)element));
                    Collection settings = EcoreUtil.UsageCrossReferencer.find((EObject)((EObject)existingEObject), (EObject)root);
                    for (EStructuralFeature.Setting setting : settings) {
                        setting.set((Object)element);
                    }
                    found = true;
                }
            }
            if (!found) {
                if (index == -1) {
                    list.add(element);
                } else {
                    list.add(index, element);
                }
            }
            ++n2;
        }
    }

    static MApplicationElement getParent(MApplicationElement element) {
        EObject eContainer;
        if (element instanceof MUIElement && ((MUIElement)element).getCurSharedRef() != null) {
            return ((MUIElement)element).getCurSharedRef().getParent();
        }
        if (element != null && element.getTransientData() != null && element.getTransientData().get(CONTAINING_PARENT) instanceof MApplicationElement) {
            return (MApplicationElement)element.getTransientData().get(CONTAINING_PARENT);
        }
        if (element instanceof EObject && (eContainer = ((EObject)element).eContainer()) instanceof MApplicationElement) {
            return (MApplicationElement)eContainer;
        }
        return null;
    }

    public static IEclipseContext getContainingContext(MApplicationElement element) {
        MApplicationElement curParent = ModelUtils.getParent(element);
        while (curParent != null) {
            if (curParent instanceof MContext) {
                return ((MContext)((Object)curParent)).getContext();
            }
            curParent = ModelUtils.getParent(curParent);
        }
        return null;
    }

    private static void invalidPrefixWarning(MApplicationElement container, String positionInList) {
        ArrayList values = new ArrayList();
        Arrays.asList(Position.values()).forEach(p -> {
            boolean bl = values.add(p.prefix);
        });
        String warning = MessageFormat.format("Position ''{0}'' defined in ''{1}'' is no not a valid list position. Valid list positions are {2}", positionInList, container.getElementId(), values);
        Platform.getLog(ModelUtils.class).warn(warning);
    }
}

