/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.impl;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.p2.updatesite.SiteFeature;
import org.eclipse.equinox.internal.p2.updatesite.SiteModel;
import org.eclipse.equinox.internal.p2.updatesite.UpdateSite;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.oomph.base.impl.ModelElementImpl;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.resources.ResourcesUtil;
import org.eclipse.oomph.targlets.ComponentDefinition;
import org.eclipse.oomph.targlets.SiteGenerator;
import org.eclipse.oomph.targlets.TargletFactory;
import org.eclipse.oomph.targlets.TargletPackage;
import org.eclipse.oomph.targlets.impl.ComponentDefGeneratorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteGeneratorImpl
extends ModelElementImpl
implements SiteGenerator {
    private static final IPath SITE_XML_PATH = new Path("site.xml");

    protected SiteGeneratorImpl() {
    }

    protected EClass eStaticClass() {
        return TargletPackage.Literals.SITE_GENERATOR;
    }

    @Override
    public void generateIUs(final IProject project, final String qualifierReplacement, Map<String, Version> iuVersions, final EList<IInstallableUnit> result) throws Exception {
        final IPath path = this.getPath();
        ResourcesUtil.runWithFile((IProject)project, (IPath)path, (ResourcesUtil.RunnableWithFile)new ResourcesUtil.RunnableWithFile(){

            public void run(File projectFolder, File file) throws Exception {
                Version version;
                String id;
                IProvisioningAgent provisioningAgent = P2Util.getCurrentProvisioningAgent();
                Transport transport = (Transport)provisioningAgent.getService(Transport.SERVICE_NAME);
                URI location = new File(projectFolder, path.toString()).toURI();
                UpdateSite updateSite = SiteGeneratorImpl.this.loadFile(location, transport);
                SiteModel site = updateSite.getSite();
                String name = project.getDescription().getName();
                ComponentDefinition componentDefinition = TargletFactory.eINSTANCE.createComponentDefinition();
                componentDefinition.setID(name);
                componentDefinition.setVersion(Version.createOSGi((int)1, (int)0, (int)0, (String)"qualifier"));
                EList<Requirement> requirements = componentDefinition.getRequirements();
                SiteFeature[] siteFeatureArray = site.getFeatures();
                int n = siteFeatureArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SiteFeature feature = siteFeatureArray[n2];
                    id = String.valueOf(feature.getFeatureIdentifier()) + ".feature.group";
                    version = Version.create((String)feature.getFeatureVersion());
                    requirements.add((Object)P2Factory.eINSTANCE.createRequirement(id, version, true));
                    ++n2;
                }
                siteFeatureArray = site.getBundles();
                n = siteFeatureArray.length;
                n2 = 0;
                while (n2 < n) {
                    SiteFeature bundle = siteFeatureArray[n2];
                    id = bundle.getBundleIdentifier();
                    version = Version.create((String)bundle.getBundleVersion());
                    requirements.add((Object)P2Factory.eINSTANCE.createRequirement(id, version, true));
                    ++n2;
                }
                IInstallableUnit iu = ComponentDefGeneratorImpl.generateIU(componentDefinition, qualifierReplacement);
                result.add((Object)iu);
            }
        });
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                try {
                    this.generateIUs((IProject)arguments.get(0), (String)arguments.get(1), (Map)arguments.get(2), (EList<IInstallableUnit>)((EList)arguments.get(3)));
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    protected IPath getPath() {
        return SITE_XML_PATH;
    }

    protected UpdateSite loadFile(URI location, Transport transport) throws ProvisionException {
        return UpdateSite.load((URI)location, (Transport)transport, (IProgressMonitor)new NullProgressMonitor());
    }
}

