/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.workingsets.presentation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.workingsets.WorkingSet;
import org.eclipse.oomph.workingsets.WorkingSetGroup;
import org.eclipse.oomph.workingsets.WorkingSetsFactory;
import org.eclipse.oomph.workingsets.presentation.WorkingSetsEditorPlugin;
import org.eclipse.oomph.workingsets.provider.WorkingSetsEditPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.model.IWorkbenchAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingSetsActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IAction showPropertiesViewAction = new Action(WorkingSetsEditorPlugin.INSTANCE.getString("_UI_ShowPropertiesView_menu_item")){

        public void run() {
            try {
                WorkingSetsActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                WorkingSetsEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };
    protected IAction refreshViewerAction = new Action(WorkingSetsEditorPlugin.INSTANCE.getString("_UI_RefreshViewer_menu_item")){

        public boolean isEnabled() {
            return WorkingSetsActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (WorkingSetsActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)WorkingSetsActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };
    protected Collection<IAction> createChildActions;
    protected IMenuManager createChildMenuManager;
    protected Collection<IAction> createSiblingActions;
    protected IMenuManager createSiblingMenuManager;

    public WorkingSetsActionBarContributor() {
        super(1);
        this.loadResourceAction = new LoadResourceAction();
        this.validateAction = new ValidateAction();
        this.liveValidationAction = new DiagnosticDecorator.LiveValidator.LiveValidationAction(WorkingSetsEditorPlugin.getPlugin().getDialogSettings());
        this.controlAction = new ControlAction();
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("workingsets-settings"));
        toolBarManager.add((IContributionItem)new Separator("workingsets-additions"));
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        MenuManager submenuManager = new MenuManager(WorkingSetsEditorPlugin.INSTANCE.getString("_UI_WorkingSetsEditor_menu"), "org.eclipse.oomph.workingsetsMenuID");
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(WorkingSetsEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.createSiblingMenuManager = new MenuManager(WorkingSetsEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
        this.addGlobalActions((IMenuManager)submenuManager);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        Collection newChildDescriptors = null;
        Collection newSiblingDescriptors = null;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
            newSiblingDescriptors = domain.getNewChildDescriptors(null, object);
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, selection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
        if (this.createSiblingMenuManager != null) {
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            this.createSiblingMenuManager.update(true);
        }
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateChildAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateSiblingAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection<? extends IAction> actions) {
        if (actions != null) {
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                IContributionItem contributionItem = items[i];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++i;
            }
        }
    }

    public void menuAboutToShowGen(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        MenuManager submenuManager = null;
        submenuManager = new MenuManager(WorkingSetsEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        submenuManager = new MenuManager(WorkingSetsEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        this.menuAboutToShowGen(menuManager);
        menuManager.insertBefore("ui-actions", (IAction)new Action(){

            public String getText() {
                return "Preview...";
            }

            public void run() {
                PreviewDialog dialog = new PreviewDialog(WorkingSetsActionBarContributor.this.activeEditorPart.getSite().getShell(), WorkingSetsActionBarContributor.this.activeEditorPart);
                dialog.open();
            }
        });
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.refreshViewerAction);
        super.addGlobalActions(menuManager);
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PreviewDialog
    extends Dialog {
        protected TreeViewer tree;
        private IEditorPart activeEditorPart;
        protected Input input = new Input();
        private ISelectionListener selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                PreviewDialog.this.selectionChanged(part, selection);
            }
        };
        private IWorkbenchWindow workbenchWindow;
        private CommandStackListener commandStackListener = new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                PreviewDialog.this.commandStackChanged(event);
            }
        };

        public PreviewDialog(Shell parentShell, IEditorPart activeEditorPart) {
            super(parentShell);
            this.setActiveEditorPart(activeEditorPart);
            this.setShellStyle(this.getShellStyle() ^ 0x10000 | 0x10 | 0x400 | 0x80);
            this.setBlockOnOpen(false);
            this.workbenchWindow = activeEditorPart.getEditorSite().getWorkbenchWindow();
            ISelectionService selectionService = this.workbenchWindow.getSelectionService();
            selectionService.addPostSelectionListener(this.selectionListener);
        }

        protected void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                HashSet<ItemProvider> selectedObjects = new HashSet<ItemProvider>();
                Object[] objectArray = ((IStructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project;
                    Object value = objectArray[n2];
                    if (value instanceof EObject) {
                        EObject eObject = (EObject)value;
                        while (eObject != null) {
                            for (WorkingSetPresentation workingSet : this.input.getWorkingSets()) {
                                if (eObject != workingSet.getWorkingSet()) continue;
                                selectedObjects.add(workingSet);
                            }
                            eObject = eObject.eContainer();
                        }
                    }
                    if (value instanceof IAdaptable && (project = (IProject)((IAdaptable)value).getAdapter(IProject.class)) != null) {
                        for (WorkingSetPresentation workingSet : this.input.getWorkingSets()) {
                            for (ProjectPresentation p : workingSet.getProjects()) {
                                if (!project.equals((Object)p.getProject())) continue;
                                selectedObjects.add(p);
                            }
                        }
                    }
                    ++n2;
                }
                if (!selectedObjects.isEmpty()) {
                    this.tree.setSelection((ISelection)new StructuredSelection(new ArrayList(selectedObjects)));
                }
            }
        }

        protected void commandStackChanged(EventObject event) {
            this.reconcile();
            this.tree.expandAll();
        }

        public boolean close() {
            this.setActiveEditorPart(null);
            ISelectionService selectionService = this.workbenchWindow.getSelectionService();
            selectionService.removePostSelectionListener(this.selectionListener);
            return super.close();
        }

        public void setActiveEditorPart(IEditorPart activeEditorPart) {
            if (this.activeEditorPart != null) {
                ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain().getCommandStack().removeCommandStackListener(this.commandStackListener);
            }
            this.activeEditorPart = activeEditorPart;
            if (activeEditorPart != null) {
                ((IEditingDomainProvider)activeEditorPart).getEditingDomain().getCommandStack().addCommandStackListener(this.commandStackListener);
            }
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText("Working Sets Preview");
            this.tree = new TreeViewer(parent);
            this.reconcile();
            this.tree.setInput((Object)this.input);
            this.tree.expandAll();
            GridLayout layout = new GridLayout();
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            Tree treeControl = this.tree.getTree();
            treeControl.setLayout((Layout)layout);
            GridData layoutData = new GridData(1808);
            layoutData.heightHint = 800;
            layoutData.widthHint = 400;
            treeControl.setLayoutData((Object)layoutData);
            PreviewDialog.applyDialogFont((Control)treeControl);
            return treeControl;
        }

        protected void reconcile() {
            EList children = this.input.getChildren();
            children.clear();
            AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            this.tree.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(editingDomain.getAdapterFactory()));
            DecoratingColumLabelProvider labelProvider = new DecoratingColumLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider(editingDomain.getAdapterFactory()), (ILabelDecorator)new DiagnosticDecorator((EditingDomain)editingDomain, (StructuredViewer)this.tree, WorkingSetsEditorPlugin.getPlugin().getDialogSettings()));
            this.tree.setLabelProvider((IBaseLabelProvider)labelProvider);
            WorkingSet otherProjectsWorkingSet = WorkingSetsFactory.eINSTANCE.createWorkingSet();
            otherProjectsWorkingSet.setName("Other Projects");
            WorkingSetPresentation otherProjects = new WorkingSetPresentation(otherProjectsWorkingSet);
            children.add((Object)otherProjects);
            LinkedHashSet<IProject> projects = new LinkedHashSet<IProject>(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()));
            LinkedHashSet<IProject> unmatchedProjects = new LinkedHashSet<IProject>(projects);
            for (WorkingSet workingSet : this.getWorkingSets()) {
                WorkingSetPresentation child = new WorkingSetPresentation(workingSet);
                EList contents = child.getChildren();
                for (IProject project : projects) {
                    if (project.isHidden()) {
                        unmatchedProjects.remove(project);
                        continue;
                    }
                    if (!workingSet.matches((IResource)project)) continue;
                    ProjectPresentation childProject = new ProjectPresentation(project);
                    contents.add((Object)childProject);
                    unmatchedProjects.remove(project);
                }
                children.add((Object)child);
            }
            if (!unmatchedProjects.isEmpty()) {
                EList contents = otherProjects.getChildren();
                for (IProject project : unmatchedProjects) {
                    ProjectPresentation childProject = new ProjectPresentation(project);
                    contents.add((Object)childProject);
                }
            }
        }

        protected List<WorkingSet> getWorkingSets() {
            EditingDomain editingDomain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            Resource resource = (Resource)editingDomain.getResourceSet().getResources().get(0);
            WorkingSetGroup workingSetGroup = (WorkingSetGroup)resource.getContents().get(0);
            return workingSetGroup.getWorkingSets();
        }

        protected Control createButtonBar(Composite parent) {
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class Input
        extends ItemProvider {
            protected Input() {
            }

            public EList<WorkingSetPresentation> getWorkingSets() {
                EList result = this.getChildren();
                return result;
            }
        }

        protected static class ProjectPresentation
        extends ItemProvider {
            private IProject project;

            public ProjectPresentation(IProject project) {
                super(project.getName(), (Object)ExtendedImageRegistry.INSTANCE.getImage((Object)((IWorkbenchAdapter)project.getAdapter(IWorkbenchAdapter.class)).getImageDescriptor((Object)project)));
                this.project = project;
            }

            public IProject getProject() {
                return this.project;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class WorkingSetPresentation
        extends ItemProvider {
            private WorkingSet workingSet;

            public WorkingSetPresentation(WorkingSet workingSet) {
                super(workingSet.getName(), WorkingSetsEditPlugin.INSTANCE.getImage("full/obj16/WorkingSet"));
                this.workingSet = workingSet;
            }

            public EList<ProjectPresentation> getProjects() {
                EList result = this.getChildren();
                return result;
            }

            public WorkingSet getWorkingSet() {
                return this.workingSet;
            }
        }
    }
}

