/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.ui.dialogs;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.oomph.internal.version.IVersionBuilderArguments;
import org.eclipse.oomph.internal.version.VersionBuilderArguments;
import org.eclipse.oomph.version.ui.dialogs.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConfigurationDialog
extends TitleAreaDialog
implements IVersionBuilderArguments {
    private VersionBuilderArguments values;
    private Text releasePathText;
    private Button ignoreMalformedVersionsButton;
    private Button ignoreFeatureNatureButton;
    private Button ignoreSchemaBuilderButton;
    private Button ignoreDebugOptionsButton;
    private Button ignoreAutomaticModuleNameButton;
    private Button ignoreMissingDependencyRangesButton;
    private Button ignoreLaxLowerBoundDependencyButton;
    private Button ignoreMissingExportVersionsButton;
    private Button ignoreFeatureContentChangesButton;
    private Button ignoreFeatureContentRedundancyButton;
    private Button ignoreMissingNatureButton;
    private Button checkFeatureClosureCompletenessButton;
    private Button checkFeatureClosureContentButton;
    private Button checkMavenPomButton;

    public ConfigurationDialog(Shell parentShell, VersionBuilderArguments defaults) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.values = new VersionBuilderArguments((Map)defaults);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(Messages.ConfigurationDialog_title);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ConfigurationDialog_title);
        this.setMessage(Messages.ConfigurationDialog_message);
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        new Label(composite, 0).setText(String.valueOf(Messages.ConfigurationDialog_pathLabel) + ' ');
        this.releasePathText = new Text(composite, 2048);
        this.releasePathText.setLayoutData((Object)new GridData(768));
        String releasePath = this.values.getReleasePath();
        if (releasePath != null) {
            this.releasePathText.setText(releasePath);
        }
        this.releasePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigurationDialog.this.validate();
            }
        });
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationDialog.this.validate();
            }
        };
        this.ignoreMalformedVersionsButton = new Button(composite, 32);
        this.ignoreMalformedVersionsButton.setText(Messages.ConfigurationDialog_ignoreMalformedVersionsButton_text);
        this.ignoreMalformedVersionsButton.setSelection(this.values.isIgnoreMalformedVersions());
        this.ignoreMalformedVersionsButton.addSelectionListener((SelectionListener)buttonListener);
        this.ignoreFeatureNatureButton = new Button(composite, 32);
        this.ignoreFeatureNatureButton.setText(Messages.ConfigurationDialog_ignoreFeatureNatureButton_text);
        this.ignoreFeatureNatureButton.setSelection(this.values.isIgnoreFeatureNature());
        this.ignoreFeatureNatureButton.addSelectionListener((SelectionListener)buttonListener);
        this.ignoreSchemaBuilderButton = new Button(composite, 32);
        this.ignoreSchemaBuilderButton.setText(Messages.ConfigurationDialog_ignoreSchemaBuilderButton_text);
        this.ignoreSchemaBuilderButton.setSelection(this.values.isIgnoreSchemaBuilder());
        this.ignoreSchemaBuilderButton.addSelectionListener((SelectionListener)buttonListener);
        this.ignoreDebugOptionsButton = new Button(composite, 32);
        this.ignoreDebugOptionsButton.setText(Messages.ConfigurationDialog_ignoreDebugOptionsButton_text);
        this.ignoreDebugOptionsButton.setSelection(this.values.isIgnoreDebugOptions());
        this.ignoreDebugOptionsButton.addSelectionListener((SelectionListener)buttonListener);
        this.ignoreAutomaticModuleNameButton = new Button(composite, 32);
        this.ignoreAutomaticModuleNameButton.setText(Messages.ConfigurationDialog_ignoreAutomaticModuleNameButton_text);
        this.ignoreAutomaticModuleNameButton.setSelection(this.values.isIgnoreAutomaticModuleName());
        this.ignoreAutomaticModuleNameButton.addSelectionListener((SelectionListener)buttonListener);
        this.ignoreMissingDependencyRangesButton = new Button(composite, 32);
        this.ignoreMissingDependencyRangesButton.setText(Messages.ConfigurationDialog_ignoreMissingDependencyRangesButton_text);
        this.ignoreMissingDependencyRangesButton.setSelection(this.values.isIgnoreMissingDependencyRanges());
        this.ignoreMissingDependencyRangesButton.addSelectionListener((SelectionListener)buttonListener);
        this.ignoreLaxLowerBoundDependencyButton = new Button(composite, 32);
        this.ignoreLaxLowerBoundDependencyButton.setText(Messages.ConfigurationDialog_ignoreLaxLowerBoundDependencyButton_text);
        this.ignoreLaxLowerBoundDependencyButton.setSelection(this.values.isIgnoreLaxLowerBoundDependencyVersions());
        this.ignoreLaxLowerBoundDependencyButton.addSelectionListener((SelectionListener)buttonListener);
        this.ignoreMissingExportVersionsButton = new Button(composite, 32);
        this.ignoreMissingExportVersionsButton.setText(Messages.ConfigurationDialog_ignoreMissingExportVersionsButton_text);
        this.ignoreMissingExportVersionsButton.setSelection(this.values.isIgnoreMissingExportVersions());
        this.ignoreMissingExportVersionsButton.addSelectionListener((SelectionListener)buttonListener);
        this.ignoreFeatureContentChangesButton = new Button(composite, 32);
        this.ignoreFeatureContentChangesButton.setText(Messages.ConfigurationDialog_ignoreFeatureContentChangesButton_text);
        this.ignoreFeatureContentChangesButton.setSelection(this.values.isIgnoreFeatureContentChanges());
        this.ignoreFeatureContentChangesButton.addSelectionListener((SelectionListener)buttonListener);
        this.ignoreFeatureContentRedundancyButton = new Button(composite, 32);
        this.ignoreFeatureContentRedundancyButton.setText(Messages.ConfigurationDialog_ignoreFeatureContentRedundancyButton_text);
        this.ignoreFeatureContentRedundancyButton.setSelection(this.values.isIgnoreFeatureContentRedundancy());
        this.ignoreFeatureContentRedundancyButton.addSelectionListener((SelectionListener)buttonListener);
        this.ignoreMissingNatureButton = new Button(composite, 32);
        this.ignoreMissingNatureButton.setText(Messages.ConfigurationDialog_IgnoreMissingNature);
        this.ignoreMissingNatureButton.setSelection(this.values.isIgnoreMissingVersionNature());
        this.ignoreMissingNatureButton.addSelectionListener((SelectionListener)buttonListener);
        this.checkFeatureClosureCompletenessButton = new Button(composite, 32);
        this.checkFeatureClosureCompletenessButton.setText(Messages.ConfigurationDialog_checkFeatureClosureCompletenessButton_text);
        this.checkFeatureClosureCompletenessButton.setSelection(this.values.isCheckFeatureClosureCompleteness());
        this.checkFeatureClosureCompletenessButton.addSelectionListener((SelectionListener)buttonListener);
        this.checkFeatureClosureContentButton = new Button(composite, 32);
        this.checkFeatureClosureContentButton.setText(Messages.ConfigurationDialog_checkFeatureClosureContentButton_text);
        this.checkFeatureClosureContentButton.setSelection(this.values.isCheckFeatureClosureContent());
        this.checkFeatureClosureContentButton.addSelectionListener((SelectionListener)buttonListener);
        this.checkMavenPomButton = new Button(composite, 32);
        this.checkMavenPomButton.setText(Messages.ConfigurationDialog_checkMavenPomButton_text);
        this.checkMavenPomButton.setSelection(this.values.isCheckMavenPom());
        this.checkMavenPomButton.addSelectionListener((SelectionListener)buttonListener);
        this.validate();
        return dialogArea;
    }

    protected void validate() {
        if (this.releasePathText.getText().trim().length() == 0) {
            this.setErrorMessage(Messages.ConfigurationDialog_emptyPathToSpecFile);
            return;
        }
        boolean redundancyCheck = !this.ignoreFeatureContentRedundancyButton.getSelection();
        boolean completenessCheck = this.checkFeatureClosureCompletenessButton.getSelection();
        if (redundancyCheck && completenessCheck) {
            this.setErrorMessage(Messages.ConfigurationDialog_error_cantDoRedundancyAndCompletenessChecksAtSameTime);
            return;
        }
        this.setErrorMessage(null);
    }

    protected void okPressed() {
        this.values.setReleasePath(this.releasePathText.getText());
        this.values.setIgnoreMalformedVersions(this.ignoreMalformedVersionsButton.getSelection());
        this.values.setIgnoreFeatureNature(this.ignoreFeatureNatureButton.getSelection());
        this.values.setIgnoreSchemaBuilder(this.ignoreSchemaBuilderButton.getSelection());
        this.values.setIgnoreDebugOptions(this.ignoreDebugOptionsButton.getSelection());
        this.values.setIgnoreAutomaticModuleName(this.ignoreAutomaticModuleNameButton.getSelection());
        this.values.setIgnoreMissingDependencyRanges(this.ignoreMissingDependencyRangesButton.getSelection());
        this.values.setIgnoreLaxLowerBoundDependencyVersions(this.ignoreLaxLowerBoundDependencyButton.getSelection());
        this.values.setIgnoreMissingExportVersions(this.ignoreMissingExportVersionsButton.getSelection());
        this.values.setIgnoreFeatureContentChanges(this.ignoreFeatureContentChangesButton.getSelection());
        this.values.setIgnoreFeatureContentRedundancy(this.ignoreFeatureContentRedundancyButton.getSelection());
        this.values.setIgnoreMissingVersionNature(this.ignoreMissingNatureButton.getSelection());
        this.values.setCheckFeatureClosureCompleteness(this.checkFeatureClosureCompletenessButton.getSelection());
        this.values.setCheckFeatureClosureContent(this.checkFeatureClosureContentButton.getSelection());
        this.values.setCheckMavenPom(this.checkMavenPomButton.getSelection());
        super.okPressed();
    }

    public String getReleasePath() {
        return this.values.getReleasePath();
    }

    public String getValidatorClassName() {
        return this.values.getValidatorClassName();
    }

    public boolean isIgnoreMalformedVersions() {
        return this.values.isIgnoreMalformedVersions();
    }

    public boolean isIgnoreFeatureNature() {
        return this.values.isIgnoreFeatureNature();
    }

    public boolean isIgnoreSchemaBuilder() {
        return this.values.isIgnoreSchemaBuilder();
    }

    public boolean isIgnoreDebugOptions() {
        return this.values.isIgnoreDebugOptions();
    }

    public boolean isIgnoreAutomaticModuleName() {
        return this.values.isIgnoreAutomaticModuleName();
    }

    public boolean isIgnoreMissingDependencyRanges() {
        return this.values.isIgnoreMissingDependencyRanges();
    }

    public boolean isIgnoreLaxLowerBoundDependencyVersions() {
        return this.values.isIgnoreLaxLowerBoundDependencyVersions();
    }

    public boolean isIgnoreMissingExportVersions() {
        return this.values.isIgnoreMissingExportVersions();
    }

    public boolean isIgnoreFeatureContentChanges() {
        return this.values.isIgnoreFeatureContentChanges();
    }

    public boolean isIgnoreFeatureContentRedundancy() {
        return this.values.isIgnoreFeatureContentRedundancy();
    }

    public boolean isIgnoreMissingVersionNature() {
        return this.values.isIgnoreMissingVersionNature();
    }

    public boolean isCheckFeatureClosureCompleteness() {
        return this.values.isCheckFeatureClosureCompleteness();
    }

    public boolean isCheckFeatureClosureContent() {
        return this.values.isCheckFeatureClosureContent();
    }

    public boolean isCheckMavenPom() {
        return this.values.isCheckMavenPom();
    }

    public void applyTo(IProject project) throws CoreException {
        this.values.applyTo(project);
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public String get(Object key) {
        return (String)this.values.get(key);
    }

    public boolean containsKey(Object key) {
        return this.values.containsKey(key);
    }

    public String put(String key, String value) {
        return (String)this.values.put((Object)key, (Object)value);
    }

    public void putAll(Map<? extends String, ? extends String> m) {
        this.values.putAll(m);
    }

    public String remove(Object key) {
        return (String)this.values.remove(key);
    }

    public void clear() {
        this.values.clear();
    }

    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    public Set<String> keySet() {
        return this.values.keySet();
    }

    public Collection<String> values() {
        return this.values.values();
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.values.entrySet();
    }

    public boolean equals(Object o) {
        return this.values.equals(o);
    }

    public int hashCode() {
        return this.values.hashCode();
    }
}

