/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.viewers.CertificateLabelProvider;
import org.eclipse.equinox.internal.provisional.security.ui.X500PrincipalHelper;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.spi.PGPPublicKeyService;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.widgets.ButtonFactory;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.jface.widgets.TableFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class TrustCertificateDialog
extends SelectionDialog {
    private static final String EXPORT_FILTER_PATH = "exportFilterPath";
    private CheckboxTableViewer certificateViewer;
    private TreeViewer certificateChainViewer;
    private TableViewer artifactViewer;
    private Button detailsButton;
    private Button exportButton;
    private boolean rememberSelectedSigners = true;
    private boolean trustAlways;
    private final Map<TreeNode, List<IArtifactKey>> artifactMap = new LinkedHashMap<TreeNode, List<IArtifactKey>>();
    private final Map<PGPPublicKey, Date> revocationMap = new LinkedHashMap<PGPPublicKey, Date>();

    public TrustCertificateDialog(Shell parentShell, Object input) {
        super(parentShell);
        this.setShellStyle(0x4C70 | TrustCertificateDialog.getDefaultOrientation());
        if (input instanceof TreeNode[]) {
            this.init(null, (TreeNode[])input);
        }
        this.setTitle(ProvUIMessages.TrustCertificateDialog_Title);
        boolean unsignedContent = this.artifactMap.keySet().stream().map(TreeNode::getValue).anyMatch(Objects::isNull);
        boolean pgpContent = TrustCertificateDialog.containsInstance(input, PGPPublicKey.class);
        boolean revokedPGPContent = pgpContent && !this.revocationMap.isEmpty();
        boolean certifcateContent = TrustCertificateDialog.containsInstance(input, Certificate.class);
        ArrayList<String> messages = new ArrayList<String>();
        if (certifcateContent || pgpContent) {
            messages.add(ProvUIMessages.TrustCertificateDialog_Message);
        }
        if (unsignedContent) {
            messages.add(ProvUIMessages.TrustCertificateDialog_MessageUnsigned);
        }
        if (revokedPGPContent) {
            messages.add(ProvUIMessages.TrustCertificateDialog_MessageRevoked);
        }
        if (certifcateContent || pgpContent) {
            messages.add(ProvUIMessages.TrustCertificateDialog_MessageNameWarning);
        }
        if (pgpContent) {
            messages.add(ProvUIMessages.TrustCertificateDialog_MessagePGP);
        }
        this.setMessage(String.join((CharSequence)"  ", messages));
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parentShell, "org.eclipse.equinox.p2.ui.trust_dialog_context");
        }
    }

    private void init(TreeNode parent, TreeNode[] treeNodes) {
        TreeNode[] treeNodeArray = treeNodes;
        int n = treeNodes.length;
        int n2 = 0;
        while (n2 < n) {
            TreeNode[] children;
            PGPPublicKey pgp;
            Date revocation;
            TreeNode node = treeNodeArray[n2];
            IArtifactKey[] associatedArtifacts = TrustCertificateDialog.getInstance(node, IArtifactKey[].class);
            if (associatedArtifacts != null || parent == null) {
                this.artifactMap.put(node, associatedArtifacts == null ? List.of() : Arrays.asList(associatedArtifacts));
            }
            if ((revocation = TrustCertificateDialog.getInstance(node, Date.class)) != null && (pgp = TrustCertificateDialog.getInstance(node, PGPPublicKey.class)) != null) {
                this.revocationMap.put(pgp, revocation);
            }
            if ((children = node.getChildren()) != null) {
                this.init(node, children);
            }
            ++n2;
        }
    }

    public boolean isRememberSelectedSigners() {
        return this.rememberSelectedSigners;
    }

    public boolean isTrustAlways() {
        return this.trustAlways;
    }

    protected Label createMessageArea(Composite composite) {
        GridData data = new GridData(4, 4, true, false);
        data.widthHint = this.convertWidthInCharsToPixels(120);
        LabelFactory factory = (LabelFactory)((LabelFactory)WidgetFactory.label((int)64).font(composite.getFont())).layoutData((Object)data);
        if (this.getMessage() != null) {
            factory.text(this.getMessage());
        }
        return (Label)factory.create((Widget)composite);
    }

    protected Control createDialogArea(Composite parent) {
        boolean containsCertificates;
        Composite mainComposite = (Composite)super.createDialogArea(parent);
        Dialog.applyDialogFont((Control)mainComposite);
        this.initializeDialogUnits((Control)mainComposite);
        this.createMessageArea(mainComposite);
        SashForm sashForm = new SashForm(mainComposite, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createCertificateViewerArea(this.createSashFormArea(sashForm));
        boolean bl = containsCertificates = TrustCertificateDialog.containsInstance(this.artifactMap.keySet(), PGPPublicKey.class) || TrustCertificateDialog.containsInstance(this.artifactMap.keySet(), Certificate.class);
        if (containsCertificates) {
            this.createCertficateChainViewerArea(this.createSashFormArea(sashForm));
        }
        Comparator comparator = Policy.getComparator();
        Set artifacts = this.artifactMap.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(() -> new TreeSet((a1, a2) -> {
            int result = comparator.compare(a1.getId(), a2.getId());
            if (result == 0 && (result = a1.getVersion().compareTo((Object)a2.getVersion())) == 0) {
                result = a1.getClassifier().compareTo(a2.getClassifier());
            }
            return result;
        })));
        if (!artifacts.isEmpty()) {
            this.crreateArtifactViewerArea(this.createSashFormArea(sashForm), artifacts);
        }
        Control[] children = sashForm.getChildren();
        int[] weights = new int[children.length];
        int i = 0;
        while (i < children.length) {
            weights[i] = children[i].computeSize((int)-1, (int)-1, (boolean)false).y;
            ++i;
        }
        sashForm.setWeights(weights);
        if (!this.getInitialElementSelections().isEmpty()) {
            this.checkInitialSelections();
        }
        if (!this.artifactMap.isEmpty()) {
            this.certificateViewer.setSelection((ISelection)new StructuredSelection((Object)this.artifactMap.keySet().iterator().next()));
        }
        return mainComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, ProvUIMessages.TrustCertificateDialog_AcceptSelectedButtonLabel, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateOkButton();
    }

    private void createButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new RowLayout());
        this.detailsButton = new Button(buttonComposite, 0);
        this.detailsButton.setText(ProvUIMessages.TrustCertificateDialog_Details);
        this.detailsButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                X509Certificate cert = TrustCertificateDialog.getInstance(TrustCertificateDialog.this.certificateChainViewer.getSelection(), X509Certificate.class);
                if (cert != null) {
                    CertificateLabelProvider.openDialog(TrustCertificateDialog.this.getShell(), cert);
                }
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        this.exportButton = new Button(buttonComposite, 0);
        this.exportButton.setText(ProvUIMessages.TrustCertificateDialog_Export);
        this.exportButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ISelection selection = TrustCertificateDialog.this.certificateChainViewer.getSelection();
                X509Certificate cert = TrustCertificateDialog.getInstance(selection, X509Certificate.class);
                PGPPublicKey key = TrustCertificateDialog.getInstance(selection, PGPPublicKey.class);
                if (cert != null || key != null) {
                    FileDialog destination = new FileDialog(TrustCertificateDialog.this.exportButton.getShell(), 8192);
                    destination.setFilterPath(TrustCertificateDialog.this.getFilterPath(TrustCertificateDialog.EXPORT_FILTER_PATH));
                    destination.setText(ProvUIMessages.TrustCertificateDialog_ExportDialogTitle);
                    if (cert != null) {
                        destination.setFilterExtensions(new String[]{"*.der"});
                        destination.setFileName(cert.getSerialNumber().toString() + ".der");
                        String path = destination.open();
                        TrustCertificateDialog.this.setFilterPath(TrustCertificateDialog.EXPORT_FILTER_PATH, destination.getFilterPath());
                        if (path == null) {
                            return;
                        }
                        File destinationFile = new File(path);
                        try {
                            Throwable throwable = null;
                            Object var9_16 = null;
                            try (FileOutputStream output = new FileOutputStream(destinationFile);){
                                output.write(cert.getEncoded());
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException | CertificateEncodingException ex) {
                            ProvUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui", ex.getMessage(), (Throwable)ex));
                        }
                    } else {
                        destination.setFilterExtensions(new String[]{"*.asc"});
                        destination.setFileName(TrustCertificateDialog.userFriendlyFingerPrint(key) + ".asc");
                        String path = destination.open();
                        TrustCertificateDialog.this.setFilterPath(TrustCertificateDialog.EXPORT_FILTER_PATH, destination.getFilterPath());
                        if (path == null) {
                            return;
                        }
                        File destinationFile = new File(path);
                        try {
                            Throwable ex = null;
                            Object var9_18 = null;
                            try (ArmoredOutputStream output = new ArmoredOutputStream((OutputStream)new FileOutputStream(destinationFile));){
                                key.encode((OutputStream)output);
                            }
                            catch (Throwable throwable) {
                                if (ex == null) {
                                    ex = throwable;
                                } else if (ex != throwable) {
                                    ex.addSuppressed(throwable);
                                }
                                throw ex;
                            }
                        }
                        catch (IOException ex) {
                            ProvUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui", ex.getMessage(), (Throwable)ex));
                        }
                    }
                }
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
    }

    private Composite createSashFormArea(SashForm sashForm) {
        Composite composite = new Composite((Composite)sashForm, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void createCertificateViewerArea(Composite composite) {
        TableColumnLayout tableColumnLayout = new TableColumnLayout(true);
        Composite tableComposite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layoutData((Object)new GridData(4, 4, true, true))).layout((Layout)tableColumnLayout)).create((Widget)composite);
        Table table = (Table)((TableFactory)WidgetFactory.table((int)68386).headerVisible(true).linesVisible(true).font(composite.getFont())).create((Widget)tableComposite);
        this.certificateViewer = new CheckboxTableViewer(table);
        this.certificateViewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        GridData data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(Math.min(this.artifactMap.keySet().size() + 2, 6)) * 3 / 2;
        data.widthHint = this.convertWidthInCharsToPixels(120);
        tableComposite.setLayoutData((Object)data);
        TableViewerColumn typeColumn = this.createColumn((TableViewer)this.certificateViewer, ProvUIMessages.TrustCertificateDialog_ObjectType, new PGPOrX509ColumnLabelProvider(key -> "PGP", cert -> "x509", ProvUIMessages.TrustCertificateDialog_Unsigned), tableColumnLayout, 1);
        this.createColumn((TableViewer)this.certificateViewer, ProvUIMessages.TrustCertificateDialog_Id, new PGPOrX509ColumnLabelProvider(TrustCertificateDialog::userFriendlyFingerPrint, cert -> cert.getSerialNumber().toString(), ProvUIMessages.TrustCertificateDialog_NotApplicable), tableColumnLayout, 10);
        this.createColumn((TableViewer)this.certificateViewer, ProvUIMessages.TrustCertificateDialog_Name, new PGPOrX509ColumnLabelProvider(pgp -> {
            ArrayList users = new ArrayList();
            pgp.getUserIDs().forEachRemaining(users::add);
            return String.join((CharSequence)", ", users);
        }, x509 -> {
            X500PrincipalHelper principalHelper = new X500PrincipalHelper(x509.getSubjectX500Principal());
            return principalHelper.getCN() + "; " + principalHelper.getOU() + "; " + principalHelper.getO();
        }, ProvUIMessages.TrustCertificateDialog_Unknown), tableColumnLayout, 15);
        this.createColumn((TableViewer)this.certificateViewer, ProvUIMessages.TrustCertificateDialog_dates, new PGPOrX509ColumnLabelProvider(pgp -> {
            Date verifiedRevocationDate = this.revocationMap.get(pgp);
            if (verifiedRevocationDate != null) {
                return NLS.bind((String)ProvUIMessages.TrustCertificateDialog_revoked, (Object)verifiedRevocationDate);
            }
            if (pgp.getCreationTime().after(Date.from(Instant.now()))) {
                return NLS.bind((String)ProvUIMessages.TrustCertificateDialog_NotYetValidStartDate, (Object)pgp.getCreationTime());
            }
            long validSeconds = pgp.getValidSeconds();
            if (validSeconds == 0L) {
                return ProvUIMessages.TrustCertificateDialog_valid;
            }
            Instant expires = pgp.getCreationTime().toInstant().plus(validSeconds, ChronoUnit.SECONDS);
            return expires.isBefore(Instant.now()) ? NLS.bind((String)ProvUIMessages.TrustCertificateDialog_expiredSince, (Object)expires) : NLS.bind((String)ProvUIMessages.TrustCertificateDialog_validExpires, (Object)expires);
        }, x509 -> {
            try {
                x509.checkValidity();
                return ProvUIMessages.TrustCertificateDialog_valid;
            }
            catch (CertificateExpiredException certificateExpiredException) {
                return ProvUIMessages.TrustCertificateDialog_expired;
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                return ProvUIMessages.TrustCertificateDialog_notYetValid;
            }
        }, ProvUIMessages.TrustCertificateDialog_NotApplicable), tableColumnLayout, 10);
        this.createMenu((StructuredViewer)this.certificateViewer);
        this.addSelectionButtons(composite);
        this.certificateViewer.addDoubleClickListener(e -> {
            StructuredSelection selection = (StructuredSelection)e.getSelection();
            X509Certificate cert = TrustCertificateDialog.getInstance(selection, X509Certificate.class);
            if (cert != null) {
                CertificateLabelProvider.openDialog(this.getShell(), cert);
            }
        });
        this.certificateViewer.addSelectionChangedListener(e -> {
            if (this.certificateChainViewer != null) {
                TreeNode treeNode = TrustCertificateDialog.getInstance(e.getSelection(), TreeNode.class);
                if (treeNode != null) {
                    this.certificateChainViewer.setInput((Object)new TreeNode[]{treeNode});
                    this.certificateChainViewer.setSelection((ISelection)new StructuredSelection((Object)treeNode));
                } else {
                    this.certificateChainViewer.setInput((Object)new TreeNode[0]);
                }
            }
            this.updateOkButton();
        });
        this.certificateViewer.setInput(this.artifactMap.keySet().toArray(TreeNode[]::new));
        typeColumn.getColumn().pack();
    }

    private void createCertficateChainViewerArea(Composite composite) {
        this.certificateChainViewer = new TreeViewer(composite, 2816);
        GridData data = new GridData(1808);
        int treeSize = this.artifactMap.keySet().stream().map(TrustCertificateDialog::computeTreeSize).max(Integer::compareTo).orElse(0);
        data.heightHint = this.convertHeightInCharsToPixels(Math.min(treeSize, 5));
        data.widthHint = this.convertWidthInCharsToPixels(120);
        this.certificateChainViewer.getTree().setLayoutData((Object)data);
        this.certificateChainViewer.setAutoExpandLevel(3);
        this.certificateChainViewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        this.certificateChainViewer.setLabelProvider((IBaseLabelProvider)new CertificateLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof TreeNode) {
                    Object o = ((TreeNode)element).getValue();
                    if (o instanceof PGPPublicKey) {
                        PGPPublicKey key = (PGPPublicKey)o;
                        String userFriendlyFingerPrint = TrustCertificateDialog.userFriendlyFingerPrint(key);
                        ArrayList users = new ArrayList();
                        key.getUserIDs().forEachRemaining(users::add);
                        String userIDs = String.join((CharSequence)", ", users);
                        if (!userIDs.isEmpty()) {
                            return userFriendlyFingerPrint + " [" + userIDs + "]";
                        }
                        return userFriendlyFingerPrint;
                    }
                    if (o == null) {
                        return ProvUIMessages.TrustCertificateDialog_Unsigned;
                    }
                }
                return super.getText(element);
            }
        });
        this.certificateChainViewer.addSelectionChangedListener(event -> {
            ISelection selection = event.getSelection();
            boolean containsCertificate = TrustCertificateDialog.containsInstance(selection, X509Certificate.class);
            this.detailsButton.setEnabled(containsCertificate);
            this.exportButton.setEnabled(containsCertificate || TrustCertificateDialog.containsInstance(selection, PGPPublicKey.class));
        });
        this.createMenu((StructuredViewer)this.certificateChainViewer);
        this.createButtons(composite);
    }

    private void crreateArtifactViewerArea(Composite composite, Set<IArtifactKey> artifacts) {
        FontData[] fontDatas;
        TableColumnLayout tableColumnLayout = new TableColumnLayout(true);
        Composite tableComposite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layoutData((Object)new GridData(4, 4, true, true))).layout((Layout)tableColumnLayout)).create((Widget)composite);
        Table table = (Table)((TableFactory)WidgetFactory.table((int)68354).headerVisible(true).linesVisible(true).font(composite.getFont())).create((Widget)tableComposite);
        this.artifactViewer = new TableViewer(table);
        this.artifactViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        GridData data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(Math.min(artifacts.size() + 1, 10)) * 3 / 2;
        data.widthHint = this.convertWidthInCharsToPixels(120);
        tableComposite.setLayoutData((Object)data);
        Font font = table.getFont();
        FontData[] fontDataArray = fontDatas = font.getFontData();
        int n = fontDatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            fontData.setStyle(fontData.getStyle() | 1);
            ++n2;
        }
        Font boldFont = new Font((Device)table.getDisplay(), fontDatas);
        composite.addDisposeListener(e -> boldFont.dispose());
        Function<IArtifactKey, Font> fontProvider = e -> {
            Object[] objectArray = this.certificateViewer.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                List<IArtifactKey> list = this.artifactMap.get(object);
                if (list != null && list.contains(e)) {
                    return boldFont;
                }
                ++n2;
            }
            return null;
        };
        this.certificateViewer.addCheckStateListener(e -> this.artifactViewer.refresh(true));
        this.artifactViewer.addPostSelectionChangedListener(e -> {
            if (table.isFocusControl()) {
                List selection = e.getStructuredSelection().toList();
                ArrayList<TreeNode> newSelection = new ArrayList<TreeNode>();
                block0: for (Map.Entry<TreeNode, List<IArtifactKey>> entry : this.artifactMap.entrySet()) {
                    List<IArtifactKey> value = entry.getValue();
                    if (value == null) continue;
                    for (IArtifactKey key : value) {
                        if (!selection.contains(key)) continue;
                        newSelection.add(entry.getKey());
                        continue block0;
                    }
                }
                this.certificateViewer.setSelection((ISelection)new StructuredSelection(newSelection), true);
            }
        });
        this.certificateViewer.addPostSelectionChangedListener(e -> {
            if (!table.isFocusControl()) {
                LinkedHashSet<IArtifactKey> associatedArtifacts = new LinkedHashSet<IArtifactKey>();
                for (Object object : e.getStructuredSelection()) {
                    List<IArtifactKey> list = this.artifactMap.get(object);
                    if (list == null) continue;
                    associatedArtifacts.addAll(list);
                }
                this.artifactViewer.setSelection((ISelection)new StructuredSelection(associatedArtifacts.toArray()), true);
                LinkedHashSet newInput = new LinkedHashSet(artifacts);
                newInput.retainAll(associatedArtifacts);
                newInput.addAll(artifacts);
                this.artifactViewer.setInput(newInput);
                this.artifactViewer.setSelection((ISelection)new StructuredSelection(associatedArtifacts.toArray()), true);
            }
        });
        TableViewerColumn classifierColumn = this.createColumn(this.artifactViewer, ProvUIMessages.TrustCertificateDialog_Classifier, new ArtifactLabelProvider(a -> a.getClassifier(), fontProvider), tableColumnLayout, 1);
        this.createColumn(this.artifactViewer, ProvUIMessages.TrustCertificateDialog_ArtifactId, new ArtifactLabelProvider(a -> a.getId(), fontProvider), tableColumnLayout, 10);
        this.createColumn(this.artifactViewer, ProvUIMessages.TrustCertificateDialog_Version, new ArtifactLabelProvider(a -> a.getVersion().toString(), fontProvider), tableColumnLayout, 10);
        this.artifactViewer.setInput(artifacts);
        classifierColumn.getColumn().pack();
    }

    private void createMenu(StructuredViewer viewer) {
        Control control = viewer.getControl();
        Menu menu = new Menu(control);
        control.setMenu(menu);
        MenuItem item = new MenuItem(menu, 8);
        item.setText(ProvUIMessages.TrustCertificateDialog_CopyFingerprint);
        item.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            PGPPublicKey key = TrustCertificateDialog.getInstance(viewer.getSelection(), PGPPublicKey.class);
            if (key != null) {
                Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
                clipboard.setContents(new Object[]{TrustCertificateDialog.userFriendlyFingerPrint(key)}, new Transfer[]{TextTransfer.getInstance()});
                clipboard.dispose();
            }
        }));
        viewer.addSelectionChangedListener(e -> item.setEnabled(TrustCertificateDialog.containsInstance(e.getSelection(), PGPPublicKey.class)));
    }

    private TableViewerColumn createColumn(TableViewer tableViewer, String text, ColumnLabelProvider labelProvider, TableColumnLayout tableColumnLayout, int columnWeight) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setText(text);
        column.setLabelProvider((CellLabelProvider)labelProvider);
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(columnWeight));
        return column;
    }

    private void checkInitialSelections() {
        Iterator itemsToCheck = this.getInitialElementSelections().iterator();
        while (itemsToCheck.hasNext()) {
            this.certificateViewer.setChecked(itemsToCheck.next(), true);
            if (this.artifactViewer == null) continue;
            this.artifactViewer.refresh(true);
        }
    }

    private void addSelectionButtons(Composite composite) {
        int horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        Composite buttonArea = new Composite(composite, 0);
        GridLayout buttonAreaLayout = new GridLayout();
        buttonAreaLayout.numColumns = 2;
        buttonAreaLayout.marginWidth = 0;
        buttonAreaLayout.horizontalSpacing = horizontalSpacing;
        buttonArea.setLayout((Layout)buttonAreaLayout);
        buttonArea.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite leftButtonArea = new Composite(buttonArea, 0);
        GridLayout leftButtonAreaLayout = new GridLayout();
        leftButtonAreaLayout.numColumns = 0;
        leftButtonAreaLayout.marginWidth = 0;
        leftButtonAreaLayout.horizontalSpacing = horizontalSpacing;
        leftButtonArea.setLayout((Layout)leftButtonAreaLayout);
        leftButtonArea.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        if (TrustCertificateDialog.containsInstance(this.artifactMap.keySet(), PGPPublicKey.class) || TrustCertificateDialog.containsInstance(this.artifactMap.keySet(), Certificate.class)) {
            Button rememberSelectionButton = this.createCheckButton(leftButtonArea, ProvUIMessages.TrustCertificateDialog_RememberSigners);
            rememberSelectionButton.setSelection(this.rememberSelectedSigners);
            rememberSelectionButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                this.rememberSelectedSigners = rememberSelectionButton.getSelection();
            }));
        }
        Button trustAlwaysButton = this.createCheckButton(leftButtonArea, ProvUIMessages.TrustCertificateDialog_AlwaysTrust);
        trustAlwaysButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (trustAlwaysButton.getSelection()) {
                MessageDialog messageDialog = new MessageDialog(this.getShell(), ProvUIMessages.TrustCertificateDialog_AlwaysTrustConfirmationTitle, null, ProvUIMessages.TrustCertificateDialog_AlwaysTrustConfirmationMessage, 3, new String[]{ProvUIMessages.TrustCertificateDialog_AlwaysTrustYes, ProvUIMessages.TrustCertificateDialog_AlwaysTrustNo}, 1){

                    public Image getImage() {
                        return this.getWarningImage();
                    }
                };
                int result = messageDialog.open();
                if (result != 0) {
                    trustAlwaysButton.setSelection(false);
                } else {
                    this.certificateViewer.setAllChecked(true);
                    if (this.artifactViewer != null) {
                        this.artifactViewer.refresh(true);
                    }
                    this.updateOkButton();
                }
            }
            this.trustAlways = trustAlwaysButton.getSelection();
        }));
        Composite rightButtonArea = new Composite(buttonArea, 0);
        GridLayout rightButtonAreaLayout = new GridLayout();
        rightButtonAreaLayout.numColumns = 0;
        rightButtonAreaLayout.marginWidth = 0;
        rightButtonAreaLayout.horizontalSpacing = horizontalSpacing;
        rightButtonArea.setLayout((Layout)rightButtonAreaLayout);
        rightButtonArea.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
        Button selectButton = this.createButton(rightButtonArea, 18, ProvUIMessages.TrustCertificateDialog_SelectAll, false);
        selectButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.certificateViewer.setAllChecked(true);
            if (this.artifactViewer != null) {
                this.artifactViewer.refresh(true);
            }
            this.updateOkButton();
        }));
        Button deselectButton = this.createButton(rightButtonArea, 19, ProvUIMessages.TrustCertificateDialog_DeselectAll, false);
        deselectButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.certificateViewer.setAllChecked(false);
            if (this.artifactViewer != null) {
                this.artifactViewer.refresh(true);
            }
            this.updateOkButton();
        }));
    }

    protected Button createCheckButton(Composite parent, String label) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = (Button)((ButtonFactory)WidgetFactory.button((int)32).text(label).font(JFaceResources.getDialogFont())).create((Widget)parent);
        this.setButtonLayoutData(button);
        return button;
    }

    private String getFilterPath(String key) {
        IDialogSettings dialogSettings = DialogSettings.getOrCreateSection((IDialogSettings)ProvUIActivator.getDefault().getDialogSettings(), (String)((Object)((Object)this)).getClass().getName());
        String filterPath = dialogSettings.get(key);
        if (filterPath == null) {
            filterPath = System.getProperty("user.home");
        }
        return filterPath;
    }

    private void setFilterPath(String key, String filterPath) {
        if (filterPath != null) {
            IDialogSettings dialogSettings = DialogSettings.getOrCreateSection((IDialogSettings)ProvUIActivator.getDefault().getDialogSettings(), (String)((Object)((Object)this)).getClass().getName());
            dialogSettings.put(key, filterPath);
        }
    }

    private void updateOkButton() {
        Button okButton = this.getOkButton();
        if (okButton != null) {
            this.certificateViewer.getCheckedElements();
            Object[] checkedElements = this.certificateViewer.getCheckedElements();
            Set artifacts = this.artifactMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            if (artifacts.isEmpty()) {
                okButton.setEnabled(checkedElements.length > 0);
            } else {
                Object[] objectArray = checkedElements;
                int n = checkedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object checkElement = objectArray[n2];
                    artifacts.removeAll((Collection)this.artifactMap.get(checkElement));
                    ++n2;
                }
                okButton.setEnabled(artifacts.isEmpty());
            }
        }
    }

    protected void okPressed() {
        MessageDialog messageDialog;
        if (!this.revocationMap.isEmpty() && (messageDialog = new MessageDialog(this.getShell(), ProvUIMessages.TrustCertificateDialogQuestionTrustRevokedKeyTitle, null, ProvUIMessages.TrustCertificateDialogQuestionTrustRevokedKeyQuestion, 3, new String[]{ProvUIMessages.TrustCertificateDialogQuestionTrustRevokedKeyAccept, ProvUIMessages.TrustCertificateDialogQuestionTrustRevokedKeyReject}, 1){

            public Image getImage() {
                return this.getWarningImage();
            }
        }).open() != 0) {
            return;
        }
        this.setResult(Arrays.asList(this.certificateViewer.getCheckedElements()));
        super.okPressed();
    }

    private static int computeTreeSize(TreeNode node) {
        int count = 1;
        TreeNode[] children = node.getChildren();
        if (children != null) {
            TreeNode[] treeNodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode child = treeNodeArray[n2];
                count += TrustCertificateDialog.computeTreeSize(child);
                ++n2;
            }
        }
        return count;
    }

    /*
     * WARNING - void declaration
     */
    private static <T> T getInstance(Object element, Class<T> type, Predicate<T> filter) {
        block8: {
            block9: {
                block7: {
                    if (!type.isInstance(element)) break block7;
                    if (filter == null || filter.test(type.cast(element))) {
                        return type.cast(element);
                    }
                    break block8;
                }
                if (!(element instanceof Iterable)) break block9;
                for (Object object2 : (Iterable)element) {
                    T instance = TrustCertificateDialog.getInstance(object2, type, filter);
                    if (instance == null) continue;
                    return instance;
                }
                break block8;
            }
            if (element instanceof TreeNode) {
                Object object = element;
                if (object instanceof IAdaptable) {
                    void adaptable;
                    IAdaptable object2 = (IAdaptable)object;
                    IAdaptable cfr_ignored_0 = (IAdaptable)object;
                    Object instance = adaptable.getAdapter(type);
                    if (instance != null) {
                        return (T)instance;
                    }
                }
                return TrustCertificateDialog.getInstance(((TreeNode)element).getValue(), type, filter);
            }
            if (!(element instanceof TreeNode[])) break block8;
            TreeNode[] treeNodeArray = (TreeNode[])element;
            int n = treeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode child = treeNodeArray[n2];
                T instance = TrustCertificateDialog.getInstance(child, type, filter);
                if (instance != null) {
                    return instance;
                }
                ++n2;
            }
        }
        return null;
    }

    private static <T> T getInstance(Object element, Class<T> type) {
        return TrustCertificateDialog.getInstance(element, type, null);
    }

    private static boolean containsInstance(Object element, Class<?> type) {
        return TrustCertificateDialog.getInstance(element, type) != null;
    }

    private static String userFriendlyFingerPrint(PGPPublicKey key) {
        if (key == null) {
            return null;
        }
        return PGPPublicKeyService.toHexFingerprint((PGPPublicKey)key);
    }

    private static class ArtifactLabelProvider
    extends ColumnLabelProvider {
        private Function<IArtifactKey, String> labelProvider;
        private Function<IArtifactKey, Font> fontProvider;

        public ArtifactLabelProvider(Function<IArtifactKey, String> labelProvider, Function<IArtifactKey, Font> fontProvider) {
            this.labelProvider = labelProvider;
            this.fontProvider = fontProvider;
        }

        public String getText(Object element) {
            return this.labelProvider.apply((IArtifactKey)element);
        }

        public Font getFont(Object element) {
            return this.fontProvider.apply((IArtifactKey)element);
        }
    }

    private static class PGPOrX509ColumnLabelProvider
    extends ColumnLabelProvider {
        private Function<PGPPublicKey, String> pgpMap;
        private Function<X509Certificate, String> x509map;
        private String unsignedValue;

        public PGPOrX509ColumnLabelProvider(Function<PGPPublicKey, String> pgpMap, Function<X509Certificate, String> x509map, String unsignedValue) {
            this.pgpMap = pgpMap;
            this.x509map = x509map;
            this.unsignedValue = unsignedValue;
        }

        public String getText(Object element) {
            if (element instanceof TreeNode) {
                element = ((TreeNode)element).getValue();
            }
            if (element instanceof PGPPublicKey) {
                return this.pgpMap.apply((PGPPublicKey)element);
            }
            if (element instanceof X509Certificate) {
                return this.x509map.apply((X509Certificate)element);
            }
            if (element == null) {
                return this.unsignedValue;
            }
            return super.getText(element);
        }
    }
}

