/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.viewers;

import org.eclipse.equinox.internal.p2.ui.ProvUIProvisioningListener;
import org.eclipse.equinox.internal.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.p2.ui.model.ProfileElement;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class StructuredViewerProvisioningListener
extends ProvUIProvisioningListener {
    StructuredViewer viewer;
    Display display;

    public StructuredViewerProvisioningListener(String name, StructuredViewer viewer, int eventTypes, ProvisioningOperationRunner runner) {
        super(name, eventTypes, runner);
        this.viewer = viewer;
        this.display = viewer.getControl().getDisplay();
    }

    @Override
    protected void repositoryAdded(RepositoryEvent event) {
        this.safeRefresh();
    }

    @Override
    protected void repositoryRemoved(RepositoryEvent event) {
        this.safeRefresh();
    }

    @Override
    protected void repositoryDiscovered(RepositoryEvent event) {
    }

    @Override
    protected void repositoryChanged(RepositoryEvent event) {
    }

    @Override
    protected void profileChanged(String profileId) {
        this.display.asyncExec(() -> {
            if (this.isClosing()) {
                return;
            }
            ProfileElement element = new ProfileElement(null, profileId);
            this.viewer.refresh((Object)element);
        });
    }

    @Override
    protected void profileAdded(String profileId) {
        this.safeRefresh();
    }

    @Override
    protected void profileRemoved(String profileId) {
        this.safeRefresh();
    }

    protected void safeRefresh() {
        if (Display.getCurrent() != null) {
            this.refreshViewer();
            return;
        }
        this.display.asyncExec(() -> {
            if (this.isClosing()) {
                return;
            }
            this.refreshViewer();
        });
    }

    @Override
    protected void refreshAll() {
        this.safeRefresh();
    }

    protected void refreshViewer() {
        this.viewer.refresh();
    }

    protected boolean isClosing() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench.isClosing()) {
            return true;
        }
        return this.viewer.getControl().isDisposed();
    }
}

