/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.location;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.eclipse.osgi.internal.location.Locker;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.util.NLS;

public class Locker_JavaNio
implements Locker {
    private final File lockFile;
    private final boolean debug;
    private FileLock fileLock;
    private RandomAccessFile raFile;

    public Locker_JavaNio(File lockFile, boolean debug) {
        this.lockFile = lockFile;
        this.debug = debug;
    }

    @Override
    public synchronized boolean lock() throws IOException {
        this.raFile = new RandomAccessFile(this.lockFile, "rw");
        try {
            try {
                this.fileLock = this.raFile.getChannel().tryLock(0L, 1L, false);
            }
            catch (IOException ioe) {
                if (this.debug) {
                    System.out.println(NLS.bind(Msg.location_cannotLock, this.lockFile));
                }
                String specificMessage = NLS.bind(Msg.location_cannotLockNIO, new Object[]{this.lockFile, ioe.getMessage(), "\"-Dosgi.locking=none\""});
                throw new IOException(specificMessage, ioe);
            }
            catch (OverlappingFileLockException e) {
                this.fileLock = null;
                if (this.fileLock != null) {
                    return true;
                }
                this.raFile.close();
                this.raFile = null;
            }
        }
        finally {
            if (this.fileLock != null) {
                return true;
            }
            this.raFile.close();
            this.raFile = null;
        }
        return false;
    }

    @Override
    public synchronized void release() {
        if (this.fileLock != null) {
            try {
                this.fileLock.release();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fileLock = null;
        }
        if (this.raFile != null) {
            try {
                this.raFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.raFile = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean isLocked() throws IOException {
        if (this.fileLock != null) {
            return true;
        }
        try {
            FileLock tempLock = null;
            try (RandomAccessFile temp = new RandomAccessFile(this.lockFile, "rw");){
                try {
                    tempLock = temp.getChannel().tryLock(0L, 1L, false);
                }
                catch (IOException ioe) {
                    if (this.debug) {
                        System.out.println(NLS.bind(Msg.location_cannotLock, this.lockFile));
                    }
                    String specificMessage = NLS.bind(Msg.location_cannotLockNIO, new Object[]{this.lockFile, ioe.getMessage(), "\"-Dosgi.locking=none\""});
                    throw new IOException(specificMessage);
                }
                if (tempLock == null) return true;
                tempLock.release();
                return false;
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }
}

