/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.progress.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.e4.ui.progress.internal.ContentProviderFactory;
import org.eclipse.e4.ui.progress.internal.DetailedProgressViewer;
import org.eclipse.e4.ui.progress.internal.FinishedJobs;
import org.eclipse.e4.ui.progress.internal.ProgressLabelProvider;
import org.eclipse.e4.ui.progress.internal.ProgressManager;
import org.eclipse.e4.ui.progress.internal.ProgressManagerUtil;
import org.eclipse.e4.ui.progress.internal.ProgressMessages;
import org.eclipse.e4.ui.progress.internal.Services;
import org.eclipse.e4.ui.progress.internal.legacy.PlatformUI;
import org.eclipse.e4.ui.progress.internal.legacy.Policy;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ProgressMonitorJobsDialog
extends ProgressMonitorDialog {
    private DetailedProgressViewer viewer;
    private int viewerHeight = -1;
    Composite viewerComposite;
    private Button detailsButton;
    private long watchTime = -1L;
    protected boolean alreadyClosed = false;
    private IProgressMonitor wrapperedMonitor;
    private IProgressService progressService;
    private ProgressManager progressManager;
    private ContentProviderFactory contentProviderFactory;
    private FinishedJobs finishedJobs;
    protected boolean enableDetailsButton = false;

    public ProgressMonitorJobsDialog(Shell parent, IProgressService progressService, ProgressManager progressManager, ContentProviderFactory contentProviderFactory, FinishedJobs finishedJobs) {
        super(parent);
        this.progressService = progressService;
        this.progressManager = progressManager;
        this.contentProviderFactory = contentProviderFactory;
        this.finishedJobs = finishedJobs;
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = (Composite)super.createDialogArea(parent);
        this.createExtendedDialogArea(parent);
        return top;
    }

    protected void createExtendedDialogArea(Composite parent) {
        this.viewerComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.viewerComposite.setLayout((Layout)layout);
        GridData viewerData = new GridData(1808);
        viewerData.horizontalSpan = 2;
        viewerData.heightHint = 0;
        this.viewerComposite.setLayoutData((Object)viewerData);
    }

    void handleDetailsButtonSelect() {
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        Composite composite = (Composite)this.getDialogArea();
        if (this.viewer != null) {
            this.viewer.getControl().dispose();
            this.viewer = null;
            composite.layout();
            shell.setSize(shellSize.x, shellSize.y - this.viewerHeight);
            this.detailsButton.setText(ProgressMessages.ProgressMonitorJobsDialog_DetailsTitle);
        } else {
            if (this.progressManager.getRootElements(Policy.DEBUG_SHOW_ALL_JOBS).length == 0) {
                this.detailsButton.setEnabled(false);
                return;
            }
            this.viewer = new DetailedProgressViewer(this.viewerComposite, 2818, this.progressService, this.finishedJobs);
            this.viewer.setComparator(ProgressManagerUtil.getProgressViewerComparator());
            this.viewer.setContentProvider((IContentProvider)this.contentProviderFactory.getProgressViewerContentProvider(this.viewer, true, false));
            this.viewer.setLabelProvider((IBaseLabelProvider)new ProgressLabelProvider());
            this.viewer.setInput((Object)this);
            GridData viewerData = new GridData(1808);
            this.viewer.getControl().setLayoutData((Object)viewerData);
            GridData viewerCompositeData = (GridData)this.viewerComposite.getLayoutData();
            viewerCompositeData.heightHint = this.convertHeightInCharsToPixels(10);
            this.viewerComposite.layout(true);
            this.viewer.getControl().setVisible(true);
            this.viewerHeight = this.viewerComposite.computeTrim((int)0, (int)0, (int)0, (int)viewerCompositeData.heightHint).height;
            this.detailsButton.setText(ProgressMessages.ProgressMonitorJobsDialog_HideTitle);
            shell.setSize(shellSize.x, shellSize.y + this.viewerHeight);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createDetailsButton(parent);
    }

    protected void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(768));
    }

    protected void createDetailsButton(Composite parent) {
        this.detailsButton = this.createButton(parent, 13, ProgressMessages.ProgressMonitorJobsDialog_DetailsTitle, false);
        this.detailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressMonitorJobsDialog.this.handleDetailsButtonSelect();
            }
        });
        this.detailsButton.setCursor(this.arrowCursor);
        this.detailsButton.setEnabled(this.enableDetailsButton);
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.horizontalAlignment = 3;
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        if (this.arrowCursor == null) {
            Cursor cursor;
            this.arrowCursor = cursor = new Cursor((Device)parent.getDisplay(), 0);
            composite.addDisposeListener(e -> cursor.dispose());
        }
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    protected void clearCursors() {
        if (this.detailsButton != null && !this.detailsButton.isDisposed()) {
            this.detailsButton.setCursor(null);
        }
        super.clearCursors();
    }

    protected void updateForSetBlocked(IStatus reason) {
        if (this.alreadyClosed) {
            return;
        }
        super.updateForSetBlocked(reason);
        this.enableDetails(true);
        if (this.viewer == null) {
            this.handleDetailsButtonSelect();
        }
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        if (!fork) {
            this.enableDetails(false);
        }
        super.run(fork, cancelable, runnable);
    }

    protected void enableDetails(boolean enableState) {
        if (this.detailsButton == null) {
            this.enableDetailsButton = enableState;
        } else {
            this.detailsButton.setEnabled(enableState);
        }
    }

    public void watchTicks() {
        this.watchTime = System.currentTimeMillis();
    }

    public void createWrapperedMonitor() {
        this.wrapperedMonitor = new IProgressMonitor(){
            IProgressMonitor superMonitor;
            {
                this.superMonitor = ProgressMonitorJobsDialog.super.getProgressMonitor();
            }

            public void beginTask(String name, int totalWork) {
                this.superMonitor.beginTask(name, totalWork);
                this.checkTicking();
            }

            private void checkTicking() {
                if (ProgressMonitorJobsDialog.this.watchTime < 0L) {
                    return;
                }
                if (System.currentTimeMillis() - ProgressMonitorJobsDialog.this.watchTime > (long)ProgressMonitorJobsDialog.this.progressService.getLongOperationTime()) {
                    ProgressMonitorJobsDialog.this.watchTime = -1L;
                    this.openDialog();
                }
            }

            private void openDialog() {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                ProgressMonitorJobsDialog.this.getUISynchronize().syncExec(() -> {
                    if (!ProgressManagerUtil.safeToOpen(ProgressMonitorJobsDialog.this, null)) {
                        ProgressMonitorJobsDialog.this.watchTicks();
                        return;
                    }
                    if (!ProgressMonitorJobsDialog.this.alreadyClosed) {
                        ProgressMonitorJobsDialog.this.open();
                    }
                });
            }

            public void done() {
                this.superMonitor.done();
                this.checkTicking();
            }

            public void internalWorked(double work) {
                this.superMonitor.internalWorked(work);
                this.checkTicking();
            }

            public boolean isCanceled() {
                return this.superMonitor.isCanceled();
            }

            public void setCanceled(boolean value) {
                this.superMonitor.setCanceled(value);
            }

            public void setTaskName(String name) {
                this.superMonitor.setTaskName(name);
                this.checkTicking();
            }

            public void subTask(String name) {
                this.superMonitor.subTask(name);
                this.checkTicking();
            }

            public void worked(int work) {
                this.superMonitor.worked(work);
                this.checkTicking();
            }

            public void clearBlocked() {
                this.superMonitor.clearBlocked();
            }

            public void setBlocked(IStatus reason) {
                this.openDialog();
                this.superMonitor.setBlocked(reason);
            }
        };
    }

    public IProgressMonitor getProgressMonitor() {
        if (this.wrapperedMonitor == null) {
            this.createWrapperedMonitor();
        }
        return this.wrapperedMonitor;
    }

    public boolean close() {
        this.alreadyClosed = true;
        boolean result = super.close();
        if (!result) {
            this.alreadyClosed = false;
        }
        return result;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Display getUISynchronize() {
        return Services.getInstance().getDisplay();
    }
}

