/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.properties;

import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.help.IContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.util.ConfigureColumns;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.internal.views.properties.PropertiesMessages;
import org.eclipse.ui.part.CellEditorActionHandler;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.properties.CategoriesAction;
import org.eclipse.ui.views.properties.CopyPropertyAction;
import org.eclipse.ui.views.properties.DefaultsAction;
import org.eclipse.ui.views.properties.FilterAction;
import org.eclipse.ui.views.properties.ICellEditorActivationListener;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetSorter;
import org.eclipse.ui.views.properties.PropertySheetViewer;

public class PropertySheetPage
extends Page
implements IPropertySheetPage,
IAdaptable {
    public static final String HELP_CONTEXT_PROPERTY_SHEET_PAGE = "org.eclipse.ui.property_sheet_page_help_context";
    private PropertySheetViewer viewer;
    private PropertySheetSorter sorter;
    private IPropertySheetEntry rootEntry;
    private IPropertySourceProvider provider;
    private DefaultsAction defaultsAction;
    private FilterAction filterAction;
    private CategoriesAction categoriesAction;
    private CopyPropertyAction copyAction;
    private ICellEditorActivationListener cellEditorActivationListener;
    private CellEditorActionHandler cellEditorActionHandler;
    private Clipboard clipboard;
    private IWorkbenchPart sourcePart;
    private Action columnsAction;
    private ISelectionChangedListener selectionChangeListener;

    public void createControl(Composite parent) {
        this.viewer = new PropertySheetViewer(parent);
        this.viewer.setSorter(this.sorter);
        if (this.rootEntry == null) {
            PropertySheetEntry root = new PropertySheetEntry();
            if (this.provider != null) {
                root.setPropertySourceProvider(this.provider);
            }
            this.rootEntry = root;
        }
        this.viewer.setRootEntry(this.rootEntry);
        this.viewer.addActivationListener(this.getCellEditorActivationListener());
        this.selectionChangeListener = event -> this.handleEntrySelection(event.getSelection());
        this.viewer.addSelectionChangedListener(this.selectionChangeListener);
        this.initDragAndDrop();
        this.makeActions();
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.add((IAction)this.copyAction);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)this.defaultsAction);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.viewer.getControl().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                IPropertySheetEntry entry;
                Object helpContextId;
                IStructuredSelection selection = (IStructuredSelection)PropertySheetPage.this.viewer.getSelection();
                if (!selection.isEmpty() && (helpContextId = (entry = (IPropertySheetEntry)selection.getFirstElement()).getHelpContextIds()) != null) {
                    IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
                    if (helpContextId instanceof String) {
                        helpSystem.displayHelp((String)helpContextId);
                        return;
                    }
                    Object context = this.getFirstContext(helpContextId, e);
                    if (context instanceof IContext) {
                        helpSystem.displayHelp((IContext)context);
                    } else if (context instanceof String) {
                        helpSystem.displayHelp((String)context);
                    }
                    return;
                }
                PlatformUI.getWorkbench().getHelpSystem().displayHelp(PropertySheetPage.HELP_CONTEXT_PROPERTY_SHEET_PAGE);
            }

            @Deprecated
            private Object getFirstContext(Object helpContext, HelpEvent e) {
                Object[] contexts = (Object[])helpContext;
                if (contexts.length > 0) {
                    return contexts[0];
                }
                return null;
            }
        });
    }

    public void dispose() {
        super.dispose();
        this.sourcePart = null;
        if (this.rootEntry != null) {
            this.rootEntry.dispose();
            this.rootEntry = null;
        }
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        if (this.viewer != null) {
            if (this.selectionChangeListener != null) {
                this.viewer.removeSelectionChangedListener(this.selectionChangeListener);
                this.selectionChangeListener = null;
            }
            this.viewer.dispose();
            this.cellEditorActivationListener = null;
            this.viewer = null;
        }
        if (this.cellEditorActionHandler != null) {
            this.cellEditorActionHandler.dispose();
            this.cellEditorActionHandler = null;
        }
        if (this.defaultsAction != null) {
            this.defaultsAction.viewer = null;
            this.defaultsAction = null;
        }
        if (this.filterAction != null) {
            this.filterAction.viewer = null;
            this.filterAction = null;
        }
        if (this.categoriesAction != null) {
            this.categoriesAction.viewer = null;
            this.categoriesAction = null;
        }
        if (this.copyAction != null) {
            this.copyAction.viewer = null;
            this.copyAction = null;
        }
        this.sorter = null;
        this.provider = null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ISaveablePart.class.equals(adapter)) {
            return adapter.cast(this.getSaveablePart());
        }
        return null;
    }

    protected ISaveablePart getSaveablePart() {
        if (this.sourcePart instanceof ISaveablePart) {
            return (ISaveablePart)this.sourcePart;
        }
        return null;
    }

    private ICellEditorActivationListener getCellEditorActivationListener() {
        if (this.cellEditorActivationListener == null) {
            this.cellEditorActivationListener = new ICellEditorActivationListener(){

                @Override
                public void cellEditorActivated(CellEditor cellEditor) {
                    if (PropertySheetPage.this.cellEditorActionHandler != null) {
                        PropertySheetPage.this.cellEditorActionHandler.addCellEditor(cellEditor);
                    }
                }

                @Override
                public void cellEditorDeactivated(CellEditor cellEditor) {
                    if (PropertySheetPage.this.cellEditorActionHandler != null) {
                        PropertySheetPage.this.cellEditorActionHandler.removeCellEditor(cellEditor);
                    }
                }
            };
        }
        return this.cellEditorActivationListener;
    }

    public Control getControl() {
        if (this.viewer == null) {
            return null;
        }
        return this.viewer.getControl();
    }

    public void handleEntrySelection(ISelection selection) {
        if (this.defaultsAction != null) {
            if (selection.isEmpty()) {
                this.defaultsAction.setEnabled(false);
                return;
            }
            boolean editable = this.viewer.getActiveCellEditor() != null;
            this.defaultsAction.setEnabled(editable);
        }
    }

    protected void initDragAndDrop() {
        int operations = 1;
        Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
        DragSourceAdapter listener = new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                PropertySheetPage.this.performDragSetData(event);
            }

            public void dragFinished(DragSourceEvent event) {
            }
        };
        DragSource dragSource = new DragSource(this.viewer.getControl(), operations);
        dragSource.setTransfer(transferTypes);
        dragSource.addDragListener((DragSourceListener)listener);
    }

    void performDragSetData(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        IPropertySheetEntry entry = (IPropertySheetEntry)selection.getFirstElement();
        StringBuilder buffer = new StringBuilder();
        buffer.append(entry.getDisplayName());
        buffer.append("\t");
        buffer.append(entry.getValueAsString());
        event.data = buffer.toString();
    }

    private void makeActions() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.defaultsAction = new DefaultsAction(this.viewer, "defaults");
        this.defaultsAction.setText(PropertiesMessages.Defaults_text);
        this.defaultsAction.setToolTipText(PropertiesMessages.Defaults_toolTip);
        this.defaultsAction.setImageDescriptor(this.createImageDescriptor("elcl16/defaults_ps.png"));
        this.defaultsAction.setDisabledImageDescriptor(this.createImageDescriptor("dlcl16/defaults_ps.png"));
        this.defaultsAction.setEnabled(false);
        this.filterAction = new FilterAction(this.viewer, "filter");
        this.filterAction.setText(PropertiesMessages.Filter_text);
        this.filterAction.setToolTipText(PropertiesMessages.Filter_toolTip);
        this.filterAction.setImageDescriptor(this.createImageDescriptor("elcl16/filter_ps.png"));
        this.filterAction.setChecked(false);
        this.categoriesAction = new CategoriesAction(this.viewer, "categories");
        this.categoriesAction.setText(PropertiesMessages.Categories_text);
        this.categoriesAction.setToolTipText(PropertiesMessages.Categories_toolTip);
        this.categoriesAction.setImageDescriptor(this.createImageDescriptor("elcl16/tree_mode.png"));
        this.categoriesAction.setChecked(true);
        this.columnsAction = new Action(PropertiesMessages.Columns_text){

            public void run() {
                Tree tree = (Tree)PropertySheetPage.this.viewer.getControl();
                ConfigureColumns.forTree((Tree)tree, (IShellProvider)new SameShellProvider((Control)tree));
            }
        };
        this.columnsAction.setToolTipText(PropertiesMessages.Columns_toolTip);
        Shell shell = this.viewer.getControl().getShell();
        this.clipboard = new Clipboard(shell.getDisplay());
        this.copyAction = new CopyPropertyAction(this.viewer, "copy", this.clipboard);
        this.copyAction.setText(PropertiesMessages.CopyProperty_text);
        this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
    }

    private ImageDescriptor createImageDescriptor(String relativeIconPath) {
        String ICONS_PATH = "$nl$/icons/full/";
        String imageFilePath = ICONS_PATH + relativeIconPath;
        return ResourceLocator.imageDescriptorFromBundle(PropertySheetPage.class, (String)imageFilePath).orElse(null);
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        toolBarManager.add((IAction)this.categoriesAction);
        toolBarManager.add((IAction)this.filterAction);
        toolBarManager.add((IAction)this.defaultsAction);
        menuManager.add((IAction)this.categoriesAction);
        menuManager.add((IAction)this.filterAction);
        menuManager.add((IAction)this.columnsAction);
        this.viewer.setStatusLineManager(statusLineManager);
    }

    public void refresh() {
        if (this.viewer == null) {
            return;
        }
        this.viewer.setInput(this.viewer.getInput());
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.viewer == null) {
            return;
        }
        this.sourcePart = part;
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            this.viewer.setInput(((IStructuredSelection)selection).toArray());
        } else {
            IContributedContentsView view = (IContributedContentsView)Adapters.adapt((Object)part, IContributedContentsView.class);
            IWorkbenchPart source = null;
            if (view != null) {
                source = view.getContributingPart();
            }
            this.viewer.setInput(new Object[]{source != null ? source : part});
        }
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
        this.cellEditorActionHandler = new CellEditorActionHandler(actionBars);
        this.cellEditorActionHandler.setCopyAction((IAction)this.copyAction);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void setPropertySourceProvider(IPropertySourceProvider newProvider) {
        this.provider = newProvider;
        if (this.rootEntry instanceof PropertySheetEntry) {
            ((PropertySheetEntry)this.rootEntry).setPropertySourceProvider(this.provider);
            if (this.viewer != null) {
                this.viewer.setRootEntry(this.rootEntry);
            }
        }
    }

    public void setRootEntry(IPropertySheetEntry entry) {
        this.rootEntry = entry;
        if (this.viewer != null) {
            this.viewer.setRootEntry(this.rootEntry);
        }
    }

    protected void setSorter(PropertySheetSorter sorter) {
        this.sorter = sorter;
        if (this.viewer != null) {
            this.viewer.setSorter(sorter);
            if (this.viewer.getRootEntry() != null) {
                this.viewer.setRootEntry(this.rootEntry);
            }
        }
    }
}

