/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.tests;

import java.io.File;
import java.io.InterruptedIOException;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.internal.repository.mirroring.Mirroring;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.AgentManager;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.ProfileTransaction;
import org.eclipse.oomph.p2.internal.core.AgentManagerImpl;
import org.eclipse.oomph.p2.internal.core.P2CorePlugin;
import org.eclipse.oomph.tests.AbstractTest;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;

public abstract class AbstractP2Test
extends AbstractTest {
    protected static final String TMP = PropertiesUtil.getProperty((String)"java.io.tmpdir");
    private static final String CDO = "p2-test-mirror-001-cdo";
    private static final String PLATFORM = "p2-test-mirror-001-platform";
    private static final String SIMPLE_METADATA_REPOSITORY = "org.eclipse.equinox.p2.metadata.repository.simpleRepository";
    private static final String SIMPLE_ARTIFACT_REPOSITORY = "org.eclipse.equinox.p2.artifact.repository.simpleRepository";
    private static final P2Util.VersionedIdFilter CDO_FILTER = new P2Util.VersionedIdFilter(){

        public boolean matches(IVersionedId versionedId) {
            String id = versionedId.getId();
            return id.startsWith("org.eclipse.net4j.util") || id.startsWith("org.apache");
        }
    };
    private static final P2Util.VersionedIdFilter PLATFORM_FILTER = new P2Util.VersionedIdFilter(){

        public boolean matches(IVersionedId versionedId) {
            String id = versionedId.getId();
            return id.startsWith("com.jcraft.jsch") || id.startsWith("org.apache") || id.startsWith("a.jre");
        }
    };
    public static final File CDO_OLD = new File(TMP, "p2-test-mirror-001-cdo-old");
    public static final File CDO_NEW = new File(TMP, "p2-test-mirror-001-cdo-new");
    public static final File PLATFORM_OLD = new File(TMP, "p2-test-mirror-001-platform-old");
    public static final File PLATFORM_NEW = new File(TMP, "p2-test-mirror-001-platform-new");

    public void setUp() throws Exception {
        super.setUp();
        AgentManagerImpl.instance = new AgentManagerImpl(this.getUserHome());
    }

    public void tearDown() throws Exception {
        AgentManagerImpl.instance = null;
        super.tearDown();
    }

    protected Agent getAgent() {
        AgentManager agentManager = P2Util.getAgentManager();
        return (Agent)agentManager.getAgents().iterator().next();
    }

    protected Agent getFreshAgent() {
        AgentManagerImpl.instance = new AgentManagerImpl(this.getUserHome());
        return this.getAgent();
    }

    protected void commitProfileTransaction(ProfileTransaction transaction, boolean expectedChange) throws CoreException {
        this.commitProfileTransaction(transaction, expectedChange, LOGGER);
    }

    protected void commitProfileTransaction(ProfileTransaction transaction, boolean expectedChange, IProgressMonitor monitor) throws CoreException {
        boolean actualChange = transaction.commit(monitor);
        if (actualChange != expectedChange) {
            if (expectedChange) {
                throw new AssertionError((Object)"Profile should have changed, but didn't");
            }
            throw new AssertionError((Object)"Profile should not have changed, but did");
        }
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        try {
            AbstractP2Test.mirror("https://download.eclipse.org/modeling/emf/cdo/drops/R20130918-0029", CDO_OLD, CDO_FILTER);
            AbstractP2Test.mirror("https://download.eclipse.org/modeling/emf/cdo/drops/R20140218-1655", CDO_NEW, CDO_FILTER);
            AbstractP2Test.mirror("https://download.eclipse.org/eclipse/updates/4.25/R-4.25-202208311800", PLATFORM_OLD, PLATFORM_FILTER);
            AbstractP2Test.mirror("https://download.eclipse.org/eclipse/updates/4.28/R-4.28-202306050440", PLATFORM_NEW, PLATFORM_FILTER);
        }
        catch (CoreException ex) {
            AbstractP2Test.handleSetUpFailure(ex.getStatus());
        }
    }

    private static void handleSetUpFailure(IStatus status) {
        Throwable ex = status.getException();
        if (ex instanceof InterruptedIOException) {
            Assume.assumeNoException((Throwable)ex);
        }
        if (status instanceof MultiStatus) {
            IStatus[] iStatusArray = ((MultiStatus)status).getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                AbstractP2Test.handleSetUpFailure(child);
                ++n2;
            }
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (Boolean.FALSE.booleanValue()) {
            IOUtil.deleteBestEffort((File)CDO_OLD, (boolean)true);
            IOUtil.deleteBestEffort((File)CDO_NEW, (boolean)true);
            IOUtil.deleteBestEffort((File)PLATFORM_OLD, (boolean)true);
            IOUtil.deleteBestEffort((File)PLATFORM_NEW, (boolean)true);
        }
    }

    private static void mirror(String repo, File local, P2Util.VersionedIdFilter filter) throws Exception {
        if (!local.isDirectory()) {
            LOGGER.setTaskName("Creating test mirror of " + repo + " under " + String.valueOf(local));
            AbstractP2Test.mirrorRepository(new URI(repo), local.toURI(), filter, LOGGER);
            LOGGER.setTaskName(null);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void mirrorArtifactRepository(URI sourceURI, URI targetURI, P2Util.VersionedIdFilter filter, IProgressMonitor monitor) throws CoreException {
        repositoriesToRemove = new ArrayList<URI>();
        repositoriesToRemove.add(targetURI);
        agent = P2Util.getAgentManager().getCurrentAgent();
        manager = agent.getArtifactRepositoryManager();
        if (!manager.contains(sourceURI)) {
            repositoriesToRemove.add(sourceURI);
        }
        try {
            sourceRepository = manager.loadRepository(sourceURI, 0, monitor);
            name = sourceRepository.getName();
            if (name == null) {
                name = sourceURI.toString();
            }
            targetRepository = manager.createRepository(targetURI, name, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", sourceRepository.getProperties());
            targetRepository.setProperty("p2.compressed", "true");
            keys = new ArrayList<IArtifactKey>();
            for (IArtifactKey key : P2Util.asIterable((IQueryResult)sourceRepository.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null))) {
                if (filter != null && !filter.matches((IVersionedId)key)) continue;
                keys.add(key);
            }
            transport = (Transport)agent.getProvisioningAgent().getService(Transport.SERVICE_NAME);
            mirror = new Mirroring(sourceRepository, targetRepository, true);
            mirror.setCompare(false);
            mirror.setTransport(transport);
            mirror.setArtifactKeys(keys.toArray(new IArtifactKey[keys.size()]));
            result = mirror.run(true, false);
            P2CorePlugin.INSTANCE.coreException((IStatus)result);
        }
        finally {
            ** for (uri : repositoriesToRemove)
        }
lbl-1000:
        // 1 sources

        {
            manager.removeRepository(uri);
            continue;
        }
lbl36:
        // 1 sources

    }

    public static void mirrorRepository(URI sourceURI, URI targetURI, P2Util.VersionedIdFilter filter, IProgressMonitor monitor) throws CoreException {
        AbstractP2Test.mirrorMetadataRepository(sourceURI, targetURI, filter, monitor);
        AbstractP2Test.mirrorArtifactRepository(sourceURI, targetURI, filter, monitor);
    }

    /*
     * Unable to fully structure code
     */
    public static void mirrorMetadataRepository(URI sourceURI, URI targetURI, P2Util.VersionedIdFilter filter, IProgressMonitor monitor) throws CoreException {
        repositoriesToRemove = new ArrayList<URI>();
        repositoriesToRemove.add(targetURI);
        manager = P2Util.getAgentManager().getCurrentAgent().getMetadataRepositoryManager();
        if (!manager.contains(sourceURI)) {
            repositoriesToRemove.add(sourceURI);
        }
        try {
            sourceRepository = manager.loadRepository(sourceURI, 0, monitor);
            name = sourceRepository.getName();
            if (name == null) {
                name = sourceURI.toString();
            }
            targetRepository = manager.createRepository(targetURI, name, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", sourceRepository.getProperties());
            targetRepository.setProperty("p2.compressed", "true");
            ius = new ArrayList<IInstallableUnit>();
            allIUs = sourceRepository.query(QueryUtil.createIUAnyQuery(), null).toSet();
            for (IInstallableUnit iu : allIUs) {
                if (filter != null && !filter.matches((IVersionedId)iu)) continue;
                ius.add(iu);
            }
            targetRepository.addInstallableUnits(ius);
        }
        finally {
            ** for (uri : repositoriesToRemove)
        }
lbl-1000:
        // 1 sources

        {
            manager.removeRepository(uri);
            continue;
        }
lbl30:
        // 1 sources

    }
}

