/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.svg;

import org.eclipse.nebula.cwt.svg.SvgContainer;
import org.eclipse.nebula.cwt.svg.SvgElement;
import org.eclipse.nebula.cwt.svg.SvgFill;
import org.eclipse.nebula.cwt.svg.SvgFragment;
import org.eclipse.nebula.cwt.svg.SvgPaint;
import org.eclipse.nebula.cwt.svg.SvgStroke;
import org.eclipse.nebula.cwt.svg.SvgTransform;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Transform;

public abstract class SvgGraphic
extends SvgElement {
    String title;
    String description;
    SvgFill fill = new SvgFill(this);
    SvgStroke stroke = new SvgStroke(this);
    SvgTransform transform;

    SvgGraphic(SvgContainer container, String id) {
        super(container, id);
    }

    public abstract void apply(GC var1);

    public String getDescription() {
        return this.description == null ? null : this.description;
    }

    SvgFill getFill() {
        SvgFill df = new SvgFill(this);
        for (SvgElement el : SvgGraphic.getAncestry(this)) {
            if (!(el instanceof SvgGraphic)) continue;
            SvgFill tmp = ((SvgGraphic)el).fill;
            if (tmp.type != null) {
                df.type = tmp.type;
            }
            if (tmp.color != null) {
                df.color = tmp.color;
            }
            if (tmp.linkId != null) {
                df.linkId = tmp.linkId;
            }
            if (tmp.opacity != null) {
                df.opacity = tmp.opacity;
            }
            if (tmp.rule == null) continue;
            df.rule = tmp.rule;
        }
        if (df.type == null) {
            df.type = SvgPaint.PaintType.Color;
        }
        if (df.color == null) {
            df.color = 0;
        }
        if (df.opacity == null) {
            df.opacity = Float.valueOf(1.0f);
        }
        if (df.rule == null) {
            df.rule = 1;
        }
        return df;
    }

    SvgStroke getStroke() {
        SvgStroke ds = new SvgStroke(this);
        for (SvgElement el : SvgGraphic.getAncestry(this)) {
            if (!(el instanceof SvgGraphic)) continue;
            SvgStroke tmp = ((SvgGraphic)el).stroke;
            if (tmp.type != null) {
                ds.type = tmp.type;
            }
            if (tmp.color != null) {
                ds.color = tmp.color;
            }
            if (tmp.linkId != null) {
                ds.linkId = tmp.linkId;
            }
            if (tmp.opacity != null) {
                ds.opacity = tmp.opacity;
            }
            if (tmp.width != null) {
                ds.width = tmp.width;
            }
            if (tmp.lineCap != null) {
                ds.lineCap = tmp.lineCap;
            }
            if (tmp.lineJoin == null) continue;
            ds.lineJoin = tmp.lineJoin;
        }
        if (ds.type == null) {
            ds.type = SvgPaint.PaintType.None;
        }
        if (ds.type != SvgPaint.PaintType.None) {
            if (ds.color == null) {
                ds.color = 0;
            }
            if (ds.opacity == null) {
                ds.opacity = Float.valueOf(1.0f);
            }
            if (ds.width == null) {
                ds.width = Float.valueOf(1.0f);
            }
            if (ds.lineCap == null) {
                ds.lineCap = 1;
            }
            if (ds.lineJoin == null) {
                ds.lineJoin = 1;
            }
        }
        return ds;
    }

    Transform getTransform(GC gc) {
        Transform t = new Transform(gc.getDevice());
        gc.getTransform(t);
        for (SvgElement el : SvgGraphic.getAncestry(this)) {
            Transform tmp;
            SvgTransform st;
            if (el instanceof SvgFragment) {
                st = ((SvgFragment)el).boundsTransform;
                if (st.isIdentity()) continue;
                tmp = new Transform(gc.getDevice());
                tmp.setElements(st.data[0], st.data[1], st.data[2], st.data[3], st.data[4], st.data[5]);
                t.multiply(tmp);
                tmp.dispose();
                continue;
            }
            if (!(el instanceof SvgGraphic)) continue;
            st = ((SvgGraphic)el).transform;
            while (st != null) {
                if (!st.isIdentity()) {
                    tmp = new Transform(gc.getDevice());
                    tmp.setElements(st.data[0], st.data[1], st.data[2], st.data[3], st.data[4], st.data[5]);
                    t.multiply(tmp);
                    tmp.dispose();
                }
                st = st.next;
            }
        }
        return t;
    }

    public String getTitle() {
        return this.title == null ? null : this.title;
    }
}

