/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class ExtendedFontRegistry {
    public static final ExtendedFontRegistry INSTANCE = new ExtendedFontRegistry();
    protected Display display;
    protected HashMap<Collection<?>, Font> table = new HashMap(10);

    public ExtendedFontRegistry() {
        this.display = Display.getCurrent();
        this.hookDisplayDispose(this.display);
    }

    public ExtendedFontRegistry(Display display) {
        this.display = display;
        this.hookDisplayDispose(display);
    }

    public Font getFont(Font baseFont, Object object) {
        if (object instanceof Font) {
            return (Font)object;
        }
        ArrayList<Object> key = new ArrayList<Object>(2);
        key.add(baseFont);
        key.add(object);
        Font result = this.table.get(key);
        if (result == null) {
            if (object instanceof FontDescriptor) {
                FontDescriptor fontDescriptor = (FontDescriptor)object;
                try {
                    result = fontDescriptor.createFont((Device)this.display);
                }
                catch (DeviceResourceException exception) {
                    EMFEditUIPlugin.INSTANCE.log((Object)exception);
                }
            } else if (object instanceof URI) {
                int height;
                boolean delta;
                String heightSpecification;
                URI fontURI = (URI)object;
                if (!"font".equals(fontURI.scheme())) {
                    throw new IllegalArgumentException("Only 'font' scheme is recognized" + fontURI);
                }
                String fontNameSpecification = fontURI.authority();
                if ("".equals(fontNameSpecification)) {
                    fontNameSpecification = null;
                }
                if ((heightSpecification = fontURI.segment(0)).startsWith("+")) {
                    delta = true;
                    height = Integer.parseInt(heightSpecification.substring(1));
                } else if ("".equals(heightSpecification)) {
                    delta = true;
                    height = 0;
                } else {
                    height = Integer.parseInt(heightSpecification);
                    delta = height < 0;
                }
                String styleSpecification = fontURI.segment(1);
                int style = "bold".equals(styleSpecification) ? 1 : ("italic".equals(styleSpecification) ? 2 : ("italic+bold".equals(styleSpecification) || "bold+italic".equals(styleSpecification) ? 3 : ("normal".equals(styleSpecification) ? 0 : -1)));
                FontData[] baseFontData = baseFont.getFontData();
                FontData[] fontData = new FontData[baseFontData.length];
                int i = 0;
                while (i < baseFontData.length) {
                    fontData[i] = new FontData(fontNameSpecification == null ? baseFontData[i].getName() : fontNameSpecification, delta ? baseFontData[i].getHeight() + height : height, style == -1 ? baseFontData[i].getStyle() : style);
                    ++i;
                }
                try {
                    result = FontDescriptor.createFrom((FontData[])fontData).createFont((Device)this.display);
                }
                catch (DeviceResourceException exception) {
                    EMFEditUIPlugin.INSTANCE.log((Object)exception);
                }
            }
            if (result != null) {
                this.table.put(key, result);
            }
        }
        return result;
    }

    protected void handleDisplayDispose() {
        for (Font image : this.table.values()) {
            image.dispose();
        }
        this.table = null;
    }

    protected void hookDisplayDispose(Display display) {
        display.disposeExec(new Runnable(){

            @Override
            public void run() {
                ExtendedFontRegistry.this.handleDisplayDispose();
            }
        });
    }
}

