/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.util.CompactByteArray;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

class BreakDictionary {
    private char[] reverseColumnMap = null;
    private CompactByteArray columnMap = null;
    private int numCols;
    private short[] table = null;
    private short[] rowIndex = null;
    private int[] rowIndexFlags = null;
    private short[] rowIndexFlagsIndex = null;
    private byte[] rowIndexShifts = null;

    static void writeToFile(String inFile, String outFile) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        BreakDictionary dictionary = new BreakDictionary(ICUBinary.getByteBufferFromInputStream(new FileInputStream(inFile)));
        PrintWriter out = null;
        if (outFile != null) {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UnicodeLittle"));
        }
        dictionary.printWordList("", 0, out);
        if (out != null) {
            out.close();
        }
    }

    void printWordList(String partialWord, int state, PrintWriter out) throws IOException {
        if (state == 65535) {
            System.out.println(partialWord);
            if (out != null) {
                out.println(partialWord);
            }
        } else {
            int i = 0;
            while (i < this.numCols) {
                int newState = this.at(state, i) & 0xFFFF;
                if (newState != 0) {
                    char newChar = this.reverseColumnMap[i];
                    String newPartialWord = partialWord;
                    if (newChar != '\u0000') {
                        newPartialWord = String.valueOf(newPartialWord) + newChar;
                    }
                    this.printWordList(newPartialWord, newState, out);
                }
                ++i;
            }
        }
    }

    BreakDictionary(ByteBuffer bytes) throws IOException {
        this.readDictionaryFile(bytes);
    }

    void readDictionaryFile(ByteBuffer bytes) throws IOException {
        bytes.getInt();
        int l = bytes.getInt();
        char[] temp = new char[l];
        int i = 0;
        while (i < temp.length) {
            temp[i] = (char)bytes.getShort();
            ++i;
        }
        l = bytes.getInt();
        byte[] temp2 = new byte[l];
        int i2 = 0;
        while (i2 < temp2.length) {
            temp2[i2] = bytes.get();
            ++i2;
        }
        this.columnMap = new CompactByteArray(temp, temp2);
        this.numCols = bytes.getInt();
        bytes.getInt();
        l = bytes.getInt();
        this.rowIndex = new short[l];
        i2 = 0;
        while (i2 < this.rowIndex.length) {
            this.rowIndex[i2] = bytes.getShort();
            ++i2;
        }
        l = bytes.getInt();
        this.rowIndexFlagsIndex = new short[l];
        i2 = 0;
        while (i2 < this.rowIndexFlagsIndex.length) {
            this.rowIndexFlagsIndex[i2] = bytes.getShort();
            ++i2;
        }
        l = bytes.getInt();
        this.rowIndexFlags = new int[l];
        i2 = 0;
        while (i2 < this.rowIndexFlags.length) {
            this.rowIndexFlags[i2] = bytes.getInt();
            ++i2;
        }
        l = bytes.getInt();
        this.rowIndexShifts = new byte[l];
        i2 = 0;
        while (i2 < this.rowIndexShifts.length) {
            this.rowIndexShifts[i2] = bytes.get();
            ++i2;
        }
        l = bytes.getInt();
        this.table = new short[l];
        i2 = 0;
        while (i2 < this.table.length) {
            this.table[i2] = bytes.getShort();
            ++i2;
        }
        this.reverseColumnMap = new char[this.numCols];
        char c = '\u0000';
        while (c < '\uffff') {
            byte col = this.columnMap.elementAt(c);
            if (col != 0) {
                this.reverseColumnMap[col] = c;
            }
            c = (char)(c + '\u0001');
        }
    }

    final short at(int row, char ch) {
        byte col = this.columnMap.elementAt(ch);
        return this.at(row, col);
    }

    final short at(int row, int col) {
        if (this.cellIsPopulated(row, col)) {
            return this.internalAt(this.rowIndex[row], col + this.rowIndexShifts[row]);
        }
        return 0;
    }

    private final boolean cellIsPopulated(int row, int col) {
        if (this.rowIndexFlagsIndex[row] < 0) {
            return col == -this.rowIndexFlagsIndex[row];
        }
        int flags = this.rowIndexFlags[this.rowIndexFlagsIndex[row] + (col >> 5)];
        return (flags & 1 << (col & 0x1F)) != 0;
    }

    private final short internalAt(int row, int col) {
        return this.table[row * this.numCols + col];
    }
}

