/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.util.regex.Pattern;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.oomph.internal.ui.FlatButton;
import org.eclipse.oomph.internal.ui.ImageHoverButton;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.internal.installer.AbstractSimpleDialog;
import org.eclipse.oomph.setup.internal.installer.Installer;
import org.eclipse.oomph.setup.internal.installer.ProductPage;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerDialog;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class SimpleInstallerPage
extends Composite {
    public static final RGB HOVER_RGB = new RGB(175, 187, 220);
    public static final RGB ACTIVE_RGB = new RGB(196, 211, 254);
    public static final Color COLOR_PAGE_BORDER = SetupInstallerPlugin.getColor((int)238, (int)238, (int)238);
    protected static final Font FONT_LABEL = SimpleInstallerDialog.getDefaultFont();
    private static final Pattern PRODUCT_CATALOG_FILTER = Pattern.compile(PropertiesUtil.getProperty((String)"oomph.setup.product.catalog.filter", (String)""));
    private static final Pattern PRODUCT_FILTER = Pattern.compile(PropertiesUtil.getProperty((String)"oomph.setup.product.filter", (String)""));
    protected static final Pattern PRODUCT_VERSION_FILTER = Pattern.compile(PropertiesUtil.getProperty((String)"oomph.setup.product.version.filter", (String)""));
    protected final Installer installer;
    protected final SimpleInstallerDialog dialog;
    protected final FlatButton backButton;

    public SimpleInstallerPage(Composite parent, SimpleInstallerDialog dialog, boolean withBackButton) {
        super(parent, 0);
        this.installer = dialog.getInstaller();
        this.dialog = dialog;
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 3;
        layout.marginHeight = 4;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        Composite container = new Composite((Composite)this, 0);
        GridLayout containerLayout = UIUtil.createGridLayout((int)1);
        containerLayout.verticalSpacing = 0;
        container.setLayout((Layout)containerLayout);
        container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        container.setBackground(COLOR_PAGE_BORDER);
        this.createContent(container);
        if (withBackButton) {
            Composite buttonContainer = new Composite((Composite)this, 0);
            buttonContainer.setLayout((Layout)UIUtil.createGridLayout((int)1));
            buttonContainer.setBackgroundMode(2);
            buttonContainer.setBackground(AbstractSimpleDialog.COLOR_WHITE);
            this.backButton = new BackButton(buttonContainer);
            this.backButton.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 1).indent(15, 0).create());
            this.backButton.setToolTipText("Back");
            this.backButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SimpleInstallerPage.this.backSelected();
                }
            });
            Point defaultBackButtonSize = this.backButton.computeSize(-1, -1);
            buttonContainer.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).hint(-1, defaultBackButtonSize.y + 11).create());
        } else {
            this.backButton = null;
        }
    }

    public ResourceSet getResourceSet() {
        return this.installer.getResourceSet();
    }

    public void setEnabled(boolean enabled) {
        if (this.backButton != null) {
            this.backButton.setEnabled(enabled);
        }
    }

    protected Text createTextField(Composite parent) {
        Composite textContainer = this.createInputFieldWrapper(parent, 0, 7, 0, 7);
        this.applyComboOrTextStyle((Control)textContainer);
        Text textField = new Text(textContainer, 4);
        textField.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, true).create());
        FocusSelectionAdapter focusSelectionAdapter = new FocusSelectionAdapter();
        textField.addFocusListener((FocusListener)focusSelectionAdapter);
        textField.setData("focusSelectionAdapter", (Object)focusSelectionAdapter);
        this.applyComboOrTextStyle((Control)textField);
        return textField;
    }

    protected CCombo createComboBox(Composite parent, int style) {
        Composite comboContainer = this.createInputFieldWrapper(parent, 0, 0, 0, 7);
        this.applyComboOrTextStyle((Control)comboContainer);
        CCombo combo = new CCombo(comboContainer, style);
        combo.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, true).create());
        FocusSelectionAdapter focusSelectionAdapter = new FocusSelectionAdapter();
        combo.addFocusListener((FocusListener)focusSelectionAdapter);
        combo.setData("focusSelectionAdapter", (Object)focusSelectionAdapter);
        this.applyComboOrTextStyle((Control)combo);
        return combo;
    }

    private Composite createInputFieldWrapper(Composite parent, int marginTop, int marginRight, int marginBottom, int marginLeft) {
        GridLayout textContainerLayout = new GridLayout();
        textContainerLayout.marginHeight = 0;
        textContainerLayout.marginWidth = 0;
        textContainerLayout.marginTop = marginTop;
        textContainerLayout.marginRight = marginRight;
        textContainerLayout.marginBottom = marginBottom;
        textContainerLayout.marginLeft = marginLeft;
        Composite textContainer = new Composite(parent, 0);
        textContainer.setLayout((Layout)textContainerLayout);
        textContainer.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).hint(-1, 30).create());
        textContainer.setBackgroundMode(2);
        return textContainer;
    }

    protected abstract void createContent(Composite var1);

    public boolean isTop() {
        return this.dialog.getTopPage() == this;
    }

    public void aboutToShow() {
    }

    public void aboutToHide() {
    }

    protected void applyComboOrTextStyle(Control control) {
        control.setFont(SimpleInstallerDialog.getFont(1, "normal"));
        control.setForeground(AbstractSimpleDialog.COLOR_LABEL_FOREGROUND);
        control.setBackground(AbstractSimpleDialog.COLOR_LIGHTEST_GRAY);
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        label.setText(text);
        label.setFont(SimpleInstallerDialog.getFont(1, "bold"));
        label.setForeground(AbstractSimpleDialog.COLOR_LABEL_FOREGROUND);
        return label;
    }

    protected void checkSubclass() {
    }

    protected void backSelected() {
        this.dialog.backSelected();
    }

    public static boolean isIncluded(ProductCatalog productCatalog) {
        String name = productCatalog.getName();
        if ("self".equals(name) || "redirectable".equals(name) || productCatalog.getProducts().isEmpty()) {
            return false;
        }
        if (name == null || StringUtil.isEmpty((String)PRODUCT_CATALOG_FILTER.pattern()) || PRODUCT_CATALOG_FILTER.matcher(name).matches()) {
            for (Product product : productCatalog.getProducts()) {
                if (!SimpleInstallerPage.isIncluded(product)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isIncluded(Product product) {
        String name = product.getQualifiedName();
        if (name == null || StringUtil.isEmpty((String)PRODUCT_FILTER.pattern()) || PRODUCT_FILTER.matcher(name).matches()) {
            return !ProductPage.getValidProductVersions(product, PRODUCT_VERSION_FILTER).isEmpty();
        }
        return false;
    }

    protected static Control spacer(Composite parent) {
        return new Label(parent, 0);
    }

    public static String hex(RGB color) {
        return String.valueOf(SimpleInstallerPage.hex(color.red)) + SimpleInstallerPage.hex(color.green) + SimpleInstallerPage.hex(color.blue);
    }

    public static String hex(int byteValue) {
        String hexString = Integer.toHexString(byteValue);
        if (hexString.length() == 1) {
            hexString = "0" + hexString;
        }
        return hexString;
    }

    private static class BackButton
    extends ImageHoverButton {
        private static final Image ARROW_LEFT = SetupInstallerPlugin.INSTANCE.getSWTImage("simple/arrow_left.png");
        private static final Image ARROW_LEFT_HOVER = SetupInstallerPlugin.INSTANCE.getSWTImage("simple/arrow_left_hover.png");
        private static final Image ARROW_LEFT_DISABLED = SetupInstallerPlugin.INSTANCE.getSWTImage("simple/arrow_left_disabled.png");
        private static final Font FONT = SimpleInstallerDialog.getFont(1, "bold");

        public BackButton(Composite parent) {
            super(parent, 8, ARROW_LEFT, ARROW_LEFT_HOVER, ARROW_LEFT_DISABLED);
            this.setIconTextGap(16);
            this.setText("BACK");
            this.setForeground(AbstractSimpleDialog.COLOR_LABEL_FOREGROUND);
            this.setFont(FONT);
        }
    }

    public static final class FocusSelectionAdapter
    extends FocusAdapter {
        public static final String ADAPTER_KEY = "focusSelectionAdapter";
        private Point nextSelectionRange;

        public Point getNextSelectionRange() {
            return this.nextSelectionRange;
        }

        public void setNextSelectionRange(Point nextSelectionRange) {
            this.nextSelectionRange = nextSelectionRange;
        }

        public void focusLost(FocusEvent e) {
            UIUtil.setSelectionToEnd((Widget)e.widget);
        }

        public void focusGained(FocusEvent e) {
            if (this.nextSelectionRange != null) {
                try {
                    UIUtil.setSelectionTo((Widget)e.widget, (Point)this.nextSelectionRange);
                }
                finally {
                    this.nextSelectionRange = null;
                }
            } else {
                UIUtil.selectAllText((Widget)e.widget);
            }
        }
    }
}

