/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.ui.AbstractSetupDialog;
import org.eclipse.oomph.setup.util.SetupUtil;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AboutDialog
extends AbstractSetupDialog {
    private static final int ECLIPSE_VERSION_COLUMN_INDEX = 1;
    private static final String SHOW_ALL_PLUGINS = "SHOW_ALL_PLUGINS";
    private final IDialogSettings dialogSettings = this.getDialogSettings();
    private final String version;
    private boolean showAllPlugins;
    private Profile profile;
    private Table table;
    private TableColumn idColumn;
    private TableColumn versionColumn;
    private ControlAdapter columnResizer = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            Point size = AboutDialog.this.table.getSize();
            ScrollBar bar = AboutDialog.this.table.getVerticalBar();
            if (bar != null && bar.isVisible()) {
                size.x -= bar.getSize().x;
            }
            AboutDialog.this.idColumn.setWidth(size.x - AboutDialog.this.versionColumn.getWidth());
        }
    };
    private Color gray;

    public AboutDialog(Shell parentShell, String theVersion) {
        super(parentShell, "About " + parentShell.getText(), 700, 500, (OomphUIPlugin)SetupInstallerPlugin.INSTANCE, false);
        this.version = theVersion;
        this.showAllPlugins = this.dialogSettings.getBoolean(SHOW_ALL_PLUGINS);
    }

    protected String getDefaultMessage() {
        return "Installer version: " + this.version + "\n" + SetupUtil.INSTALLER_UPDATE_URL;
    }

    protected void createUI(Composite parent) {
        this.table = new Table(parent, 66064);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.addControlListener((ControlListener)this.columnResizer);
        this.idColumn = new TableColumn(this.table, 0);
        this.idColumn.setText("Plugin");
        this.idColumn.setResizable(false);
        this.idColumn.setMoveable(false);
        this.versionColumn = new TableColumn(this.table, 0);
        this.versionColumn.setText("Version");
        this.versionColumn.setResizable(false);
        this.versionColumn.setMoveable(false);
        Agent agent = P2Util.getAgentManager().getCurrentAgent();
        this.profile = agent.getCurrentProfile();
        this.gray = this.getShell().getDisplay().getSystemColor(10);
        this.fillTable();
    }

    private void fillTable() {
        List<IInstallableUnit> plugins = this.getPlugins();
        Collections.sort(plugins);
        for (IInstallableUnit plugin : plugins) {
            String version;
            TableItem item;
            block7: {
                item = new TableItem(this.table, 0);
                String id = plugin.getId();
                item.setText(0, id);
                version = plugin.getVersion().toString();
                if (id.startsWith("org.eclipse.oomph")) {
                    try {
                        Bundle[] bundles = Platform.getBundles((String)id, (String)version);
                        if (bundles == null) break block7;
                        Bundle[] bundleArray = bundles;
                        int n = bundles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Bundle bundle = bundleArray[n2];
                            String buildID = OomphPlugin.getBuildID((Bundle)bundle);
                            if (buildID != null) {
                                version = String.valueOf(version) + " Build " + buildID;
                                break;
                            }
                            ++n2;
                        }
                    }
                    catch (Exception ex) {
                        SetupInstallerPlugin.INSTANCE.log(ex);
                    }
                } else {
                    item.setForeground(this.gray);
                }
            }
            item.setText(1, version);
        }
        this.versionColumn.pack();
        this.versionColumn.setWidth(this.versionColumn.getWidth() + 10);
        this.table.getDisplay().asyncExec(new Runnable(){

            public void run() {
                AboutDialog.this.columnResizer.controlResized(null);
            }
        });
    }

    private List<IInstallableUnit> getPlugins() {
        ArrayList<IInstallableUnit> plugins = new ArrayList<IInstallableUnit>();
        block0: for (IInstallableUnit iu : this.profile.query(QueryUtil.createIUAnyQuery(), null)) {
            if (!this.showAllPlugins && !iu.getId().startsWith("org.eclipse.oomph")) continue;
            for (IProvidedCapability capability : iu.getProvidedCapabilities()) {
                if (!"osgi.bundle".equals(capability.getNamespace())) continue;
                plugins.add(iu);
                continue block0;
            }
        }
        return plugins;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        final Button showAllPluginsButton = this.createCheckbox(parent, "Show all plugins");
        showAllPluginsButton.setSelection(this.showAllPlugins);
        showAllPluginsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AboutDialog.this.showAllPlugins = showAllPluginsButton.getSelection();
                AboutDialog.this.dialogSettings.put(AboutDialog.SHOW_ALL_PLUGINS, AboutDialog.this.showAllPlugins);
                AboutDialog.this.table.removeAll();
                AboutDialog.this.fillTable();
            }
        });
        this.createButton(parent, 0, "Close", true);
    }

    protected String getShellText() {
        return PropertiesUtil.getProductName();
    }
}

